/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.declarative.jobs;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jenkinsci.Symbol;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.zowe.kotlinsdk.Dataset;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.kotlinsdk.zowe.client.sdk.zosfiles.ZosDsn;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.declarative.AbstractZosmfAction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J@\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/zowe/zdevops/declarative/jobs/WriteFileToDatasetDeclarative;", "Lorg/zowe/zdevops/declarative/AbstractZosmfAction;", "dsn", "", "file", "(Ljava/lang/String;Ljava/lang/String;)V", "exceptionMessage", "getExceptionMessage", "()Ljava/lang/String;", "perform", "", "run", "Lhudson/model/Run;", "workspace", "Lhudson/FilePath;", "env", "Lhudson/EnvVars;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/TaskListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "DescriptorImpl", "zdevops"})
@SourceDebugExtension(value={"SMAP\nWriteFileToDatasetDeclarative.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteFileToDatasetDeclarative.kt\norg/zowe/zdevops/declarative/jobs/WriteFileToDatasetDeclarative\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1855#2,2:73\n*S KotlinDebug\n*F\n+ 1 WriteFileToDatasetDeclarative.kt\norg/zowe/zdevops/declarative/jobs/WriteFileToDatasetDeclarative\n*L\n53#1:73,2\n*E\n"})
public final class WriteFileToDatasetDeclarative
extends AbstractZosmfAction {
    @NotNull
    private final String dsn;
    @NotNull
    private final String file;
    @NotNull
    private final String exceptionMessage;

    @DataBoundConstructor
    public WriteFileToDatasetDeclarative(@NotNull String dsn, @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.dsn = dsn;
        this.file = file;
        String string = Messages.zdevops_declarative_writing_DS_fail(this.dsn);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_declarative_writing_DS_fail(...)");
        this.exceptionMessage = string;
    }

    @Override
    @NotNull
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public void perform(@NotNull Run<?, ?> run, @NotNull FilePath workspace, @NotNull EnvVars env, @NotNull Launcher launcher, @NotNull TaskListener listener, @NotNull ZOSConnection zosConnection) {
        File file;
        Intrinsics.checkNotNullParameter(run, (String)"run");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        listener.getLogger().println(Messages.zdevops_declarative_writing_DS_from_file(this.dsn, this.file, zosConnection.getHost(), zosConnection.getZosmfPort()));
        Path filePath = Paths.get(this.file, new String[0]);
        if (filePath.isAbsolute()) {
            file = new File(this.file);
        } else {
            String string = workspace.getRemote();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRemote(...)");
            String string2 = workspace.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String workspacePath = StringsKt.replace$default((String)string, (String)string2, (String)"", (boolean)false, (int)4, null);
            file = new File(workspacePath + this.file);
        }
        File textFile = file;
        Dataset targetDS = new ZosDsn(zosConnection, null, 2, null).getDatasetInfo(this.dsn);
        if (targetDS.getRecordLength() == null) {
            throw new AbortException(Messages.zdevops_declarative_writing_DS_no_info(this.dsn));
        }
        int ineligibleStrings = 0;
        Iterable $this$forEach$iv = FilesKt.readLines$default((File)textFile, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            int n = it.length();
            Integer n2 = targetDS.getRecordLength();
            Intrinsics.checkNotNull((Object)n2);
            if (n <= n2) continue;
            ++ineligibleStrings;
        }
        if (ineligibleStrings > 0) {
            throw new AbortException(Messages.zdevops_declarative_writing_DS_ineligible_strings(ineligibleStrings, this.dsn));
        }
        String textString = StringsKt.replace$default((String)FilesKt.readText$default((File)textFile, null, (int)1, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
        ZosDsn zosDsn = new ZosDsn(zosConnection, null, 2, null);
        String string = textString;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        zosDsn.writeDsn(this.dsn, byArray);
        listener.getLogger().println(Messages.zdevops_declarative_writing_DS_success(this.dsn));
    }

    @Symbol(value={"writeFileToDS"})
    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/zowe/zdevops/declarative/jobs/WriteFileToDatasetDeclarative$DescriptorImpl;", "Lorg/zowe/zdevops/declarative/AbstractZosmfAction$Companion$DefaultBuildDescriptor;", "()V", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractZosmfAction.Companion.DefaultBuildDescriptor {
        public DescriptorImpl() {
            super("Write file to Dataset Declarative");
        }
    }
}

