/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.classic.steps;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.TaskListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.classic.AbstractBuildStep;
import org.zowe.zdevops.classic.steps.SubmitJobStep;
import org.zowe.zdevops.logic.SubmitJobOperationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ0\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/zowe/zdevops/classic/steps/SubmitJobStep;", "Lorg/zowe/zdevops/classic/AbstractBuildStep;", "connectionName", "", "jobName", "sync", "", "checkRC", "(Ljava/lang/String;Ljava/lang/String;ZZ)V", "getCheckRC", "()Z", "getJobName", "()Ljava/lang/String;", "getSync", "perform", "", "build", "Lhudson/model/AbstractBuild;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/BuildListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "DescriptorImpl", "zdevops"})
public final class SubmitJobStep
extends AbstractBuildStep {
    @NotNull
    private final String jobName;
    private final boolean sync;
    private final boolean checkRC;

    @DataBoundConstructor
    public SubmitJobStep(@NotNull String connectionName, @NotNull String jobName, boolean sync, boolean checkRC) {
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        super(connectionName);
        this.jobName = jobName;
        this.sync = sync;
        this.checkRC = checkRC;
    }

    @NotNull
    public final String getJobName() {
        return this.jobName;
    }

    public final boolean getSync() {
        return this.sync;
    }

    public final boolean getCheckRC() {
        return this.checkRC;
    }

    @Override
    public void perform(@NotNull AbstractBuild<?, ?> build, @NotNull Launcher launcher, @NotNull BuildListener listener, @NotNull ZOSConnection zosConnection) {
        Intrinsics.checkNotNullParameter(build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        if (this.sync) {
            Executor executor = build.getExecutor();
            Object object = executor != null ? executor.getCurrentWorkspace() : null;
            Intrinsics.checkNotNull((Object)object);
            FilePath workspace = object;
            Function3 linkBuilder2 = perform.linkBuilder.1.INSTANCE;
            String jobResult = SubmitJobOperationKt.submitJobSync(this.jobName, zosConnection, (TaskListener)listener, workspace, (String)build.getEnvironment((TaskListener)listener).get((Object)"JOB_URL"), (Function3<? super String, ? super String, ? super String, String>)linkBuilder2);
            if (this.checkRC && !StringsKt.equals$default((String)jobResult, (String)"CC 0000", (boolean)false, (int)2, null)) {
                throw new AbortException("Job RC code is not 0000");
            }
        } else {
            SubmitJobOperationKt.submitJob(this.jobName, zosConnection, (TaskListener)listener);
        }
    }

    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/zowe/zdevops/classic/steps/SubmitJobStep$DescriptorImpl;", "Lorg/zowe/zdevops/classic/AbstractBuildStep$Companion$DefaultBuildDescriptor;", "()V", "lastStepId", "", "marker", "", "createStepId", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractBuildStep.Companion.DefaultBuildDescriptor {
        private int lastStepId;
        @NotNull
        private final String marker;

        public DescriptorImpl() {
            String string = Messages.zdevops_classic_submitJobStep_display_name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_classic_submitJobStep_display_name(...)");
            super(string);
            this.marker = "SJ";
        }

        @JavaScriptMethod
        @NotNull
        public final synchronized String createStepId() {
            int n = this.lastStepId;
            this.lastStepId = n + 1;
            return this.marker + n;
        }
    }
}

