/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.classic.steps;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.classic.AbstractBuildStep;
import org.zowe.zdevops.logic.DownloadOperationKt;
import org.zowe.zdevops.utils.FieldsValidationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\r\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003J0\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0003H\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/zowe/zdevops/classic/steps/DownloadDatasetStep;", "Lorg/zowe/zdevops/classic/AbstractBuildStep;", "connectionName", "", "dsn", "(Ljava/lang/String;Ljava/lang/String;)V", "getDsn", "()Ljava/lang/String;", "returnEtag", "", "Ljava/lang/Boolean;", "vol", "getReturnEtag", "()Ljava/lang/Boolean;", "getVol", "perform", "", "build", "Lhudson/model/AbstractBuild;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/BuildListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "setReturnEtag", "setVol", "DescriptorImpl", "zdevops"})
public final class DownloadDatasetStep
extends AbstractBuildStep {
    @NotNull
    private final String dsn;
    @Nullable
    private String vol;
    @Nullable
    private Boolean returnEtag;

    @DataBoundConstructor
    public DownloadDatasetStep(@NotNull String connectionName, @NotNull String dsn) {
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        super(connectionName);
        this.dsn = dsn;
        this.returnEtag = true;
    }

    @NotNull
    public final String getDsn() {
        return this.dsn;
    }

    @DataBoundSetter
    public final void setVol(@NotNull String vol) {
        Intrinsics.checkNotNullParameter((Object)vol, (String)"vol");
        this.vol = StringsKt.isBlank((CharSequence)vol) ? null : vol;
    }

    @DataBoundSetter
    public final void setReturnEtag(boolean returnEtag) {
        this.returnEtag = returnEtag;
    }

    @Nullable
    public final String getVol() {
        return this.vol;
    }

    @Nullable
    public final Boolean getReturnEtag() {
        return this.returnEtag;
    }

    @Override
    public void perform(@NotNull AbstractBuild<?, ?> build, @NotNull Launcher launcher, @NotNull BuildListener listener, @NotNull ZOSConnection zosConnection) {
        Intrinsics.checkNotNullParameter(build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        Executor executor = build.getExecutor();
        Object object = executor != null ? executor.getCurrentWorkspace() : null;
        Intrinsics.checkNotNull((Object)object);
        FilePath workspace = object;
        DownloadOperationKt.downloadDSOrDSMemberByType(this.dsn, this.vol, this.returnEtag, (TaskListener)listener, zosConnection, workspace);
    }

    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/zowe/zdevops/classic/steps/DownloadDatasetStep$DescriptorImpl;", "Lorg/zowe/zdevops/classic/AbstractBuildStep$Companion$DefaultBuildDescriptor;", "()V", "doCheckDsn", "Lhudson/util/FormValidation;", "dsn", "", "doCheckVol", "vol", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractBuildStep.Companion.DefaultBuildDescriptor {
        public DescriptorImpl() {
            String string = Messages.zdevops_classic_downloadDatasetStep_display_name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_classic_download\u2026setStep_display_name(...)");
            super(string);
        }

        @Nullable
        public final FormValidation doCheckDsn(@QueryParameter @NotNull String dsn) {
            Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
            return FieldsValidationKt.validateDsnOrDsnMemberName(dsn);
        }

        @Nullable
        public final FormValidation doCheckVol(@QueryParameter @NotNull String vol) {
            Intrinsics.checkNotNullParameter((Object)vol, (String)"vol");
            return vol.length() > 7 ? FormValidation.warning((String)Messages.zdevops_volume_name_is_invalid_validation()) : FormValidation.ok();
        }
    }
}

