/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.zdevops.classic.steps;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.zowe.kotlinsdk.zowe.client.sdk.core.ZOSConnection;
import org.zowe.zdevops.Messages;
import org.zowe.zdevops.classic.AbstractBuildStep;
import org.zowe.zdevops.logic.DeleteOperationKt;
import org.zowe.zdevops.utils.FieldsValidationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/zowe/zdevops/classic/steps/DeleteDatasetStep;", "Lorg/zowe/zdevops/classic/AbstractBuildStep;", "connectionName", "", "dsn", "member", "failOnNotExist", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getDsn", "()Ljava/lang/String;", "getFailOnNotExist", "()Z", "getMember", "perform", "", "build", "Lhudson/model/AbstractBuild;", "launcher", "Lhudson/Launcher;", "listener", "Lhudson/model/BuildListener;", "zosConnection", "Lorg/zowe/kotlinsdk/zowe/client/sdk/core/ZOSConnection;", "DescriptorImpl", "zdevops"})
public final class DeleteDatasetStep
extends AbstractBuildStep {
    @NotNull
    private final String dsn;
    @Nullable
    private final String member;
    private final boolean failOnNotExist;

    @DataBoundConstructor
    public DeleteDatasetStep(@NotNull String connectionName, @NotNull String dsn, @Nullable String member, boolean failOnNotExist) {
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        super(connectionName);
        this.dsn = dsn;
        this.member = member;
        this.failOnNotExist = failOnNotExist;
    }

    public /* synthetic */ DeleteDatasetStep(String string, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, string2, string3, bl);
    }

    @NotNull
    public final String getDsn() {
        return this.dsn;
    }

    @Nullable
    public final String getMember() {
        return this.member;
    }

    public final boolean getFailOnNotExist() {
        return this.failOnNotExist;
    }

    @Override
    public void perform(@NotNull AbstractBuild<?, ?> build, @NotNull Launcher launcher, @NotNull BuildListener listener, @NotNull ZOSConnection zosConnection) {
        Intrinsics.checkNotNullParameter(build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)zosConnection, (String)"zosConnection");
        DeleteOperationKt.deleteDatasetOrMember(this.dsn, this.member, zosConnection, (TaskListener)listener, this.failOnNotExist);
    }

    @Extension
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/zowe/zdevops/classic/steps/DeleteDatasetStep$DescriptorImpl;", "Lorg/zowe/zdevops/classic/AbstractBuildStep$Companion$DefaultBuildDescriptor;", "()V", "doCheckDsn", "Lhudson/util/FormValidation;", "dsn", "", "doCheckMember", "member", "zdevops"})
    public static final class DescriptorImpl
    extends AbstractBuildStep.Companion.DefaultBuildDescriptor {
        public DescriptorImpl() {
            String string = Messages.zdevops_classic_deleteDatasetStep_display_name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdevops_classic_deleteDa\u2026setStep_display_name(...)");
            super(string);
        }

        @Nullable
        public final FormValidation doCheckDsn(@QueryParameter @NotNull String dsn) {
            Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
            return FieldsValidationKt.validateDatasetName(dsn);
        }

        @Nullable
        public final FormValidation doCheckMember(@QueryParameter @NotNull String member) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            return !StringsKt.isBlank((CharSequence)member) ? FieldsValidationKt.validateMemberName(member) : FormValidation.ok();
        }
    }
}

