// CHECKSTYLE:OFF

package org.zowe.zdevops;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code zdevops_declarative_DSN_downloading}: {@code Downloading
     * dataset {0} (volume:{1}) with connection: {2}:{3}.}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Downloading dataset {0} (volume:{1}) with connection: {2}:{3}.}
     */
    public static String zdevops_declarative_DSN_downloading(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("zdevops_declarative_DSN_downloading", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code zdevops_declarative_DSN_downloading}: {@code Downloading
     * dataset {0} (volume:{1}) with connection: {2}:{3}.}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Downloading dataset {0} (volume:{1}) with connection: {2}:{3}.}
     */
    public static Localizable _zdevops_declarative_DSN_downloading(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "zdevops_declarative_DSN_downloading", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code zdevops.value.must.be.positive.number.validation}: {@code
     * The field must be a positive number}.
     * 
     * @return
     *     {@code The field must be a positive number}
     */
    public static String zdevops_value_must_be_positive_number_validation() {
        return holder.format("zdevops.value.must.be.positive.number.validation");
    }

    /**
     * Key {@code zdevops.value.must.be.positive.number.validation}: {@code
     * The field must be a positive number}.
     * 
     * @return
     *     {@code The field must be a positive number}
     */
    public static Localizable _zdevops_value_must_be_positive_number_validation() {
        return new Localizable(holder, "zdevops.value.must.be.positive.number.validation");
    }

    /**
     * Key {@code zdevops_declarative_DSN_allocated_success}: {@code Dataset
     * {0} has been allocated successfully.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Dataset {0} has been allocated successfully.}
     */
    public static String zdevops_declarative_DSN_allocated_success(Object arg0) {
        return holder.format("zdevops_declarative_DSN_allocated_success", arg0);
    }

    /**
     * Key {@code zdevops_declarative_DSN_allocated_success}: {@code Dataset
     * {0} has been allocated successfully.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Dataset {0} has been allocated successfully.}
     */
    public static Localizable _zdevops_declarative_DSN_allocated_success(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_DSN_allocated_success", arg0);
    }

    /**
     * Key {@code zdevops.classic.deleteDatasetStep.display.name}: {@code
     * [z/OS] - Delete dataset/member}.
     * 
     * @return
     *     {@code [z/OS] - Delete dataset/member}
     */
    public static String zdevops_classic_deleteDatasetStep_display_name() {
        return holder.format("zdevops.classic.deleteDatasetStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.deleteDatasetStep.display.name}: {@code
     * [z/OS] - Delete dataset/member}.
     * 
     * @return
     *     {@code [z/OS] - Delete dataset/member}
     */
    public static Localizable _zdevops_classic_deleteDatasetStep_display_name() {
        return new Localizable(holder, "zdevops.classic.deleteDatasetStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.write.options.invalid}: {@code File option
     * is invalid}.
     * 
     * @return
     *     {@code File option is invalid}
     */
    public static String zdevops_classic_write_options_invalid() {
        return holder.format("zdevops.classic.write.options.invalid");
    }

    /**
     * Key {@code zdevops.classic.write.options.invalid}: {@code File option
     * is invalid}.
     * 
     * @return
     *     {@code File option is invalid}
     */
    public static Localizable _zdevops_classic_write_options_invalid() {
        return new Localizable(holder, "zdevops.classic.write.options.invalid");
    }

    /**
     * Key {@code zdevops_config_ZOSConnection_validation_unknownName}:
     * {@code Unknown z/OS Connection "{0}". Try to apply changes.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown z/OS Connection "{0}". Try to apply changes.}
     */
    public static String zdevops_config_ZOSConnection_validation_unknownName(Object arg0) {
        return holder.format("zdevops_config_ZOSConnection_validation_unknownName", arg0);
    }

    /**
     * Key {@code zdevops_config_ZOSConnection_validation_unknownName}:
     * {@code Unknown z/OS Connection "{0}". Try to apply changes.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown z/OS Connection "{0}". Try to apply changes.}
     */
    public static Localizable _zdevops_config_ZOSConnection_validation_unknownName(Object arg0) {
        return new Localizable(holder, "zdevops_config_ZOSConnection_validation_unknownName", arg0);
    }

    /**
     * Key {@code zdevops.classic.downloadDatasetStep.display.name}: {@code
     * [z/OS] - Download dataset/member}.
     * 
     * @return
     *     {@code [z/OS] - Download dataset/member}
     */
    public static String zdevops_classic_downloadDatasetStep_display_name() {
        return holder.format("zdevops.classic.downloadDatasetStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.downloadDatasetStep.display.name}: {@code
     * [z/OS] - Download dataset/member}.
     * 
     * @return
     *     {@code [z/OS] - Download dataset/member}
     */
    public static Localizable _zdevops_classic_downloadDatasetStep_display_name() {
        return new Localizable(holder, "zdevops.classic.downloadDatasetStep.display.name");
    }

    /**
     * Key {@code zdevops_deleting_ds}: {@code Deleting dataset {0} with
     * connection {1}:{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deleting dataset {0} with connection {1}:{2}}
     */
    public static String zdevops_deleting_ds(Object arg0, Object arg1, Object arg2) {
        return holder.format("zdevops_deleting_ds", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_deleting_ds}: {@code Deleting dataset {0} with
     * connection {1}:{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deleting dataset {0} with connection {1}:{2}}
     */
    public static Localizable _zdevops_deleting_ds(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "zdevops_deleting_ds", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops.classic.performTsoCommandStep.display.name}: {@code
     * [z/OS] - Perform TSO command}.
     * 
     * @return
     *     {@code [z/OS] - Perform TSO command}
     */
    public static String zdevops_classic_performTsoCommandStep_display_name() {
        return holder.format("zdevops.classic.performTsoCommandStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.performTsoCommandStep.display.name}: {@code
     * [z/OS] - Perform TSO command}.
     * 
     * @return
     *     {@code [z/OS] - Perform TSO command}
     */
    public static Localizable _zdevops_classic_performTsoCommandStep_display_name() {
        return new Localizable(holder, "zdevops.classic.performTsoCommandStep.display.name");
    }

    /**
     * Key {@code zdevops_declarative_writing_skip}: {@code No data was
     * provided. Add non-empty datasource to your pipeline call/step.}.
     * 
     * @return
     *     {@code No data was provided. Add non-empty datasource to your pipeline
     *     call/step.}
     */
    public static String zdevops_declarative_writing_skip() {
        return holder.format("zdevops_declarative_writing_skip");
    }

    /**
     * Key {@code zdevops_declarative_writing_skip}: {@code No data was
     * provided. Add non-empty datasource to your pipeline call/step.}.
     * 
     * @return
     *     {@code No data was provided. Add non-empty datasource to your pipeline
     *     call/step.}
     */
    public static Localizable _zdevops_declarative_writing_skip() {
        return new Localizable(holder, "zdevops_declarative_writing_skip");
    }

    /**
     * Key {@code zdevops_classic_ZOSJobs_submitted_success}: {@code JOB
     * submitted successfully. JOBID={0}, JOBNAME={1}, OWNER={2}.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code JOB submitted successfully. JOBID={0}, JOBNAME={1}, OWNER={2}.}
     */
    public static String zdevops_classic_ZOSJobs_submitted_success(Object arg0, Object arg1, Object arg2) {
        return holder.format("zdevops_classic_ZOSJobs_submitted_success", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_classic_ZOSJobs_submitted_success}: {@code JOB
     * submitted successfully. JOBID={0}, JOBNAME={1}, OWNER={2}.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code JOB submitted successfully. JOBID={0}, JOBNAME={1}, OWNER={2}.}
     */
    public static Localizable _zdevops_classic_ZOSJobs_submitted_success(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "zdevops_classic_ZOSJobs_submitted_success", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops.classic.write.options.workspace}: {@code Specify
     * Workspace Path}.
     * 
     * @return
     *     {@code Specify Workspace Path}
     */
    public static String zdevops_classic_write_options_workspace() {
        return holder.format("zdevops.classic.write.options.workspace");
    }

    /**
     * Key {@code zdevops.classic.write.options.workspace}: {@code Specify
     * Workspace Path}.
     * 
     * @return
     *     {@code Specify Workspace Path}
     */
    public static Localizable _zdevops_classic_write_options_workspace() {
        return new Localizable(holder, "zdevops.classic.write.options.workspace");
    }

    /**
     * Key {@code
     * zdevops.classic.allocateDatasetStep.blksize.smaller.than.lrecl.validation}:
     * {@code BLKSIZE can't be smaller than LRECL}.
     * 
     * @return
     *     {@code BLKSIZE can't be smaller than LRECL}
     */
    public static String zdevops_classic_allocateDatasetStep_blksize_smaller_than_lrecl_validation() {
        return holder.format("zdevops.classic.allocateDatasetStep.blksize.smaller.than.lrecl.validation");
    }

    /**
     * Key {@code
     * zdevops.classic.allocateDatasetStep.blksize.smaller.than.lrecl.validation}:
     * {@code BLKSIZE can't be smaller than LRECL}.
     * 
     * @return
     *     {@code BLKSIZE can't be smaller than LRECL}
     */
    public static Localizable _zdevops_classic_allocateDatasetStep_blksize_smaller_than_lrecl_validation() {
        return new Localizable(holder, "zdevops.classic.allocateDatasetStep.blksize.smaller.than.lrecl.validation");
    }

    /**
     * Key {@code zdevops_classic_ZOSJobs_submitting}: {@code Submitting a
     * JOB from file {0} with connection: {1}:{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Submitting a JOB from file {0} with connection: {1}:{2}}
     */
    public static String zdevops_classic_ZOSJobs_submitting(Object arg0, Object arg1, Object arg2) {
        return holder.format("zdevops_classic_ZOSJobs_submitting", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_classic_ZOSJobs_submitting}: {@code Submitting a
     * JOB from file {0} with connection: {1}:{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Submitting a JOB from file {0} with connection: {1}:{2}}
     */
    public static Localizable _zdevops_classic_ZOSJobs_submitting(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "zdevops_classic_ZOSJobs_submitting", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_deleting_ds_success}: {@code Successfully deleted}.
     * 
     * @return
     *     {@code Successfully deleted}
     */
    public static String zdevops_deleting_ds_success() {
        return holder.format("zdevops_deleting_ds_success");
    }

    /**
     * Key {@code zdevops_deleting_ds_success}: {@code Successfully deleted}.
     * 
     * @return
     *     {@code Successfully deleted}
     */
    public static Localizable _zdevops_deleting_ds_success() {
        return new Localizable(holder, "zdevops_deleting_ds_success");
    }

    /**
     * Key {@code
     * zdevops.classic.allocateDatasetStep.primary.is.zero.validation}:
     * {@code Primary space value must be greater than 0}.
     * 
     * @return
     *     {@code Primary space value must be greater than 0}
     */
    public static String zdevops_classic_allocateDatasetStep_primary_is_zero_validation() {
        return holder.format("zdevops.classic.allocateDatasetStep.primary.is.zero.validation");
    }

    /**
     * Key {@code
     * zdevops.classic.allocateDatasetStep.primary.is.zero.validation}:
     * {@code Primary space value must be greater than 0}.
     * 
     * @return
     *     {@code Primary space value must be greater than 0}
     */
    public static Localizable _zdevops_classic_allocateDatasetStep_primary_is_zero_validation() {
        return new Localizable(holder, "zdevops.classic.allocateDatasetStep.primary.is.zero.validation");
    }

    /**
     * Key {@code zdevops.classic.writeToFileStep.display.name}: {@code
     * [z/OS] - Write text to USS file}.
     * 
     * @return
     *     {@code [z/OS] - Write text to USS file}
     */
    public static String zdevops_classic_writeToFileStep_display_name() {
        return holder.format("zdevops.classic.writeToFileStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.writeToFileStep.display.name}: {@code
     * [z/OS] - Write text to USS file}.
     * 
     * @return
     *     {@code [z/OS] - Write text to USS file}
     */
    public static Localizable _zdevops_classic_writeToFileStep_display_name() {
        return new Localizable(holder, "zdevops.classic.writeToFileStep.display.name");
    }

    /**
     * Key {@code zdevops_deleting_datasets_by_mask_but_mask_is_empty}:
     * {@code Unable to delete: mask is empty}.
     * 
     * @return
     *     {@code Unable to delete: mask is empty}
     */
    public static String zdevops_deleting_datasets_by_mask_but_mask_is_empty() {
        return holder.format("zdevops_deleting_datasets_by_mask_but_mask_is_empty");
    }

    /**
     * Key {@code zdevops_deleting_datasets_by_mask_but_mask_is_empty}:
     * {@code Unable to delete: mask is empty}.
     * 
     * @return
     *     {@code Unable to delete: mask is empty}
     */
    public static Localizable _zdevops_deleting_datasets_by_mask_but_mask_is_empty() {
        return new Localizable(holder, "zdevops_deleting_datasets_by_mask_but_mask_is_empty");
    }

    /**
     * Key {@code zdevops_spool_content_error}: {@code Cannot get spool
     * content for {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot get spool content for {0}.}
     */
    public static String zdevops_spool_content_error(Object arg0) {
        return holder.format("zdevops_spool_content_error", arg0);
    }

    /**
     * Key {@code zdevops_spool_content_error}: {@code Cannot get spool
     * content for {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot get spool content for {0}.}
     */
    public static Localizable _zdevops_spool_content_error(Object arg0) {
        return new Localizable(holder, "zdevops_spool_content_error", arg0);
    }

    /**
     * Key {@code zdevops_declarative_DSN_allocated_fail}: {@code Cannot
     * allocate dataset {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot allocate dataset {0}.}
     */
    public static String zdevops_declarative_DSN_allocated_fail(Object arg0) {
        return holder.format("zdevops_declarative_DSN_allocated_fail", arg0);
    }

    /**
     * Key {@code zdevops_declarative_DSN_allocated_fail}: {@code Cannot
     * allocate dataset {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot allocate dataset {0}.}
     */
    public static Localizable _zdevops_declarative_DSN_allocated_fail(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_DSN_allocated_fail", arg0);
    }

    /**
     * Key {@code zdevops_config_ZOSConnection_validation_testDS}: {@code
     * HELLO.THERE}.
     * 
     * @return
     *     {@code HELLO.THERE}
     */
    public static String zdevops_config_ZOSConnection_validation_testDS() {
        return holder.format("zdevops_config_ZOSConnection_validation_testDS");
    }

    /**
     * Key {@code zdevops_config_ZOSConnection_validation_testDS}: {@code
     * HELLO.THERE}.
     * 
     * @return
     *     {@code HELLO.THERE}
     */
    public static Localizable _zdevops_config_ZOSConnection_validation_testDS() {
        return new Localizable(holder, "zdevops_config_ZOSConnection_validation_testDS");
    }

    /**
     * Key {@code zdevops.member.name.is.invalid.validation}: {@code It seems
     * the member name is invalid}.
     * 
     * @return
     *     {@code It seems the member name is invalid}
     */
    public static String zdevops_member_name_is_invalid_validation() {
        return holder.format("zdevops.member.name.is.invalid.validation");
    }

    /**
     * Key {@code zdevops.member.name.is.invalid.validation}: {@code It seems
     * the member name is invalid}.
     * 
     * @return
     *     {@code It seems the member name is invalid}
     */
    public static Localizable _zdevops_member_name_is_invalid_validation() {
        return new Localizable(holder, "zdevops.member.name.is.invalid.validation");
    }

    /**
     * Key {@code zdevops.classic.writeFileToFileStep.display.name}: {@code
     * [z/OS] - Write file to USS file}.
     * 
     * @return
     *     {@code [z/OS] - Write file to USS file}
     */
    public static String zdevops_classic_writeFileToFileStep_display_name() {
        return holder.format("zdevops.classic.writeFileToFileStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.writeFileToFileStep.display.name}: {@code
     * [z/OS] - Write file to USS file}.
     * 
     * @return
     *     {@code [z/OS] - Write file to USS file}
     */
    public static Localizable _zdevops_classic_writeFileToFileStep_display_name() {
        return new Localizable(holder, "zdevops.classic.writeFileToFileStep.display.name");
    }

    /**
     * Key {@code zdevops_declarative_DSN_downloaded_success}: {@code Dataset
     * {0} has been downloaded successfully.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Dataset {0} has been downloaded successfully.}
     */
    public static String zdevops_declarative_DSN_downloaded_success(Object arg0) {
        return holder.format("zdevops_declarative_DSN_downloaded_success", arg0);
    }

    /**
     * Key {@code zdevops_declarative_DSN_downloaded_success}: {@code Dataset
     * {0} has been downloaded successfully.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Dataset {0} has been downloaded successfully.}
     */
    public static Localizable _zdevops_declarative_DSN_downloaded_success(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_DSN_downloaded_success", arg0);
    }

    /**
     * Key {@code zdevops_deleting_ds_by_mask}: {@code Deleting datasets that
     * match the mask "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deleting datasets that match the mask "{0}"}
     */
    public static String zdevops_deleting_ds_by_mask(Object arg0) {
        return holder.format("zdevops_deleting_ds_by_mask", arg0);
    }

    /**
     * Key {@code zdevops_deleting_ds_by_mask}: {@code Deleting datasets that
     * match the mask "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deleting datasets that match the mask "{0}"}
     */
    public static Localizable _zdevops_deleting_ds_by_mask(Object arg0) {
        return new Localizable(holder, "zdevops_deleting_ds_by_mask", arg0);
    }

    /**
     * Key {@code zdevops_deleting_ds_fail_no_matching_mask}: {@code No data
     * sets matching the mask were found}.
     * 
     * @return
     *     {@code No data sets matching the mask were found}
     */
    public static String zdevops_deleting_ds_fail_no_matching_mask() {
        return holder.format("zdevops_deleting_ds_fail_no_matching_mask");
    }

    /**
     * Key {@code zdevops_deleting_ds_fail_no_matching_mask}: {@code No data
     * sets matching the mask were found}.
     * 
     * @return
     *     {@code No data sets matching the mask were found}
     */
    public static Localizable _zdevops_deleting_ds_fail_no_matching_mask() {
        return new Localizable(holder, "zdevops_deleting_ds_fail_no_matching_mask");
    }

    /**
     * Key {@code zdevops.value.up.to.eight.in.length.validation}: {@code The
     * field must be between 1 and 8 characters in length}.
     * 
     * @return
     *     {@code The field must be between 1 and 8 characters in length}
     */
    public static String zdevops_value_up_to_eight_in_length_validation() {
        return holder.format("zdevops.value.up.to.eight.in.length.validation");
    }

    /**
     * Key {@code zdevops.value.up.to.eight.in.length.validation}: {@code The
     * field must be between 1 and 8 characters in length}.
     * 
     * @return
     *     {@code The field must be between 1 and 8 characters in length}
     */
    public static Localizable _zdevops_value_up_to_eight_in_length_validation() {
        return new Localizable(holder, "zdevops.value.up.to.eight.in.length.validation");
    }

    /**
     * Key {@code zdevops.value.is.not.number.validation}: {@code Please
     * enter a valid number in the field}.
     * 
     * @return
     *     {@code Please enter a valid number in the field}
     */
    public static String zdevops_value_is_not_number_validation() {
        return holder.format("zdevops.value.is.not.number.validation");
    }

    /**
     * Key {@code zdevops.value.is.not.number.validation}: {@code Please
     * enter a valid number in the field}.
     * 
     * @return
     *     {@code Please enter a valid number in the field}
     */
    public static Localizable _zdevops_value_is_not_number_validation() {
        return new Localizable(holder, "zdevops.value.is.not.number.validation");
    }

    /**
     * Key {@code zdevops_config_ZOSConnection_validation_success}: {@code
     * Test connection was successful.}.
     * 
     * @return
     *     {@code Test connection was successful.}
     */
    public static String zdevops_config_ZOSConnection_validation_success() {
        return holder.format("zdevops_config_ZOSConnection_validation_success");
    }

    /**
     * Key {@code zdevops_config_ZOSConnection_validation_success}: {@code
     * Test connection was successful.}.
     * 
     * @return
     *     {@code Test connection was successful.}
     */
    public static Localizable _zdevops_config_ZOSConnection_validation_success() {
        return new Localizable(holder, "zdevops_config_ZOSConnection_validation_success");
    }

    /**
     * Key {@code zdevops_declarative_DSN_downloaded_fail}: {@code Cannot
     * download dataset {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot download dataset {0}.}
     */
    public static String zdevops_declarative_DSN_downloaded_fail(Object arg0) {
        return holder.format("zdevops_declarative_DSN_downloaded_fail", arg0);
    }

    /**
     * Key {@code zdevops_declarative_DSN_downloaded_fail}: {@code Cannot
     * download dataset {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot download dataset {0}.}
     */
    public static Localizable _zdevops_declarative_DSN_downloaded_fail(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_DSN_downloaded_fail", arg0);
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_ineligible_strings}: {@code
     * There is(are) {0} string(s) in your input text that are larger than
     * record length of {1}
     * Writing has been stopped.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code There is(are) {0} string(s) in your input text that are larger
     *     than record length of {1}
     *     Writing has been stopped.}
     */
    public static String zdevops_declarative_writing_DS_ineligible_strings(Object arg0, Object arg1) {
        return holder.format("zdevops_declarative_writing_DS_ineligible_strings", arg0, arg1);
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_ineligible_strings}: {@code
     * There is(are) {0} string(s) in your input text that are larger than
     * record length of {1}
     * Writing has been stopped.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code There is(are) {0} string(s) in your input text that are larger
     *     than record length of {1}
     *     Writing has been stopped.}
     */
    public static Localizable _zdevops_declarative_writing_DS_ineligible_strings(Object arg0, Object arg1) {
        return new Localizable(holder, "zdevops_declarative_writing_DS_ineligible_strings", arg0, arg1);
    }

    /**
     * Key {@code zdevops_config_ZOSConnection_validation_error}: {@code An
     * error occurred while connecting.}.
     * 
     * @return
     *     {@code An error occurred while connecting.}
     */
    public static String zdevops_config_ZOSConnection_validation_error() {
        return holder.format("zdevops_config_ZOSConnection_validation_error");
    }

    /**
     * Key {@code zdevops_config_ZOSConnection_validation_error}: {@code An
     * error occurred while connecting.}.
     * 
     * @return
     *     {@code An error occurred while connecting.}
     */
    public static Localizable _zdevops_config_ZOSConnection_validation_error() {
        return new Localizable(holder, "zdevops_config_ZOSConnection_validation_error");
    }

    /**
     * Key {@code zdevops_no_spool_files}: {@code There are no logs for
     * {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code There are no logs for {0}.}
     */
    public static String zdevops_no_spool_files(Object arg0) {
        return holder.format("zdevops_no_spool_files", arg0);
    }

    /**
     * Key {@code zdevops_no_spool_files}: {@code There are no logs for
     * {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code There are no logs for {0}.}
     */
    public static Localizable _zdevops_no_spool_files(Object arg0) {
        return new Localizable(holder, "zdevops_no_spool_files", arg0);
    }

    /**
     * Key {@code zdevops.classic.submitJobStep.display.name}: {@code [z/OS]
     * - Submit job}.
     * 
     * @return
     *     {@code [z/OS] - Submit job}
     */
    public static String zdevops_classic_submitJobStep_display_name() {
        return holder.format("zdevops.classic.submitJobStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.submitJobStep.display.name}: {@code [z/OS]
     * - Submit job}.
     * 
     * @return
     *     {@code [z/OS] - Submit job}
     */
    public static Localizable _zdevops_classic_submitJobStep_display_name() {
        return new Localizable(holder, "zdevops.classic.submitJobStep.display.name");
    }

    /**
     * Key {@code zdevops.declarative.ZOSJobs.submitted.waiting}: {@code
     * Waiting for a JOB finish...}.
     * 
     * @return
     *     {@code Waiting for a JOB finish...}
     */
    public static String zdevops_declarative_ZOSJobs_submitted_waiting() {
        return holder.format("zdevops.declarative.ZOSJobs.submitted.waiting");
    }

    /**
     * Key {@code zdevops.declarative.ZOSJobs.submitted.waiting}: {@code
     * Waiting for a JOB finish...}.
     * 
     * @return
     *     {@code Waiting for a JOB finish...}
     */
    public static Localizable _zdevops_declarative_ZOSJobs_submitted_waiting() {
        return new Localizable(holder, "zdevops.declarative.ZOSJobs.submitted.waiting");
    }

    /**
     * Key {@code zdevops.classic.writeFileToDatasetStep.display.name}:
     * {@code [z/OS] - Write file to dataset}.
     * 
     * @return
     *     {@code [z/OS] - Write file to dataset}
     */
    public static String zdevops_classic_writeFileToDatasetStep_display_name() {
        return holder.format("zdevops.classic.writeFileToDatasetStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.writeFileToDatasetStep.display.name}:
     * {@code [z/OS] - Write file to dataset}.
     * 
     * @return
     *     {@code [z/OS] - Write file to dataset}
     */
    public static Localizable _zdevops_classic_writeFileToDatasetStep_display_name() {
        return new Localizable(holder, "zdevops.classic.writeFileToDatasetStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.writeToDSStep.display.name}: {@code [z/OS]
     * - Write text to dataset}.
     * 
     * @return
     *     {@code [z/OS] - Write text to dataset}
     */
    public static String zdevops_classic_writeToDSStep_display_name() {
        return holder.format("zdevops.classic.writeToDSStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.writeToDSStep.display.name}: {@code [z/OS]
     * - Write text to dataset}.
     * 
     * @return
     *     {@code [z/OS] - Write text to dataset}
     */
    public static Localizable _zdevops_classic_writeToDSStep_display_name() {
        return new Localizable(holder, "zdevops.classic.writeToDSStep.display.name");
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_from_file}: {@code Writing
     * to dataset {0} from file {1} with connection: {2}:{3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Writing to dataset {0} from file {1} with connection: {2}:{3}}
     */
    public static String zdevops_declarative_writing_DS_from_file(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("zdevops_declarative_writing_DS_from_file", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_from_file}: {@code Writing
     * to dataset {0} from file {1} with connection: {2}:{3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Writing to dataset {0} from file {1} with connection: {2}:{3}}
     */
    public static Localizable _zdevops_declarative_writing_DS_from_file(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "zdevops_declarative_writing_DS_from_file", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code zdevops_deleting_ds_fail_dsn_param_empty}: {@code Unable to
     * delete: no dsn keyword present}.
     * 
     * @return
     *     {@code Unable to delete: no dsn keyword present}
     */
    public static String zdevops_deleting_ds_fail_dsn_param_empty() {
        return holder.format("zdevops_deleting_ds_fail_dsn_param_empty");
    }

    /**
     * Key {@code zdevops_deleting_ds_fail_dsn_param_empty}: {@code Unable to
     * delete: no dsn keyword present}.
     * 
     * @return
     *     {@code Unable to delete: no dsn keyword present}
     */
    public static Localizable _zdevops_deleting_ds_fail_dsn_param_empty() {
        return new Localizable(holder, "zdevops_deleting_ds_fail_dsn_param_empty");
    }

    /**
     * Key {@code zdevops.classic.writeToMemberStep.display.name}: {@code
     * [z/OS] - Write text to member}.
     * 
     * @return
     *     {@code [z/OS] - Write text to member}
     */
    public static String zdevops_classic_writeToMemberStep_display_name() {
        return holder.format("zdevops.classic.writeToMemberStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.writeToMemberStep.display.name}: {@code
     * [z/OS] - Write text to member}.
     * 
     * @return
     *     {@code [z/OS] - Write text to member}
     */
    public static Localizable _zdevops_classic_writeToMemberStep_display_name() {
        return new Localizable(holder, "zdevops.classic.writeToMemberStep.display.name");
    }

    /**
     * Key {@code zdevops.issue.TSO.command}: {@code [Perform TSO command] -
     * Issuing command "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Perform TSO command] - Issuing command "{0}"}
     */
    public static String zdevops_issue_TSO_command(Object arg0) {
        return holder.format("zdevops.issue.TSO.command", arg0);
    }

    /**
     * Key {@code zdevops.issue.TSO.command}: {@code [Perform TSO command] -
     * Issuing command "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [Perform TSO command] - Issuing command "{0}"}
     */
    public static Localizable _zdevops_issue_TSO_command(Object arg0) {
        return new Localizable(holder, "zdevops.issue.TSO.command", arg0);
    }

    /**
     * Key {@code zdevops_classic_ZOSJobs_submitted_fail}: {@code Cannot
     * submit or execute JOB from file {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot submit or execute JOB from file {0}.}
     */
    public static String zdevops_classic_ZOSJobs_submitted_fail(Object arg0) {
        return holder.format("zdevops_classic_ZOSJobs_submitted_fail", arg0);
    }

    /**
     * Key {@code zdevops_classic_ZOSJobs_submitted_fail}: {@code Cannot
     * submit or execute JOB from file {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot submit or execute JOB from file {0}.}
     */
    public static Localizable _zdevops_classic_ZOSJobs_submitted_fail(Object arg0) {
        return new Localizable(holder, "zdevops_classic_ZOSJobs_submitted_fail", arg0);
    }

    /**
     * Key {@code zdevops_declarative_ZOSJobs_getting_log}: {@code
     * Downloading execution log...}.
     * 
     * @return
     *     {@code Downloading execution log...}
     */
    public static String zdevops_declarative_ZOSJobs_getting_log() {
        return holder.format("zdevops_declarative_ZOSJobs_getting_log");
    }

    /**
     * Key {@code zdevops_declarative_ZOSJobs_getting_log}: {@code
     * Downloading execution log...}.
     * 
     * @return
     *     {@code Downloading execution log...}
     */
    public static Localizable _zdevops_declarative_ZOSJobs_getting_log() {
        return new Localizable(holder, "zdevops_declarative_ZOSJobs_getting_log");
    }

    /**
     * Key {@code zdevops_declarative_writing_file_fail}: {@code Cannot write
     * to Unix file {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot write to Unix file {0}}
     */
    public static String zdevops_declarative_writing_file_fail(Object arg0) {
        return holder.format("zdevops_declarative_writing_file_fail", arg0);
    }

    /**
     * Key {@code zdevops_declarative_writing_file_fail}: {@code Cannot write
     * to Unix file {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot write to Unix file {0}}
     */
    public static Localizable _zdevops_declarative_writing_file_fail(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_writing_file_fail", arg0);
    }

    /**
     * Key {@code
     * zdevops.classic.allocateDatasetStep.blksize.validation.warning}:
     * {@code Block size should be a multiple of the record length}.
     * 
     * @return
     *     {@code Block size should be a multiple of the record length}
     */
    public static String zdevops_classic_allocateDatasetStep_blksize_validation_warning() {
        return holder.format("zdevops.classic.allocateDatasetStep.blksize.validation.warning");
    }

    /**
     * Key {@code
     * zdevops.classic.allocateDatasetStep.blksize.validation.warning}:
     * {@code Block size should be a multiple of the record length}.
     * 
     * @return
     *     {@code Block size should be a multiple of the record length}
     */
    public static Localizable _zdevops_classic_allocateDatasetStep_blksize_validation_warning() {
        return new Localizable(holder, "zdevops.classic.allocateDatasetStep.blksize.validation.warning");
    }

    /**
     * Key {@code zdevops.declarative.ZOSJobs.submitted.success}: {@code JOB
     * submitted successfully. JOBID={0}, JOBNAME={1}, OWNER={2}.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code JOB submitted successfully. JOBID={0}, JOBNAME={1}, OWNER={2}.}
     */
    public static String zdevops_declarative_ZOSJobs_submitted_success(Object arg0, Object arg1, Object arg2) {
        return holder.format("zdevops.declarative.ZOSJobs.submitted.success", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops.declarative.ZOSJobs.submitted.success}: {@code JOB
     * submitted successfully. JOBID={0}, JOBNAME={1}, OWNER={2}.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code JOB submitted successfully. JOBID={0}, JOBNAME={1}, OWNER={2}.}
     */
    public static Localizable _zdevops_declarative_ZOSJobs_submitted_success(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "zdevops.declarative.ZOSJobs.submitted.success", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_success}: {@code Data has
     * been written to dataset {0} successfully.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Data has been written to dataset {0} successfully.}
     */
    public static String zdevops_declarative_writing_DS_success(Object arg0) {
        return holder.format("zdevops_declarative_writing_DS_success", arg0);
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_success}: {@code Data has
     * been written to dataset {0} successfully.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Data has been written to dataset {0} successfully.}
     */
    public static Localizable _zdevops_declarative_writing_DS_success(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_writing_DS_success", arg0);
    }

    /**
     * Key {@code zdevops.TSO.command.success}: {@code [Perform TSO command]
     * - The command has been successfully executed}.
     * 
     * @return
     *     {@code [Perform TSO command] - The command has been successfully
     *     executed}
     */
    public static String zdevops_TSO_command_success() {
        return holder.format("zdevops.TSO.command.success");
    }

    /**
     * Key {@code zdevops.TSO.command.success}: {@code [Perform TSO command]
     * - The command has been successfully executed}.
     * 
     * @return
     *     {@code [Perform TSO command] - The command has been successfully
     *     executed}
     */
    public static Localizable _zdevops_TSO_command_success() {
        return new Localizable(holder, "zdevops.TSO.command.success");
    }

    /**
     * Key {@code zdevops.value.must.not.be.empty.validation}: {@code Field
     * must not be empty}.
     * 
     * @return
     *     {@code Field must not be empty}
     */
    public static String zdevops_value_must_not_be_empty_validation() {
        return holder.format("zdevops.value.must.not.be.empty.validation");
    }

    /**
     * Key {@code zdevops.value.must.not.be.empty.validation}: {@code Field
     * must not be empty}.
     * 
     * @return
     *     {@code Field must not be empty}
     */
    public static Localizable _zdevops_value_must_not_be_empty_validation() {
        return new Localizable(holder, "zdevops.value.must.not.be.empty.validation");
    }

    /**
     * Key {@code zdevops.config.ZOSConnection.resolve.unknown}: {@code
     * Unknown z/OS connection {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown z/OS connection {0}}
     */
    public static String zdevops_config_ZOSConnection_resolve_unknown(Object arg0) {
        return holder.format("zdevops.config.ZOSConnection.resolve.unknown", arg0);
    }

    /**
     * Key {@code zdevops.config.ZOSConnection.resolve.unknown}: {@code
     * Unknown z/OS connection {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown z/OS connection {0}}
     */
    public static Localizable _zdevops_config_ZOSConnection_resolve_unknown(Object arg0) {
        return new Localizable(holder, "zdevops.config.ZOSConnection.resolve.unknown", arg0);
    }

    /**
     * Key {@code zdevops_config_ZOSConnectionList_validation_error}: {@code
     * Connection list is empty. Please, create a connection.
     *  It might be
     * done the following way:
     *  (1) Open "Manage Jenkins" page
     *  (2) Go to
     * Configure System
     *  (3) At the bottom of the page there is "z/OS
     * Connection List" section
     *  (4) Click "Add", fill in the form and test
     * the connection}.
     * 
     * @return
     *     {@code Connection list is empty. Please, create a connection.
     *      It
     *     might be done the following way:
     *      (1) Open "Manage Jenkins" page
     *      (2)
     *     Go to Configure System
     *      (3) At the bottom of the page there is "z/OS
     *     Connection List" section
     *      (4) Click "Add", fill in the form and test
     *     the connection}
     */
    public static String zdevops_config_ZOSConnectionList_validation_error() {
        return holder.format("zdevops_config_ZOSConnectionList_validation_error");
    }

    /**
     * Key {@code zdevops_config_ZOSConnectionList_validation_error}: {@code
     * Connection list is empty. Please, create a connection.
     *  It might be
     * done the following way:
     *  (1) Open "Manage Jenkins" page
     *  (2) Go to
     * Configure System
     *  (3) At the bottom of the page there is "z/OS
     * Connection List" section
     *  (4) Click "Add", fill in the form and test
     * the connection}.
     * 
     * @return
     *     {@code Connection list is empty. Please, create a connection.
     *      It
     *     might be done the following way:
     *      (1) Open "Manage Jenkins" page
     *      (2)
     *     Go to Configure System
     *      (3) At the bottom of the page there is "z/OS
     *     Connection List" section
     *      (4) Click "Add", fill in the form and test
     *     the connection}
     */
    public static Localizable _zdevops_config_ZOSConnectionList_validation_error() {
        return new Localizable(holder, "zdevops_config_ZOSConnectionList_validation_error");
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_from_input}: {@code Writing
     * to dataset {0} from input string with connection: {1}:{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Writing to dataset {0} from input string with connection:
     *     {1}:{2}}
     */
    public static String zdevops_declarative_writing_DS_from_input(Object arg0, Object arg1, Object arg2) {
        return holder.format("zdevops_declarative_writing_DS_from_input", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_from_input}: {@code Writing
     * to dataset {0} from input string with connection: {1}:{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Writing to dataset {0} from input string with connection:
     *     {1}:{2}}
     */
    public static Localizable _zdevops_declarative_writing_DS_from_input(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "zdevops_declarative_writing_DS_from_input", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops.classic.write.options.choose}: {@code Choose file
     * option}.
     * 
     * @return
     *     {@code Choose file option}
     */
    public static String zdevops_classic_write_options_choose() {
        return holder.format("zdevops.classic.write.options.choose");
    }

    /**
     * Key {@code zdevops.classic.write.options.choose}: {@code Choose file
     * option}.
     * 
     * @return
     *     {@code Choose file option}
     */
    public static Localizable _zdevops_classic_write_options_choose() {
        return new Localizable(holder, "zdevops.classic.write.options.choose");
    }

    /**
     * Key {@code zdevops.dataset.name.is.invalid.validation}: {@code It
     * seems the dataset name is invalid}.
     * 
     * @return
     *     {@code It seems the dataset name is invalid}
     */
    public static String zdevops_dataset_name_is_invalid_validation() {
        return holder.format("zdevops.dataset.name.is.invalid.validation");
    }

    /**
     * Key {@code zdevops.dataset.name.is.invalid.validation}: {@code It
     * seems the dataset name is invalid}.
     * 
     * @return
     *     {@code It seems the dataset name is invalid}
     */
    public static Localizable _zdevops_dataset_name_is_invalid_validation() {
        return new Localizable(holder, "zdevops.dataset.name.is.invalid.validation");
    }

    /**
     * Key {@code zdevops.classic.write.options.required}: {@code Select
     * field is required}.
     * 
     * @return
     *     {@code Select field is required}
     */
    public static String zdevops_classic_write_options_required() {
        return holder.format("zdevops.classic.write.options.required");
    }

    /**
     * Key {@code zdevops.classic.write.options.required}: {@code Select
     * field is required}.
     * 
     * @return
     *     {@code Select field is required}
     */
    public static Localizable _zdevops_classic_write_options_required() {
        return new Localizable(holder, "zdevops.classic.write.options.required");
    }

    /**
     * Key {@code zdevops.declarative.ZOSJobs.submitted.executed}: {@code JOB
     * was finished. Returned code: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code JOB was finished. Returned code: {0}.}
     */
    public static String zdevops_declarative_ZOSJobs_submitted_executed(Object arg0) {
        return holder.format("zdevops.declarative.ZOSJobs.submitted.executed", arg0);
    }

    /**
     * Key {@code zdevops.declarative.ZOSJobs.submitted.executed}: {@code JOB
     * was finished. Returned code: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code JOB was finished. Returned code: {0}.}
     */
    public static Localizable _zdevops_declarative_ZOSJobs_submitted_executed(Object arg0) {
        return new Localizable(holder, "zdevops.declarative.ZOSJobs.submitted.executed", arg0);
    }

    /**
     * Key {@code zdevops_declarative_DSN_allocating}: {@code Allocating
     * dataset {0} with connection: {1}:{2}.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Allocating dataset {0} with connection: {1}:{2}.}
     */
    public static String zdevops_declarative_DSN_allocating(Object arg0, Object arg1, Object arg2) {
        return holder.format("zdevops_declarative_DSN_allocating", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_declarative_DSN_allocating}: {@code Allocating
     * dataset {0} with connection: {1}:{2}.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Allocating dataset {0} with connection: {1}:{2}.}
     */
    public static Localizable _zdevops_declarative_DSN_allocating(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "zdevops_declarative_DSN_allocating", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_fail}: {@code Cannot write
     * to dataset {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot write to dataset {0}}
     */
    public static String zdevops_declarative_writing_DS_fail(Object arg0) {
        return holder.format("zdevops_declarative_writing_DS_fail", arg0);
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_fail}: {@code Cannot write
     * to dataset {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot write to dataset {0}}
     */
    public static Localizable _zdevops_declarative_writing_DS_fail(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_writing_DS_fail", arg0);
    }

    /**
     * Key {@code zdevops.volume.name.is.invalid.validation}: {@code It seems
     * the volume name is invalid}.
     * 
     * @return
     *     {@code It seems the volume name is invalid}
     */
    public static String zdevops_volume_name_is_invalid_validation() {
        return holder.format("zdevops.volume.name.is.invalid.validation");
    }

    /**
     * Key {@code zdevops.volume.name.is.invalid.validation}: {@code It seems
     * the volume name is invalid}.
     * 
     * @return
     *     {@code It seems the volume name is invalid}
     */
    public static Localizable _zdevops_volume_name_is_invalid_validation() {
        return new Localizable(holder, "zdevops.volume.name.is.invalid.validation");
    }

    /**
     * Key {@code zdevops.classic.deleteDatasetsByMaskStep.display.name}:
     * {@code [z/OS] - Delete datasets by mask}.
     * 
     * @return
     *     {@code [z/OS] - Delete datasets by mask}
     */
    public static String zdevops_classic_deleteDatasetsByMaskStep_display_name() {
        return holder.format("zdevops.classic.deleteDatasetsByMaskStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.deleteDatasetsByMaskStep.display.name}:
     * {@code [z/OS] - Delete datasets by mask}.
     * 
     * @return
     *     {@code [z/OS] - Delete datasets by mask}
     */
    public static Localizable _zdevops_classic_deleteDatasetsByMaskStep_display_name() {
        return new Localizable(holder, "zdevops.classic.deleteDatasetsByMaskStep.display.name");
    }

    /**
     * Key {@code zdevops_declarative_DSN_downloading_invalid_dsorg}: {@code
     * Cannot download this type of data set.}.
     * 
     * @return
     *     {@code Cannot download this type of data set.}
     */
    public static String zdevops_declarative_DSN_downloading_invalid_dsorg() {
        return holder.format("zdevops_declarative_DSN_downloading_invalid_dsorg");
    }

    /**
     * Key {@code zdevops_declarative_DSN_downloading_invalid_dsorg}: {@code
     * Cannot download this type of data set.}.
     * 
     * @return
     *     {@code Cannot download this type of data set.}
     */
    public static Localizable _zdevops_declarative_DSN_downloading_invalid_dsorg() {
        return new Localizable(holder, "zdevops_declarative_DSN_downloading_invalid_dsorg");
    }

    /**
     * Key {@code zdevops.declarative.ZOSJobs.submitting}: {@code Submitting
     * a JOB from file {0} with connection: {1}:{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Submitting a JOB from file {0} with connection: {1}:{2}}
     */
    public static String zdevops_declarative_ZOSJobs_submitting(Object arg0, Object arg1, Object arg2) {
        return holder.format("zdevops.declarative.ZOSJobs.submitting", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops.declarative.ZOSJobs.submitting}: {@code Submitting
     * a JOB from file {0} with connection: {1}:{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Submitting a JOB from file {0} with connection: {1}:{2}}
     */
    public static Localizable _zdevops_declarative_ZOSJobs_submitting(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "zdevops.declarative.ZOSJobs.submitting", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_declarative_writing_file_from_input}: {@code
     * Writing to Unix file {0} from input string with connection: {1}:{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Writing to Unix file {0} from input string with connection:
     *     {1}:{2}}
     */
    public static String zdevops_declarative_writing_file_from_input(Object arg0, Object arg1, Object arg2) {
        return holder.format("zdevops_declarative_writing_file_from_input", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_declarative_writing_file_from_input}: {@code
     * Writing to Unix file {0} from input string with connection: {1}:{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Writing to Unix file {0} from input string with connection:
     *     {1}:{2}}
     */
    public static Localizable _zdevops_declarative_writing_file_from_input(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "zdevops_declarative_writing_file_from_input", arg0, arg1, arg2);
    }

    /**
     * Key {@code zdevops_member_name_invalid}: {@code Invalid member name:
     * must be 1-8 characters}.
     * 
     * @return
     *     {@code Invalid member name: must be 1-8 characters}
     */
    public static String zdevops_member_name_invalid() {
        return holder.format("zdevops_member_name_invalid");
    }

    /**
     * Key {@code zdevops_member_name_invalid}: {@code Invalid member name:
     * must be 1-8 characters}.
     * 
     * @return
     *     {@code Invalid member name: must be 1-8 characters}
     */
    public static Localizable _zdevops_member_name_invalid() {
        return new Localizable(holder, "zdevops_member_name_invalid");
    }

    /**
     * Key {@code zdevops.config.ZOSConnection.validation.username.length}:
     * {@code z/OS usernames must not exceed 8 characters.}.
     * 
     * @return
     *     {@code z/OS usernames must not exceed 8 characters.}
     */
    public static String zdevops_config_ZOSConnection_validation_username_length() {
        return holder.format("zdevops.config.ZOSConnection.validation.username.length");
    }

    /**
     * Key {@code zdevops.config.ZOSConnection.validation.username.length}:
     * {@code z/OS usernames must not exceed 8 characters.}.
     * 
     * @return
     *     {@code z/OS usernames must not exceed 8 characters.}
     */
    public static Localizable _zdevops_config_ZOSConnection_validation_username_length() {
        return new Localizable(holder, "zdevops.config.ZOSConnection.validation.username.length");
    }

    /**
     * Key {@code zdevops_declarative_writing_file_from_file}: {@code Writing
     * to Unix file {0} from file {1} with connection: {2}:{3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Writing to Unix file {0} from file {1} with connection:
     *     {2}:{3}}
     */
    public static String zdevops_declarative_writing_file_from_file(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("zdevops_declarative_writing_file_from_file", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code zdevops_declarative_writing_file_from_file}: {@code Writing
     * to Unix file {0} from file {1} with connection: {2}:{3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Writing to Unix file {0} from file {1} with connection:
     *     {2}:{3}}
     */
    public static Localizable _zdevops_declarative_writing_file_from_file(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "zdevops_declarative_writing_file_from_file", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code zdevops.TSO.command.fail}: {@code [Perform TSO command] -
     * TSO command execution failed}.
     * 
     * @return
     *     {@code [Perform TSO command] - TSO command execution failed}
     */
    public static String zdevops_TSO_command_fail() {
        return holder.format("zdevops.TSO.command.fail");
    }

    /**
     * Key {@code zdevops.TSO.command.fail}: {@code [Perform TSO command] -
     * TSO command execution failed}.
     * 
     * @return
     *     {@code [Perform TSO command] - TSO command execution failed}
     */
    public static Localizable _zdevops_TSO_command_fail() {
        return new Localizable(holder, "zdevops.TSO.command.fail");
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_no_info}: {@code Cannot get
     * info about target dataset {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot get info about target dataset {0}}
     */
    public static String zdevops_declarative_writing_DS_no_info(Object arg0) {
        return holder.format("zdevops_declarative_writing_DS_no_info", arg0);
    }

    /**
     * Key {@code zdevops_declarative_writing_DS_no_info}: {@code Cannot get
     * info about target dataset {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot get info about target dataset {0}}
     */
    public static Localizable _zdevops_declarative_writing_DS_no_info(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_writing_DS_no_info", arg0);
    }

    /**
     * Key {@code zdevops.declarative.ZOSJobs.submitted.fail}: {@code Cannot
     * submit or execute JOB from file {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot submit or execute JOB from file {0}.}
     */
    public static String zdevops_declarative_ZOSJobs_submitted_fail(Object arg0) {
        return holder.format("zdevops.declarative.ZOSJobs.submitted.fail", arg0);
    }

    /**
     * Key {@code zdevops.declarative.ZOSJobs.submitted.fail}: {@code Cannot
     * submit or execute JOB from file {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot submit or execute JOB from file {0}.}
     */
    public static Localizable _zdevops_declarative_ZOSJobs_submitted_fail(Object arg0) {
        return new Localizable(holder, "zdevops.declarative.ZOSJobs.submitted.fail", arg0);
    }

    /**
     * Key {@code zdevops_declarative_ZOSJobs_got_log}: {@code Submission
     * log: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Submission log: {0}}
     */
    public static String zdevops_declarative_ZOSJobs_got_log(Object arg0) {
        return holder.format("zdevops_declarative_ZOSJobs_got_log", arg0);
    }

    /**
     * Key {@code zdevops_declarative_ZOSJobs_got_log}: {@code Submission
     * log: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Submission log: {0}}
     */
    public static Localizable _zdevops_declarative_ZOSJobs_got_log(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_ZOSJobs_got_log", arg0);
    }

    /**
     * Key {@code
     * zdevops_config_ZOSConnection_validation_wrong_credential_type}: {@code
     * Wrong credential type.}.
     * 
     * @return
     *     {@code Wrong credential type.}
     */
    public static String zdevops_config_ZOSConnection_validation_wrong_credential_type() {
        return holder.format("zdevops_config_ZOSConnection_validation_wrong_credential_type");
    }

    /**
     * Key {@code
     * zdevops_config_ZOSConnection_validation_wrong_credential_type}: {@code
     * Wrong credential type.}.
     * 
     * @return
     *     {@code Wrong credential type.}
     */
    public static Localizable _zdevops_config_ZOSConnection_validation_wrong_credential_type() {
        return new Localizable(holder, "zdevops_config_ZOSConnection_validation_wrong_credential_type");
    }

    /**
     * Key {@code zdevops.config.ZOSConnection.validation.empty}: {@code
     * Field is empty.}.
     * 
     * @return
     *     {@code Field is empty.}
     */
    public static String zdevops_config_ZOSConnection_validation_empty() {
        return holder.format("zdevops.config.ZOSConnection.validation.empty");
    }

    /**
     * Key {@code zdevops.config.ZOSConnection.validation.empty}: {@code
     * Field is empty.}.
     * 
     * @return
     *     {@code Field is empty.}
     */
    public static Localizable _zdevops_config_ZOSConnection_validation_empty() {
        return new Localizable(holder, "zdevops.config.ZOSConnection.validation.empty");
    }

    /**
     * Key {@code zdevops_declarative_writing_file_success}: {@code Data has
     * been written to Unix file {0} successfully.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Data has been written to Unix file {0} successfully.}
     */
    public static String zdevops_declarative_writing_file_success(Object arg0) {
        return holder.format("zdevops_declarative_writing_file_success", arg0);
    }

    /**
     * Key {@code zdevops_declarative_writing_file_success}: {@code Data has
     * been written to Unix file {0} successfully.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Data has been written to Unix file {0} successfully.}
     */
    public static Localizable _zdevops_declarative_writing_file_success(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_writing_file_success", arg0);
    }

    /**
     * Key {@code zdevops.classic.writeFileToMemberStep.display.name}: {@code
     * [z/OS] - Write file to member}.
     * 
     * @return
     *     {@code [z/OS] - Write file to member}
     */
    public static String zdevops_classic_writeFileToMemberStep_display_name() {
        return holder.format("zdevops.classic.writeFileToMemberStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.writeFileToMemberStep.display.name}: {@code
     * [z/OS] - Write file to member}.
     * 
     * @return
     *     {@code [z/OS] - Write file to member}
     */
    public static Localizable _zdevops_classic_writeFileToMemberStep_display_name() {
        return new Localizable(holder, "zdevops.classic.writeFileToMemberStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.write.options.local}: {@code Choose Local
     * File}.
     * 
     * @return
     *     {@code Choose Local File}
     */
    public static String zdevops_classic_write_options_local() {
        return holder.format("zdevops.classic.write.options.local");
    }

    /**
     * Key {@code zdevops.classic.write.options.local}: {@code Choose Local
     * File}.
     * 
     * @return
     *     {@code Choose Local File}
     */
    public static Localizable _zdevops_classic_write_options_local() {
        return new Localizable(holder, "zdevops.classic.write.options.local");
    }

    /**
     * Key {@code zdevops.classic.allocateDatasetStep.display.name}: {@code
     * [z/OS] - Allocate dataset}.
     * 
     * @return
     *     {@code [z/OS] - Allocate dataset}
     */
    public static String zdevops_classic_allocateDatasetStep_display_name() {
        return holder.format("zdevops.classic.allocateDatasetStep.display.name");
    }

    /**
     * Key {@code zdevops.classic.allocateDatasetStep.display.name}: {@code
     * [z/OS] - Allocate dataset}.
     * 
     * @return
     *     {@code [z/OS] - Allocate dataset}
     */
    public static Localizable _zdevops_classic_allocateDatasetStep_display_name() {
        return new Localizable(holder, "zdevops.classic.allocateDatasetStep.display.name");
    }

    /**
     * Key {@code zdevops_declarative_DSN_downloading_members}: {@code
     * Starting to download {0} members:}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting to download {0} members:}
     */
    public static String zdevops_declarative_DSN_downloading_members(Object arg0) {
        return holder.format("zdevops_declarative_DSN_downloading_members", arg0);
    }

    /**
     * Key {@code zdevops_declarative_DSN_downloading_members}: {@code
     * Starting to download {0} members:}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting to download {0} members:}
     */
    public static Localizable _zdevops_declarative_DSN_downloading_members(Object arg0) {
        return new Localizable(holder, "zdevops_declarative_DSN_downloading_members", arg0);
    }

    /**
     * Key {@code zdevops_deleting_ds_fail}: {@code Cannot perform deletion}.
     * 
     * @return
     *     {@code Cannot perform deletion}
     */
    public static String zdevops_deleting_ds_fail() {
        return holder.format("zdevops_deleting_ds_fail");
    }

    /**
     * Key {@code zdevops_deleting_ds_fail}: {@code Cannot perform deletion}.
     * 
     * @return
     *     {@code Cannot perform deletion}
     */
    public static Localizable _zdevops_deleting_ds_fail() {
        return new Localizable(holder, "zdevops_deleting_ds_fail");
    }

    /**
     * Key {@code zdevops_deleting_ds_member}: {@code Deleting member {0}
     * from dataset "{1}" with connection {2}:{3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deleting member {0} from dataset "{1}" with connection {2}:{3}}
     */
    public static String zdevops_deleting_ds_member(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("zdevops_deleting_ds_member", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code zdevops_deleting_ds_member}: {@code Deleting member {0}
     * from dataset "{1}" with connection {2}:{3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deleting member {0} from dataset "{1}" with connection {2}:{3}}
     */
    public static Localizable _zdevops_deleting_ds_member(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "zdevops_deleting_ds_member", arg0, arg1, arg2, arg3);
    }

}
