/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.wiz;

import hudson.AbortException;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import io.jenkins.plugins.wiz.PGPVerifier;
import io.jenkins.plugins.wiz.ParsedWizCliUrl;
import io.jenkins.plugins.wiz.WizCliSetup;
import io.jenkins.plugins.wiz.WizInputValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang3.SystemUtils;

public class WizCliDownloader {
    private static final Logger LOGGER = Logger.getLogger(WizCliDownloader.class.getName());
    private static final int DOWNLOAD_TIMEOUT = 60000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String PUBLIC_KEY_RESOURCE = "/io/jenkins/plugins/wiz/public_key.asc";

    public static WizCliSetup setupWizCli(FilePath workspace, String wizCliURL, TaskListener listener) throws IOException {
        try {
            ParsedWizCliUrl parsedUrl = WizInputValidator.parseWizCliUrl(wizCliURL);
            String[] osDetails = (String[])workspace.act((Callable)new MasterToSlaveCallable<String[], IOException>(){

                public String[] call() {
                    boolean isWindows = SystemUtils.IS_OS_WINDOWS;
                    return new String[]{String.valueOf(isWindows)};
                }
            });
            boolean isWindows = Boolean.parseBoolean(osDetails[0]);
            String cliFileName = isWindows ? "wizcli.exe" : "wizcli";
            FilePath cliPath = workspace.child(cliFileName);
            WizCliDownloader.downloadAndVerifyWizCli(parsedUrl, cliPath, workspace, listener);
            if (!isWindows) {
                cliPath.chmod(493);
            }
            return new WizCliSetup(isWindows, parsedUrl.getVersion());
        }
        catch (AbortException e) {
            listener.error("Invalid Wiz CLI URL format: " + e.getMessage());
            throw e;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private static void downloadAndVerifyWizCli(ParsedWizCliUrl parsedUrl, FilePath cliPath, FilePath workspace, TaskListener listener) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadAndVerifyWizCliFromCompressed(FilePath cliPath, FilePath workspace, TaskListener listener, String gzURL, FilePath publicKeyFile) throws IOException, InterruptedException {
        String gzSha256URL = gzURL + "-sha256";
        String gzSignatureURL = gzSha256URL + ".sig";
        FilePath gzTempFile = workspace.child("wizcli-download.gz");
        FilePath gzSha256File = workspace.child(gzTempFile.getName() + "-sha256");
        FilePath gzSignatureFile = workspace.child(gzSha256File.getName() + ".sig");
        try {
            listener.getLogger().println("Downloading compressed Wiz CLI from: " + gzURL);
            WizCliDownloader.downloadFile(gzSha256URL, gzSha256File);
            WizCliDownloader.downloadFile(gzSignatureURL, gzSignatureFile);
            FilePath parent = cliPath.getParent();
            if (parent == null) {
                throw new IOException("Invalid target path: parent directory is null");
            }
            WizCliDownloader.downloadFile(gzURL, gzTempFile);
            WizCliDownloader.verifySignatureAndChecksum(listener, gzTempFile, gzSha256File, gzSignatureFile, publicKeyFile, workspace);
            listener.getLogger().println("Compressed file verified, decompressing...");
            WizCliDownloader.decompressGzipFile(gzTempFile, cliPath);
            listener.getLogger().println("Download and decompression completed successfully");
        }
        finally {
            WizCliDownloader.cleanupFile(gzSha256File, listener);
            WizCliDownloader.cleanupFile(gzSignatureFile, listener);
            WizCliDownloader.cleanupFile(gzTempFile, listener);
        }
    }

    private static void cleanupFile(FilePath file, TaskListener listener) {
        try {
            if (file.exists()) {
                file.delete();
                LOGGER.log(Level.FINE, "Deleted verification file: {0}", file.getRemote());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to delete verification file: " + file.getRemote(), e);
            listener.getLogger().println("Warning: Failed to delete " + file.getRemote());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean urlExists(String fileURL) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(fileURL);
            ProxyConfiguration proxyConfig = Jenkins.get().getProxy();
            conn = (HttpURLConnection)(proxyConfig != null ? url.openConnection(proxyConfig.createProxy(url.getHost())) : url.openConnection());
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            int responseCode = conn.getResponseCode();
            boolean bl = responseCode == 200;
            return bl;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error checking if URL exists: " + fileURL, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static void decompressGzipFile(FilePath gzFile, FilePath targetPath) throws IOException, InterruptedException {
        try (InputStream fileInputStream = gzFile.read();
             GZIPInputStream gzipInputStream = new GZIPInputStream(fileInputStream);
             OutputStream outputStream = targetPath.write();){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = gzipInputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
    }

    private static void extractPublicKey(FilePath publicKeyFile) throws IOException {
        try (InputStream keyStream = WizCliDownloader.class.getResourceAsStream(PUBLIC_KEY_RESOURCE);){
            if (keyStream == null) {
                throw new IOException("Could not find public key resource");
            }
            String publicKey = new String(keyStream.readAllBytes(), StandardCharsets.UTF_8);
            publicKeyFile.write(publicKey, StandardCharsets.UTF_8.name());
            LOGGER.log(Level.FINE, "Public key extracted successfully");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to extract public key", e);
            throw new IOException("Failed to extract public key from resources", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadFile(String fileURL, FilePath targetPath) throws IOException {
        URL url = new URL(fileURL);
        HttpURLConnection conn = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            ProxyConfiguration proxyConfig = Jenkins.get().getProxy();
            try {
                conn = (HttpURLConnection)(proxyConfig != null ? url.openConnection(proxyConfig.createProxy(url.getHost())) : url.openConnection());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Invalid proxy configuration", e);
            }
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(60000);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("Download failed with HTTP code: " + responseCode);
            }
            FilePath parent = targetPath.getParent();
            if (parent == null) {
                throw new IOException("Invalid target path: parent directory is null");
            }
            try {
                parent.mkdirs();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Directory creation was interrupted", e);
            }
            inputStream = conn.getInputStream();
            try {
                int bytesRead;
                outputStream = targetPath.write();
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("File download was interrupted", e);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Error closing input stream", e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Error closing output stream", e);
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static void verifySignatureAndChecksum(TaskListener listener, FilePath cliPath, FilePath sha256File, FilePath signaturePath, FilePath publicKeyPath, FilePath workspace) throws IOException {
        try {
            boolean verified = (Boolean)workspace.act((Callable)new VerifySignatureCallable(sha256File, signaturePath, publicKeyPath));
            if (!verified) {
                throw new IOException("GPG signature verification failed");
            }
            WizCliDownloader.verifyChecksum(cliPath, sha256File);
            listener.getLogger().println("Successfully verified Wiz CLI signature and checksum");
        }
        catch (Exception e) {
            throw new IOException("GPG signature verification failed: " + e.getMessage(), e);
        }
    }

    private static void verifyChecksum(FilePath cliPath, FilePath sha256File) throws IOException, InterruptedException {
        String actualHash;
        String expectedHash = sha256File.readToString().trim();
        if (!expectedHash.equals(actualHash = WizCliDownloader.calculateSHA256(cliPath))) {
            throw new IOException("SHA256 checksum verification failed. Expected: " + expectedHash + ", Actual: " + actualHash);
        }
    }

    private static String calculateSHA256(FilePath filePath) throws IOException, InterruptedException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[8192];
            try (InputStream inputStream = filePath.read();){
                int bytesRead;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
            }
            byte[] hash = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new IOException("Failed to calculate SHA256: " + e.getMessage(), e);
        }
    }

    private static class VerifySignatureCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private final FilePath sha256File;
        private final FilePath signaturePath;
        private final FilePath publicKeyPath;

        public VerifySignatureCallable(FilePath sha256File, FilePath signaturePath, FilePath publicKeyPath) {
            this.sha256File = sha256File;
            this.signaturePath = signaturePath;
            this.publicKeyPath = publicKeyPath;
        }

        public Boolean call() throws IOException {
            try {
                PGPVerifier verifier = new PGPVerifier();
                return verifier.verifySignatureFromFiles(this.sha256File.getRemote(), this.signaturePath.getRemote(), this.publicKeyPath.getRemote());
            }
            catch (PGPVerifier.PGPVerificationException e) {
                throw new IOException("PGP verification failed", e);
            }
        }
    }
}

