/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.wiz;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.wiz.Messages;
import io.jenkins.plugins.wiz.WizCliRunner;
import io.jenkins.plugins.wiz.WizCliUtils;
import io.jenkins.plugins.wiz.WizInputValidator;
import io.jenkins.plugins.wiz.WizScannerAction;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class WizScannerBuilder
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(WizScannerBuilder.class.getName());
    private static final String DEFAULT_ARTIFACT_NAME = "wizscan.json";
    private static final String ARTIFACT_PREFIX = "wizscan-";
    private static final String ARTIFACT_SUFFIX = ".json";
    private static final String WIZ_ENV_KEY = "WIZ_ENV";
    public static final int OK_CODE = 0;
    private static volatile int buildId;
    private static volatile int count;
    private final String userInput;

    @DataBoundConstructor
    public WizScannerBuilder(String userInput) {
        this.userInput = StringUtils.trimToEmpty((String)userInput);
    }

    public String getUserInput() {
        return this.userInput;
    }

    private static synchronized int getNextCount() {
        return ++count;
    }

    private static synchronized void resetCount() {
        count = 1;
    }

    private ArtifactInfo determineArtifactName(int currentBuildId) {
        if (currentBuildId != buildId) {
            buildId = currentBuildId;
            WizScannerBuilder.resetCount();
            return new ArtifactInfo(DEFAULT_ARTIFACT_NAME, null);
        }
        String suffix = String.valueOf(WizScannerBuilder.getNextCount());
        return new ArtifactInfo(ARTIFACT_PREFIX + suffix + ARTIFACT_SUFFIX, suffix);
    }

    public void perform(@NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        try {
            LOGGER.log(Level.FINE, "Starting Wiz Scanner build step for build {0}", build.getDisplayName());
            DescriptorImpl descriptor = this.getDescriptor();
            EnvVars envVars = build.getEnvironment(listener);
            WizInputValidator.validateConfiguration(descriptor.getWizClientId(), descriptor.getWizSecretKey(), descriptor.getWizCliURL());
            this.setupEnvironment(envVars, descriptor.getWizEnv());
            ArtifactInfo artifactInfo = this.determineArtifactName(build.hashCode());
            int exitCode = WizCliRunner.execute(workspace, envVars, launcher, listener, descriptor.getWizCliURL(), descriptor.getWizClientId(), descriptor.getWizSecretKey(), this.userInput, artifactInfo.name);
            this.processResults(build, exitCode, workspace, listener, artifactInfo);
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AbortException("Wiz scan failed: " + e.getMessage());
        }
    }

    private void setupEnvironment(EnvVars envVars, String wizEnv) {
        if (StringUtils.isNotBlank((CharSequence)wizEnv)) {
            envVars.put(WIZ_ENV_KEY, wizEnv);
            LOGGER.log(Level.FINE, "Set WIZ_ENV to {0}", wizEnv);
        }
    }

    private void processResults(Run<?, ?> build, int exitCode, FilePath workspace, TaskListener listener, ArtifactInfo artifactInfo) throws IOException {
        FilePath resultFile = workspace.child(artifactInfo.name);
        try {
            if (resultFile.exists() && resultFile.length() > 0L) {
                build.addAction((Action)new WizScannerAction(build, workspace, artifactInfo.suffix, artifactInfo.name));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while checking results file", e);
        }
        try {
            WizCliUtils.cleanupArtifacts(build, workspace, listener, artifactInfo.name);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error during artifact cleanup", e);
        }
        if (exitCode != 0) {
            throw new AbortException("Wiz scanning failed with exit code: " + exitCode);
        }
        LOGGER.log(Level.FINE, "Wiz scan completed successfully");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static class ArtifactInfo {
        final String name;
        final String suffix;

        ArtifactInfo(String name, String suffix) {
            this.name = name;
            this.suffix = suffix;
        }
    }

    @Symbol(value={"wizcli"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String wizClientId;
        private Secret wizSecretKey;
        private String wizCliURL;
        private String wizEnv;

        public DescriptorImpl() {
            this.load();
        }

        @RequirePOST
        @SuppressFBWarnings(value={"SECURITY"})
        public FormValidation doCheckUserInput(@QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.error((String)Messages.WizScannerBuilder_DescriptorImpl_errors_missingName());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.WizScannerBuilder_DescriptorImpl_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.wizClientId = formData.getString("wizClientId");
            this.wizSecretKey = Secret.fromString((String)formData.getString("wizSecretKey"));
            this.wizCliURL = formData.getString("wizCliURL");
            this.wizEnv = formData.getString("wizEnv");
            this.save();
            return super.configure(req, formData);
        }

        public String getWizClientId() {
            return this.wizClientId;
        }

        public Secret getWizSecretKey() {
            return this.wizSecretKey;
        }

        public String getWizCliURL() {
            return this.wizCliURL;
        }

        public String getWizEnv() {
            return this.wizEnv;
        }
    }
}

