/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.webhookexternalstore;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import io.jenkins.plugins.webhookexternalstore.WebhookConfiguration;
import io.jenkins.plugins.webhookexternalstore.WebhookCredentialsProvider;
import io.jenkins.plugins.webhookexternalstore.WebhookPayload;
import io.jenkins.plugins.webhookexternalstore.exceptions.CredentialsConvertionException;
import java.io.BufferedReader;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class WebhookEndpoint
implements UnprotectedRootAction {
    private static final Logger LOG = LoggerFactory.getLogger(WebhookEndpoint.class);
    static final String WEBHOOK_PATH = "webhook-credentials";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return WEBHOOK_PATH;
    }

    @POST
    public void doUpdate(StaplerRequest2 request, StaplerResponse2 response) throws IOException {
        try {
            if (!this.authenticateRequest(request)) {
                LOG.warn("Unauthorized webhook request from {}: missing or invalid Bearer token", (Object)request.getRemoteAddr());
                response.sendError(401, "Unauthorized: Bearer token authentication required");
                return;
            }
            WebhookPayload payload = this.parsePayload(request);
            LOG.debug("Received authenticated webhook payload: {}", (Object)payload);
            WebhookCredentialsProvider provider = WebhookCredentialsProvider.getInstance();
            provider.addOrUpdateCredential(payload);
            LOG.info("Successfully processed webhook credential: id={}, type={}", (Object)payload.getId(), (Object)payload.getType());
            response.setStatus(200);
        }
        catch (CredentialsConvertionException e) {
            LOG.warn("Failed to convert webhook payload to credential: {}", (Object)e.getMessage());
            response.sendError(400, e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Unexpected error processing webhook request: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, "Unexpected error processing webhook request: " + e.getMessage());
        }
    }

    private WebhookPayload parsePayload(StaplerRequest2 request) throws CredentialsConvertionException {
        try {
            JSONObject json = JSONObject.fromObject((Object)WebhookEndpoint.getString(request));
            return WebhookPayload.fromJSON(json);
        }
        catch (IOException e) {
            LOG.error("Error parsing webhook JSON payload: {}", (Object)e.getMessage(), (Object)e);
            throw new CredentialsConvertionException("Error parsing webhook JSON payload: " + e.getMessage(), e);
        }
    }

    private static String getString(StaplerRequest2 request) throws CredentialsConvertionException, IOException {
        String contentType = request.getContentType();
        if (contentType == null || !contentType.contains("application/json")) {
            throw new CredentialsConvertionException("Invalid Content-Type. Expected application/json but got: " + contentType);
        }
        StringBuilder jsonBuffer = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                jsonBuffer.append(line);
            }
        }
        String jsonString = jsonBuffer.toString();
        if (jsonString.trim().isEmpty()) {
            throw new CredentialsConvertionException("Empty JSON payload in webhook request");
        }
        return jsonString;
    }

    private boolean authenticateRequest(StaplerRequest2 request) {
        WebhookConfiguration config = WebhookConfiguration.getInstance();
        if (!config.isTokenConfigured()) {
            LOG.error("No Bearer token configured for webhook authentication");
            return false;
        }
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || authHeader.trim().isEmpty()) {
            LOG.debug("Missing Authorization header in webhook request");
            return false;
        }
        if (!authHeader.startsWith("Bearer ")) {
            LOG.debug("Invalid Authorization header format, expected Bearer token");
            return false;
        }
        String providedToken = authHeader.substring("Bearer ".length()).trim();
        boolean isValid = config.isValidBearerToken(providedToken);
        if (isValid) {
            LOG.debug("Webhook request authenticated successfully");
        } else {
            LOG.debug("Invalid Bearer token provided in webhook request");
        }
        return isValid;
    }
}

