/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.VisualExpert;

import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import io.jenkins.plugins.VisualExpert.VisualExpertBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Scanner;

public class VisualExpertHelper {
    private static final String DEFAULT_VISUALEXPERTCOMMANDOUTPUTFILE_PATH = "\\Novalys\\VisualExpert\\Jenkins\\commandoutput.txt";
    private static final String DEFAULT_PROJECTFILE_PATH = "\\Novalys\\VisualExpert\\Jenkins\\ProjectList.txt";

    public static ArgumentListBuilder GetCommandLine(String cmdArg) {
        ArgumentListBuilder CmdArgs = new ArgumentListBuilder();
        CmdArgs.addTokenized(cmdArg);
        return CmdArgs;
    }

    public static ArrayList<String> ReadProjectsFile(String installPath) {
        ArrayList<String> projects = VisualExpertBuilder.VEProjectsLister.getInstance(installPath, DEFAULT_PROJECTFILE_PATH).getProjects();
        if (projects == null || projects.isEmpty()) {
            VisualExpertBuilder.VEProjectsLister.instance = null;
        }
        return projects;
    }

    public static String GetVisualExpertCommandOutputFile() {
        String programDataFolder = System.getenv("PROGRAMDATA");
        String fileName = programDataFolder + DEFAULT_VISUALEXPERTCOMMANDOUTPUTFILE_PATH;
        return fileName;
    }

    public static TaskListener GetVisualExpertCommandOutputListener(String logsFileName) {
        try {
            File fileObj = new File(logsFileName);
            StreamBuildListener listener = new StreamBuildListener(fileObj, Charset.forName("UTF-8"));
            return listener;
        }
        catch (FileNotFoundException ex) {
            System.out.println("GetVisualExpertCommandOutputListener -> FileNotFoundException occurred " + ex.getMessage());
        }
        catch (IOException x) {
            System.out.println("GetVisualExpertCommandOutputListener -> IOException occurred in " + logsFileName + x.getMessage());
        }
        catch (Exception e) {
            System.out.println("GetVisualExpertCommandOutputListener -> Exception occurred in " + logsFileName + e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean VerifyOutput(String outputFileName, String compareString, boolean negateComparison, TaskListener listener) {
        Scanner projectScanner = null;
        try {
            File projectFile = new File(outputFileName);
            projectScanner = new Scanner(projectFile, "UTF-8");
            while (true) {
                if (projectScanner.hasNextLine()) {
                    String line = projectScanner.nextLine();
                    listener.getLogger().println(line);
                    if (!line.contains(compareString)) continue;
                    boolean bl = negateComparison;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            listener.getLogger().println("VerifyOutput -> Exception occurred in file: " + outputFileName);
        }
        finally {
            try {
                if (projectScanner != null) {
                    projectScanner.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

