/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.VisualExpert;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import io.jenkins.plugins.VisualExpert.Messages;
import io.jenkins.plugins.VisualExpert.VisualExpertBuilder;
import java.io.File;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public final class VisualExpertInstallation
extends ToolInstallation
implements NodeSpecific<VisualExpertInstallation>,
EnvironmentSpecific<VisualExpertInstallation> {
    private static final long serialVersionUID = 1L;
    private final String defaultArgs;

    @DataBoundConstructor
    public VisualExpertInstallation(String name, String home, String defaultArgs) {
        super(name, home, null);
        this.defaultArgs = Util.fixEmpty((String)defaultArgs);
    }

    public VisualExpertInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new VisualExpertInstallation(this.getName(), this.translateFor(node, log), this.getDefaultArgs());
    }

    public VisualExpertInstallation forEnvironment(EnvVars environment) {
        return new VisualExpertInstallation(this.getName(), environment.expand(this.getHome()), this.getDefaultArgs());
    }

    public String getDefaultArgs() {
        return this.defaultArgs;
    }

    @Extension
    @Symbol(value={"visualexpertinstallation"})
    public static class DescriptorImpl
    extends ToolDescriptor<VisualExpertInstallation> {
        public String getDisplayName() {
            return "Visual Expert";
        }

        public VisualExpertInstallation[] getInstallations() {
            return this.getDescriptor().getInstallations();
        }

        public void setInstallations(VisualExpertInstallation ... installations) {
            this.getDescriptor().setInstallations(installations);
        }

        private VisualExpertBuilder.Descriptor getDescriptor() {
            Jenkins jenkins = Jenkins.get();
            if (jenkins != null && jenkins.getDescriptorByType(VisualExpertBuilder.Descriptor.class) != null) {
                return (VisualExpertBuilder.Descriptor)jenkins.getDescriptorByType(VisualExpertBuilder.Descriptor.class);
            }
            throw new NullPointerException("VisualExpertBuilder.Descriptor is null");
        }

        @POST
        public FormValidation doCheckHome(@QueryParameter File value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String installationPath = value.getPath();
            if (Util.fixEmptyAndTrim((String)installationPath) == null) {
                return FormValidation.error((String)Messages.VisualExpertBuilder_DescriptorImpl_errors_missingInstallPath());
            }
            String pathVEExe = VisualExpertBuilder.getConsoleExePath(installationPath);
            if (!pathVEExe.toUpperCase().endsWith("NOVALYS.VISUALEXPERT.CONSOLE.COMMANDLINE.EXE")) {
                return FormValidation.error((String)Messages.VisualExpertBuilder_DescriptorImpl_errors_invalidPath());
            }
            File f = new File(pathVEExe);
            if (!f.exists()) {
                return FormValidation.error((String)Messages.VisualExpertBuilder_DescriptorImpl_errors_installPathNotExist());
            }
            return FormValidation.ok();
        }
    }
}

