/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.validating_yaml_parameter;

import hudson.AbortException;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.StringParameterValue;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ValidatingYamlParameterValue
extends StringParameterValue {
    private boolean syntaxHighlighting;
    private String failedValidationMessage;

    @DataBoundConstructor
    public ValidatingYamlParameterValue(String name, String value) {
        super(name, value);
    }

    public ValidatingYamlParameterValue(String name, String value, String failedValidationMessage) {
        super(name, value);
        this.failedValidationMessage = failedValidationMessage;
    }

    public ValidatingYamlParameterValue(String name, String value, String failedValidationMessage, String description) {
        super(name, value, description);
        this.failedValidationMessage = failedValidationMessage;
    }

    public String getFailedValidationMessage() {
        return this.failedValidationMessage;
    }

    @DataBoundSetter
    public void setFailedValidationMessage(String failedValidationMessage) {
        this.failedValidationMessage = failedValidationMessage;
    }

    private boolean doCheckYaml(String value) {
        LoaderOptions options = new LoaderOptions();
        SafeConstructor constructor = new SafeConstructor(options);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        try {
            yaml.load(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        if (!this.doCheckYaml(this.value)) {
            return new BuildWrapper(){

                public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                    throw new AbortException("Invalue value for parameter [" + ValidatingYamlParameterValue.this.getName() + "] specified: " + ValidatingYamlParameterValue.this.value);
                }
            };
        }
        return null;
    }

    public int hashCode() {
        int prime = 71;
        int result = super.hashCode();
        result = 71 * result;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ValidatingYamlParameterValue other = (ValidatingYamlParameterValue)((Object)obj);
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public String toString() {
        return "(ValidatingYamlParameterValue) " + this.getName() + "='" + this.value + "'";
    }
}

