/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.validating_yaml_parameter;

import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.security.Permission;
import hudson.util.FormValidation;
import io.jenkins.plugins.validating_yaml_parameter.ValidatingYamlParameterValue;
import io.jenkins.plugins.validating_yaml_parameter.ValidationResult;
import java.io.IOException;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ValidatingYamlParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 900032072543915L;
    private static final Logger LOGGER = Logger.getLogger(ValidatingYamlParameterDefinition.class.getName());
    private String defaultValue;
    private String failedValidationMessage;
    private static boolean result;
    private String value;

    @DataBoundConstructor
    public ValidatingYamlParameterDefinition(String name, String defaultValue, String failedValidationMessage, String description) {
        super(name);
        this.setDescription(description);
        this.defaultValue = defaultValue;
        this.failedValidationMessage = failedValidationMessage;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getValue() {
        return this.defaultValue;
    }

    public String getName() {
        return super.getName();
    }

    public String getDescription() {
        return super.getDescription();
    }

    public String getFailedValidationMessage() {
        return this.failedValidationMessage;
    }

    public ValidatingYamlParameterValue getDefaultParameterValue() {
        ValidatingYamlParameterValue v = new ValidatingYamlParameterValue(this.getName(), this.defaultValue);
        return v;
    }

    private static ValidationResult doCheckYaml(String value) {
        ValidationResult vres = new ValidationResult();
        LoaderOptions options = new LoaderOptions();
        SafeConstructor constructor = new SafeConstructor(options);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        try {
            yaml.load(value);
            vres.setResult(true);
        }
        catch (Exception e) {
            vres.setResult(false);
            vres.setError(e.toString());
        }
        return vres;
    }

    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        ValidatingYamlParameterValue value = (ValidatingYamlParameterValue)((Object)req.bindJSON(ValidatingYamlParameterValue.class, jo));
        String req_value = value.getValue();
        ValidationResult vres = ValidatingYamlParameterDefinition.doCheckYaml(req_value);
        if (!vres.getResult()) {
            throw new Failure("Req: Invalid YAML syntax for parameter [" + this.getName() + "] specified: " + req_value);
        }
        return value;
    }

    public ParameterValue createValue(StaplerRequest2 req) {
        String[] value = req.getParameterValues(this.getName());
        if (value == null || value.length < 1) {
            return this.getDefaultParameterValue();
        }
        ValidationResult vres = ValidatingYamlParameterDefinition.doCheckYaml(value[0]);
        if (!vres.getResult()) {
            throw new Failure("Req: Invalid value for parameter [" + this.getName() + "] specified: " + value[0]);
        }
        return new ValidatingYamlParameterValue(this.getName(), value[0]);
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        if (value == null || value.isEmpty()) {
            return this.getDefaultParameterValue();
        }
        ValidationResult vres = ValidatingYamlParameterDefinition.doCheckYaml(value);
        if (!vres.getResult()) {
            throw new AbortException("Invalid value for parameter [" + this.getName() + "] specified: " + value);
        }
        return new ValidatingYamlParameterValue(this.getName(), value, this.failedValidationMessage);
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof ValidatingYamlParameterValue) {
            ValidatingYamlParameterValue value = (ValidatingYamlParameterValue)defaultValue;
            return new ValidatingYamlParameterDefinition(this.getName(), value.value, this.getFailedValidationMessage(), this.getDescription());
        }
        return this;
    }

    @Extension
    @Symbol(value={"validatingYamlParameter"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Validating Yaml Parameter";
        }

        @POST
        public FormValidation doValidate(@QueryParameter(value="value") String value, @QueryParameter(value="failedValidationMessage") String failedValidationMessage, @AncestorInPath Item item) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Permission.CONFIGURE);
            ValidationResult vres = ValidatingYamlParameterDefinition.doCheckYaml(value);
            if (vres.getResult()) {
                return FormValidation.ok();
            }
            return failedValidationMessage == null || failedValidationMessage.isEmpty() ? FormValidation.error((String)("Invalid yaml string: " + vres.getError())) : FormValidation.error((String)failedValidationMessage);
        }
    }
}

