/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.slsa;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import io.jenkins.plugins.slsa.Messages;
import io.jenkins.plugins.slsa.ProvenanceAction;
import io.jenkins.plugins.slsa.generator.ProvenanceV0_2Generator;
import io.jenkins.plugins.slsa.model.BuildInfo;
import io.jenkins.plugins.slsa.model.SubjectInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import jenkins.tasks.SimpleBuildStep;
import org.eclipsefdn.security.slsa.attestation.io.AttestationWriter;
import org.eclipsefdn.security.slsa.attestation.model.SignedAttestation;
import org.eclipsefdn.security.slsa.attestation.util.Json;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ProvenanceRecorder
extends Recorder
implements SimpleBuildStep {
    private String artifactFilter;
    private String targetDirectory;

    @DataBoundConstructor
    public ProvenanceRecorder(String artifactFilter, String targetDirectory) {
        this.setArtifactFilter(artifactFilter);
        this.setTargetDirectory(targetDirectory);
    }

    public String getArtifactFilter() {
        return this.artifactFilter;
    }

    @DataBoundSetter
    public void setArtifactFilter(String artifactFilter) {
        this.artifactFilter = artifactFilter;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    @DataBoundSetter
    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        PrintStream console = listener.getLogger();
        if (run.getResult() != Result.SUCCESS) {
            console.println("[slsa] - build not successful, not generating provenance attestations");
            return;
        }
        ProvenanceAction provenanceData = new ProvenanceAction();
        run.addAction((Action)provenanceData);
        String expandedFilter = env.expand(this.artifactFilter);
        FilePath[] artifacts = workspace.list(expandedFilter);
        console.println("[slsa] collecting artifacts");
        for (FilePath artifact : artifacts) {
            console.println(" > " + artifact.getName());
            provenanceData.addSubject(SubjectInfo.of(artifact, workspace));
        }
        Collection<SubjectInfo> subjects = provenanceData.getSubjects();
        if (subjects.isEmpty()) {
            console.println(" > found no artifacts, not generating any provenance attestation");
            return;
        }
        if (!ProvenanceRecorder.areAllSubjectsUnique(provenanceData.getSubjects())) {
            console.println(" > found artifacts with duplicate names:");
            for (SubjectInfo subject : subjects) {
                console.println("   > " + subject.getArtifactName() + " -> " + subject.getWorkspacePath());
            }
            console.println(" > not generating attestation");
            return;
        }
        console.println("[slsa] generating attestation");
        BuildInfo buildInfo = BuildInfo.of(run, env);
        ProvenanceV0_2Generator generator = new ProvenanceV0_2Generator();
        SignedAttestation attestation = generator.generateAttestation(subjects, buildInfo);
        FilePath targetPath = new FilePath(workspace, env.expand(this.targetDirectory));
        targetPath.mkdirs();
        String attestationFileName = subjects.size() > 1 ? "multiple.intoto.jsonl" : subjects.stream().findFirst().get().getArtifactName() + ".intoto.jsonl";
        FilePath outputFile = new FilePath(targetPath, attestationFileName);
        try (OutputStream os = outputFile.write();){
            AttestationWriter attestationWriter = new AttestationWriter(os);
            attestationWriter.writeAttestation(attestation);
        }
        provenanceData.addProvenanceAttestation(outputFile.getName(), Json.dumpWithPrettyPrinting((Object)attestation.getStatement()));
        console.println(" > written attestation to " + outputFile.getRemote());
    }

    public static boolean areAllSubjectsUnique(Collection<SubjectInfo> subjects) {
        return subjects.stream().map(SubjectInfo::getArtifactName).allMatch(new HashSet()::add);
    }

    @Extension
    @Symbol(value={"provenanceRecorder"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @POST
        public FormValidation doCheckArtifactFilter(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.ProvenanceRecorder_DescriptorImpl_errors_missingArtifactFilter());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckTargetDirectory(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.ProvenanceRecorder_DescriptorImpl_errors_missingTargetDirectory());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.ProvenanceRecorder_DescriptorImpl_DisplayName();
        }
    }
}

