/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.slsa.model;

import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;

public class BuildInfo {
    private final String buildNumber;
    private final OffsetDateTime buildStartedOn;
    private final OffsetDateTime buildFinishedOn;
    private final String sourceUrl;
    private final String sourceDigest;
    private final String sourceDigestAlgorithm;
    private final String jobName;
    private final String jobUrl;
    private final String buildUrl;
    private final String nodeName;

    public static BuildInfo of(Run<?, ?> run, EnvVars env) {
        OffsetDateTime startTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(run.getStartTimeInMillis()), ZoneId.systemDefault());
        OffsetDateTime endTime = OffsetDateTime.now();
        String sourceUrl = null;
        String sourceDigest = null;
        String sourceDigestAlgorithm = null;
        String gitUrl = (String)env.get((Object)"GIT_URL");
        if (gitUrl != null) {
            sourceUrl = "git+" + gitUrl + "@" + (String)env.get((Object)"GIT_BRANCH");
            sourceDigestAlgorithm = "sha1";
            sourceDigest = (String)env.get((Object)"GIT_COMMIT");
        } else {
            List actionList = run.getAllActions();
            for (Action action : actionList) {
                if (!action.getClass().getName().equals("hudson.plugins.git.util.BuildData")) continue;
                String url = (String)((BuildData)action).getRemoteUrls().stream().findFirst().orElseThrow();
                Revision revision = ((BuildData)action).getLastBuiltRevision();
                if (revision == null) continue;
                String branch = ((Branch)revision.getBranches().stream().findFirst().orElseThrow()).getName();
                sourceUrl = "git+" + url + "@" + branch;
                sourceDigestAlgorithm = "sha1";
                sourceDigest = revision.getSha1String();
            }
        }
        String jobName = (String)env.get((Object)"JOB_NAME");
        String jobUrl = (String)env.get((Object)"JOB_URL");
        String buildUrl = (String)env.get((Object)"BUILD_URL");
        String nodeName = (String)env.get((Object)"NODE_NAME");
        return new BuildInfo(run.getId(), startTime, endTime, sourceUrl, sourceDigest, sourceDigestAlgorithm, jobName, jobUrl, buildUrl, nodeName);
    }

    private BuildInfo(String buildNumber, OffsetDateTime buildStartedOn, OffsetDateTime buildFinishedOn, String sourceUrl, String sourceDigest, String sourceDigestAlgorithm, String jobName, String jobUrl, String buildUrl, String nodeName) {
        this.buildNumber = buildNumber;
        this.buildStartedOn = buildStartedOn;
        this.buildFinishedOn = buildFinishedOn;
        this.sourceUrl = sourceUrl;
        this.sourceDigest = sourceDigest;
        this.sourceDigestAlgorithm = sourceDigestAlgorithm;
        this.jobName = jobName;
        this.jobUrl = jobUrl;
        this.buildUrl = buildUrl;
        this.nodeName = nodeName;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public OffsetDateTime getBuildStartedOn() {
        return this.buildStartedOn;
    }

    public OffsetDateTime getBuildFinishedOn() {
        return this.buildFinishedOn;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public String getSourceDigest() {
        return this.sourceDigest;
    }

    public String getSourceDigestAlgorithm() {
        return this.sourceDigestAlgorithm;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobUrl() {
        return this.jobUrl;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public String getNodeName() {
        return this.nodeName;
    }
}

