/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.slsa.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import io.jenkins.plugins.slsa.util.Digest;
import java.io.IOException;

public class SubjectInfo {
    private final String artifactName;
    private final String workspacePath;
    private final String sha256Digest;

    public static SubjectInfo of(@NonNull FilePath artifact, @NonNull FilePath workspace) throws IOException, InterruptedException {
        Object workspacePath = artifact.getRemote().substring(workspace.getRemote().length());
        if (((String)workspacePath).startsWith("/")) {
            workspacePath = "." + (String)workspacePath;
        }
        String digest = (String)artifact.act((FilePath.FileCallable)Digest.ofSha256());
        return new SubjectInfo(artifact.getName(), (String)workspacePath, digest);
    }

    private SubjectInfo(@NonNull String artifactName, @NonNull String workspacePath, @NonNull String sha256Digest) {
        this.artifactName = artifactName;
        this.workspacePath = workspacePath;
        this.sha256Digest = sha256Digest;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public String getSha256Digest() {
        return this.sha256Digest;
    }
}

