/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.slsa.generator;

import io.jenkins.plugins.slsa.generator.ProvenanceAttestationGenerator;
import io.jenkins.plugins.slsa.model.BuildInfo;
import io.jenkins.plugins.slsa.model.SubjectInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipsefdn.security.slsa.attestation.model.SignedAttestation;
import org.eclipsefdn.security.slsa.attestation.model.slsa.Provenance;
import org.eclipsefdn.security.slsa.attestation.model.slsa.ProvenanceStatement;
import org.eclipsefdn.security.slsa.attestation.model.slsa.Subject;
import org.eclipsefdn.security.slsa.attestation.model.slsa.common.DigestAlgorithm;
import org.eclipsefdn.security.slsa.attestation.model.slsa.v0_2.Completeness;
import org.eclipsefdn.security.slsa.attestation.model.slsa.v0_2.ConfigSource;
import org.eclipsefdn.security.slsa.attestation.model.slsa.v0_2.Invocation;
import org.eclipsefdn.security.slsa.attestation.model.slsa.v0_2.Material;
import org.eclipsefdn.security.slsa.attestation.model.slsa.v0_2.Metadata;
import org.eclipsefdn.security.slsa.attestation.model.slsa.v0_2.ProvenanceBuilder;
import org.eclipsefdn.security.slsa.attestation.model.slsa.v0_2.ProvenanceV0_2;

public class ProvenanceV0_2Generator
implements ProvenanceAttestationGenerator {
    public static final String BUILD_TYPE = "https://gitlab.eclipse.org/eclipsefdn/security/slsa-jenkins-plugin@v53.v4b_869b_06570e";
    public static final String BUILDER_ID = "https://gitlab.eclipse.org/eclipsefdn/security/slsa-jenkins-plugin@v53.v4b_869b_06570e";

    @Override
    public SignedAttestation generateAttestation(Collection<SubjectInfo> subjects, BuildInfo buildInfo) {
        ProvenanceStatement.Builder provenanceBuilder = ProvenanceStatement.builder();
        for (SubjectInfo subjectInfo : subjects) {
            Subject subject = Subject.builder().withName(subjectInfo.getArtifactName()).withDigest(DigestAlgorithm.SHA256, subjectInfo.getSha256Digest()).build();
            provenanceBuilder.withSubject(subject);
        }
        ConfigSource configSource = ConfigSource.builder().withUri(buildInfo.getSourceUrl()).withDigest(DigestAlgorithm.fromString((String)buildInfo.getSourceDigestAlgorithm()), buildInfo.getSourceDigest()).withEntryPoint(buildInfo.getJobName()).build();
        LinkedHashMap<String, String> environment = new LinkedHashMap<String, String>();
        environment.put("job_url", buildInfo.getJobUrl());
        environment.put("build_url", buildInfo.getBuildUrl());
        environment.put("node_name", buildInfo.getNodeName());
        Invocation invocation = Invocation.builder().withConfigSource(configSource).withEnvironment(environment).build();
        Material sourceMaterial = Material.builder().withUri(buildInfo.getSourceUrl()).withDigest(DigestAlgorithm.fromString((String)buildInfo.getSourceDigestAlgorithm()), buildInfo.getSourceDigest()).build();
        Completeness completeness = Completeness.builder().withCompleteParameters().withCompleteEnvironment().build();
        Metadata metadata = Metadata.builder().withBuildInvocationId(buildInfo.getBuildNumber()).withBuildStartedOn(buildInfo.getBuildStartedOn()).withBuildFinishedOn(buildInfo.getBuildFinishedOn()).withCompleteness(completeness).withReproducible().build();
        ProvenanceV0_2 provenanceV02 = ProvenanceV0_2.builder().withBuildType("https://gitlab.eclipse.org/eclipsefdn/security/slsa-jenkins-plugin@v53.v4b_869b_06570e").withBuilder(ProvenanceBuilder.of((String)"https://gitlab.eclipse.org/eclipsefdn/security/slsa-jenkins-plugin@v53.v4b_869b_06570e")).withInvocation(invocation).withMetadata(metadata).withMaterial(sourceMaterial).build();
        provenanceBuilder.withProvenance((Provenance)provenanceV02);
        return SignedAttestation.of((ProvenanceStatement)provenanceBuilder.build());
    }
}

