/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.shared_library_version_override;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import io.jenkins.plugins.shared_library_version_override.LibraryCustomConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.libs.FolderLibraries;
import org.jenkinsci.plugins.workflow.libs.GlobalLibraries;
import org.jenkinsci.plugins.workflow.libs.GlobalUntrustedLibraries;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class FolderConfigurations
extends AbstractFolderProperty<AbstractFolder<?>> {
    private static final Logger LOGGER = Logger.getLogger(FolderConfigurations.class.getName());
    private List<LibraryCustomConfiguration> overrides = Collections.emptyList();

    @DataBoundConstructor
    public FolderConfigurations() {
    }

    public LibraryCustomConfiguration[] getOverrides() {
        LibraryCustomConfiguration[] lcc = this.overrides.toArray(new LibraryCustomConfiguration[0]);
        LOGGER.log(Level.FINER, "get overrides : ({0})\n", (Object[])lcc);
        return lcc;
    }

    @DataBoundSetter
    public void setOverrides(List<LibraryCustomConfiguration> items) {
        LOGGER.log(Level.FINER, "Add new overrides : ({0})\n", items);
        this.overrides = items;
    }

    public static Collection<LibraryConfiguration> getAllLibrariesForGroup(ItemGroup<?> group) {
        ArrayList<LibraryConfiguration> libraries = new ArrayList<LibraryConfiguration>();
        GlobalLibraries libs = GlobalLibraries.get();
        libraries.addAll(libs.getLibraries());
        libraries.addAll(FolderConfigurations.getAllUntrustedLibrariesForGroup(group));
        LOGGER.log(Level.FINE, "FolderConfigurations.getAllLibrariesForGroup {0}\n", libraries.stream().map(LibraryConfiguration::getName).collect(Collectors.toList()));
        return libraries;
    }

    public static Collection<LibraryConfiguration> getAllUntrustedLibrariesForGroup(ItemGroup<?> group) {
        ArrayList<LibraryConfiguration> libraries = new ArrayList<LibraryConfiguration>();
        GlobalUntrustedLibraries libs = GlobalUntrustedLibraries.get();
        libraries.addAll(libs.getLibraries());
        ItemGroup g = group;
        while (g instanceof AbstractFolder) {
            AbstractFolder f = (AbstractFolder)g;
            FolderLibraries prop = (FolderLibraries)f.getProperties().get(FolderLibraries.class);
            if (prop != null) {
                libraries.addAll(prop.getLibraries());
            }
            g = ((AbstractFolder)g).getParent();
        }
        LOGGER.log(Level.FINE, "FolderConfigurations.getAllUntrustedLibrariesForGroup {0}\n", libraries.stream().map(LibraryConfiguration::getName).collect(Collectors.toList()));
        return libraries;
    }

    public static LibraryConfiguration getLibraryConfiguration(LibraryCustomConfiguration item, Collection<LibraryConfiguration> libs) {
        LibraryConfiguration libConfig = null;
        for (LibraryConfiguration lib : libs) {
            if (!lib.getName().equals(item.getName())) continue;
            if (!lib.isAllowVersionOverride()) {
                LOGGER.log(Level.FINE, "FolderConfigurations.getLibraryConfiguration {0} don't allow version override, don't take it.\n", lib.getName());
                continue;
            }
            libConfig = new LibraryConfiguration(lib.getName(), lib.getRetriever());
            libConfig.setDefaultVersion(item.getVersion());
            libConfig.setImplicit(lib.isImplicit());
            libConfig.setAllowVersionOverride(lib.isAllowVersionOverride());
            libConfig.setIncludeInChangesets(lib.getIncludeInChangesets());
            libConfig.setCachingConfiguration(lib.getCachingConfiguration());
        }
        return libConfig;
    }

    @Extension(ordinal=1000.0)
    public static class CustomUntrustedLibraryResolver
    extends LibraryResolver {
        public boolean isTrusted() {
            return false;
        }

        private Collection<LibraryConfiguration> forGroup(@CheckForNull ItemGroup<?> group, boolean checkPermission) {
            Collection<LibraryConfiguration> allLibs = FolderConfigurations.getAllUntrustedLibrariesForGroup(group);
            ArrayList<LibraryConfiguration> libraries = new ArrayList<LibraryConfiguration>();
            ItemGroup g = group;
            while (g instanceof AbstractFolder) {
                FolderConfigurations prop;
                AbstractFolder f = (AbstractFolder)g;
                if ((!checkPermission || f.hasPermission(Item.CONFIGURE)) && (prop = (FolderConfigurations)f.getProperties().get(FolderConfigurations.class)) != null) {
                    for (LibraryCustomConfiguration item : prop.getOverrides()) {
                        LibraryConfiguration libConfig = FolderConfigurations.getLibraryConfiguration(item, allLibs);
                        if (libConfig == null) continue;
                        libraries.add(libConfig);
                    }
                }
                g = ((AbstractFolder)g).getParent();
            }
            LOGGER.log(Level.FINE, "CustomUntrustedLibraryResolver.forGroup {0}\n", libraries.stream().map(LibraryConfiguration::getName).collect(Collectors.toList()));
            return libraries;
        }

        @NonNull
        public Collection<LibraryConfiguration> forJob(@NonNull Job<?, ?> job, @NonNull Map<String, String> libraryVersions) {
            return this.forGroup(job.getParent(), false);
        }
    }

    @Extension(ordinal=1000.0)
    public static class CustomTrustedLibraryResolver
    extends LibraryResolver {
        public boolean isTrusted() {
            return true;
        }

        private Collection<LibraryConfiguration> forGroup(@CheckForNull ItemGroup<?> group, boolean checkPermission) {
            List allLibs = GlobalLibraries.get().getLibraries();
            ArrayList<LibraryConfiguration> libraries = new ArrayList<LibraryConfiguration>();
            ItemGroup g = group;
            while (g instanceof AbstractFolder) {
                FolderConfigurations prop;
                AbstractFolder f = (AbstractFolder)g;
                if ((!checkPermission || f.hasPermission(Item.CONFIGURE)) && (prop = (FolderConfigurations)f.getProperties().get(FolderConfigurations.class)) != null) {
                    for (LibraryCustomConfiguration item : prop.getOverrides()) {
                        LibraryConfiguration libConfig = FolderConfigurations.getLibraryConfiguration(item, allLibs);
                        if (libConfig == null) continue;
                        libraries.add(libConfig);
                    }
                }
                g = ((AbstractFolder)g).getParent();
            }
            LOGGER.log(Level.FINE, "CustomFolderLibraryResolver.forGroup {0}\n", libraries.stream().map(LibraryConfiguration::getName).collect(Collectors.toList()));
            return libraries;
        }

        @NonNull
        public Collection<LibraryConfiguration> forJob(@NonNull Job<?, ?> job, @NonNull Map<String, String> libraryVersions) {
            return this.forGroup(job.getParent(), false);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return FolderConfigurations.class.getName();
        }
    }
}

