/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.secone.security.object.factory;

import hudson.ProxyConfiguration;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class ObjectFactory {
    public HttpPost createHttpPost(String uri) throws URISyntaxException {
        HttpPost post = new HttpPost(uri);
        RequestConfig config = this.getRequestConfig(new URI(uri));
        if (config != null) {
            post.setConfig(config);
        }
        return post;
    }

    public CloseableHttpClient createHttpClient(URI apiUri) {
        ProxyConfiguration proxyConfig;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        ProxyConfiguration proxyConfiguration = proxyConfig = jenkins != null ? jenkins.proxy : null;
        if (proxyConfig != null && this.shouldUseProxy(proxyConfig, apiUri.getHost())) {
            HttpHost proxyHost = new HttpHost(proxyConfig.name, proxyConfig.port);
            return HttpClients.custom().setProxy(proxyHost).build();
        }
        return HttpClients.createDefault();
    }

    public String getGitFolderConfigPath() {
        return ".git" + File.separator + "config";
    }

    private ProxyConfiguration getJenkinsProxyConfiguration() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.proxy;
    }

    private RequestConfig getRequestConfig(URI uri) {
        ProxyConfiguration proxy = this.getJenkinsProxyConfiguration();
        if (proxy != null && this.shouldUseProxy(proxy, uri.getHost())) {
            HttpHost proxyHost = new HttpHost(proxy.name, proxy.port);
            return RequestConfig.custom().setProxy(proxyHost).build();
        }
        return null;
    }

    private boolean shouldUseProxy(ProxyConfiguration proxy, String host) {
        if (proxy == null || host == null) {
            return false;
        }
        List noProxyHostPatterns = proxy.getNoProxyHostPatterns();
        for (Pattern noProxyHostPattern : noProxyHostPatterns) {
            if (!noProxyHostPattern.matcher(host).matches()) continue;
            return false;
        }
        return true;
    }
}

