/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.secone.security;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Plugin;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import io.jenkins.plugins.secone.security.object.factory.ObjectFactory;
import io.jenkins.plugins.secone.security.pojo.Threshold;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecOneScannerPlugin
extends Builder
implements SimpleBuildStep {
    private static final Logger logger = LoggerFactory.getLogger(SecOneScannerPlugin.class);
    private static final String API_CONTEXT = "/rest";
    private static final String SCA_SCAN_API = "/foss/ascan?enableSbom=true";
    private static final String SCA_STATUS_CHECK_URL = "/foss/report/status";
    private static final String INSTANCE_URL = "SEC1_INSTANCE_URL";
    private static final String SAST_SCAN_API = "/foss/sast/ascan";
    private static final String SAST_STATUS_CHECK_URL = "/sast/asset/report/status";
    private static final String API_KEY = "SEC1_API_KEY";
    private static final String API_KEY_HEADER = "sec1-api-key";
    private String apiCredentialsId;
    private boolean applyThreshold;
    private String actionOnThresholdBreached;
    private Threshold threshold;
    private boolean runSec1SastSecurity;
    private boolean printInAnsiColor;
    private ObjectFactory objectFactory;

    @DataBoundConstructor
    public SecOneScannerPlugin(String apiCredentialsId, ObjectFactory objectFactory, boolean runSec1SastSecurity) {
        this.apiCredentialsId = apiCredentialsId;
        if (objectFactory == null) {
            objectFactory = new ObjectFactory();
        }
        this.objectFactory = objectFactory;
        this.runSec1SastSecurity = runSec1SastSecurity;
    }

    public String getApiCredentialsId() {
        return this.apiCredentialsId;
    }

    public void setApiCredentialsId(String apiCredentialsId) {
        this.apiCredentialsId = apiCredentialsId;
    }

    public boolean isApplyThreshold() {
        return this.applyThreshold;
    }

    @DataBoundSetter
    public void setApplyThreshold(boolean applyThreshold) {
        this.applyThreshold = applyThreshold;
    }

    public Threshold getThreshold() {
        return this.threshold;
    }

    @DataBoundSetter
    public void setThreshold(Threshold threshold) {
        this.threshold = threshold;
    }

    public String getActionOnThresholdBreached() {
        return this.actionOnThresholdBreached;
    }

    @DataBoundSetter
    public void setActionOnThresholdBreached(String actionOnThresholdBreached) {
        this.actionOnThresholdBreached = actionOnThresholdBreached;
    }

    public boolean isRunSec1SastSecurity() {
        return this.runSec1SastSecurity;
    }

    @DataBoundSetter
    public void setRunSec1SastSecurity(boolean runSec1SastSecurity) {
        this.runSec1SastSecurity = runSec1SastSecurity;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.threshold != null) {
            this.applyThreshold = true;
        }
        if (this.objectFactory == null) {
            this.objectFactory = new ObjectFactory();
        }
        this.printInAnsiColor = this.isAnsiColorPluginInstalled(build.getParent());
        String workingDirectory = this.getGitWorkingDirectory(build.getEnvironment((TaskListener)listener), (TaskListener)listener);
        int result = this.performScan((Run<?, ?>)build, (TaskListener)listener, this.applyThreshold, workingDirectory, this.runSec1SastSecurity);
        if (result != 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private void printScaStartMessage(TaskListener listener) {
        this.printLogs(listener.getLogger(), "**************Sec1 SCA scan start**************", "g");
    }

    private void printScaEndMessage(TaskListener listener) {
        this.printLogs(listener.getLogger(), "**************Sec1 SCA scan end**************", "g");
    }

    private void printSastStartMessage(TaskListener listener) {
        this.printLogs(listener.getLogger(), "**************Sec1 SAST Security scan start**************", "g");
    }

    private void printSastEndMessage(TaskListener listener) {
        this.printLogs(listener.getLogger(), "**************Sec1 SAST Security scan end**************", "g");
    }

    private String getInstanceUrl(EnvVars envVars, TaskListener listener) {
        String instanceUrl = (String)envVars.get((Object)INSTANCE_URL);
        if (StringUtils.isNotBlank((String)instanceUrl)) {
            listener.getLogger().println("SEC1_INSTANCE_URL : " + instanceUrl);
            return instanceUrl;
        }
        return "https://api.sec1.io";
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (this.objectFactory == null) {
            this.objectFactory = new ObjectFactory();
        }
        this.printInAnsiColor = this.isAnsiColorPluginInstalled(run.getParent());
        String workingDirectory = this.getGitWorkingDirectory(env, listener);
        if (StringUtils.isBlank((String)this.actionOnThresholdBreached)) {
            this.printLogs(listener.getLogger(), "actionOnThresholdBreached is not set. Default action is fail.", "g");
        } else if ((StringUtils.equalsIgnoreCase((String)this.actionOnThresholdBreached, (String)"fail") || StringUtils.equalsIgnoreCase((String)this.actionOnThresholdBreached, (String)"unstable") || StringUtils.equalsIgnoreCase((String)this.actionOnThresholdBreached, (String)"continue")) && this.threshold != null) {
            this.getThreshold().setStatusAction(this.actionOnThresholdBreached);
        }
        int result = this.performScan(run, listener, this.applyThreshold, workingDirectory, this.runSec1SastSecurity);
        if (result != 0) {
            run.setResult(Result.UNSTABLE);
        }
    }

    public String getApiKey(Run<?, ?> run, TaskListener listener) {
        if (StringUtils.isNotBlank((String)this.apiCredentialsId)) {
            this.printLogs(listener.getLogger(), "Finding api key for credendials id : " + this.apiCredentialsId, "g");
            StringCredentials apiKeyCreds = (StringCredentials)CredentialsProvider.findCredentialById((String)this.apiCredentialsId, StringCredentials.class, run, Collections.emptyList());
            if (apiKeyCreds == null) {
                this.printLogs(listener.getLogger(), "Credentials id not found : " + this.apiCredentialsId, "g");
                this.printLogs(listener.getLogger(), "Finding api key for default credendials id : SEC1_API_KEY", "g");
                apiKeyCreds = (StringCredentials)CredentialsProvider.findCredentialById((String)API_KEY, StringCredentials.class, run, Collections.emptyList());
            }
            if (apiKeyCreds != null) {
                String apiKey = apiKeyCreds.getSecret().getPlainText();
                return apiKey;
            }
        } else {
            this.printLogs(listener.getLogger(), "No Credentials Id confgured, using default credendials id : SEC1_API_KEY", "g");
            StringCredentials apiKeyCreds = (StringCredentials)CredentialsProvider.findCredentialById((String)API_KEY, StringCredentials.class, run, Collections.emptyList());
            if (apiKeyCreds != null) {
                String apiKey = apiKeyCreds.getSecret().getPlainText();
                return apiKey;
            }
        }
        return null;
    }

    public boolean requiresWorkspace() {
        return true;
    }

    private int performScan(Run<?, ?> run, TaskListener listener, boolean applyThreshold, String workingDirectory, boolean runSec1SastSecurity) throws AbortException {
        String sec1ApiKey = this.getApiKey(run, listener);
        if (StringUtils.isBlank((String)sec1ApiKey)) {
            throw new AbortException(this.getErrorMessageInAnsi("API Key not configured. Please check your configuration."));
        }
        StringBuilder fossInstanceUrl = new StringBuilder();
        StringBuilder scmUrl = new StringBuilder();
        try {
            fossInstanceUrl.append(this.getInstanceUrl(run.getEnvironment(listener), listener));
        }
        catch (IOException | InterruptedException e) {
            throw new AbortException(this.getErrorMessageInAnsi("Exception while getting environment variables."));
        }
        String gitUrl = null;
        try {
            gitUrl = this.getGitUrl(workingDirectory);
            if (StringUtils.isBlank((String)gitUrl)) {
                gitUrl = (String)run.getEnvironment(listener).get((Object)"GIT_URL");
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error - Check your git configuration. ", (Throwable)e);
        }
        if (StringUtils.isBlank((String)gitUrl)) {
            throw new AbortException(this.getErrorMessageInAnsi("Exception while getting getting git url. Check your git configuration."));
        }
        scmUrl.append(gitUrl);
        StringBuilder appName = new StringBuilder();
        try {
            appName.append(this.getSubUrl(scmUrl.toString()));
        }
        catch (Exception ex) {
            logger.error("Error - extracting app name from url", (Throwable)ex);
            logger.info("Issue extracting app name from url, setting it to default");
            appName = new StringBuilder(scmUrl);
        }
        String banchName = null;
        try {
            banchName = this.getGitBranch(workingDirectory);
            if (StringUtils.isBlank((String)banchName)) {
                banchName = (String)run.getEnvironment(listener).get((Object)"GIT_BRANCH");
            }
        }
        catch (Exception ex) {
            logger.error("Error - extracting branch name for scm url : {}", (Object)scmUrl, (Object)ex);
        }
        int result = 0;
        result = this.runScaScan(fossInstanceUrl, listener, sec1ApiKey, workingDirectory, scmUrl, appName, runSec1SastSecurity, banchName);
        if (runSec1SastSecurity) {
            try {
                result = this.runSastScan(fossInstanceUrl, listener, sec1ApiKey, workingDirectory, scmUrl, appName, banchName);
            }
            catch (InterruptedException ex) {
                this.printLogs(listener.getLogger(), "Error while running sast scan. Failed to wait for result.", "r");
            }
        }
        return result;
    }

    private int runSastScan(StringBuilder fossInstanceUrl, TaskListener listener, String sec1ApiKey, String workingDirectory, StringBuilder scmUrl, StringBuilder appName, String branchName) throws AbortException, InterruptedException {
        int result;
        block38: {
            String scanUrl;
            HttpResponse responseEntity;
            this.printSastStartMessage(listener);
            result = 0;
            JSONObject inputParamsMap = new JSONObject();
            JSONObject requestJson = new JSONObject();
            requestJson.put("location", (Object)scmUrl);
            if (StringUtils.isNotBlank((String)branchName)) {
                requestJson.put("branchName", (Object)this.getSanitizedBranchName(branchName));
            }
            requestJson.put("appName", (Object)appName);
            requestJson.put("source", (Object)"jenkins");
            JSONArray inputParams = new JSONArray();
            inputParams.put((Object)requestJson);
            inputParamsMap.put("scanRequestList", (Object)inputParams);
            listener.getLogger().println("==================== SEC1 SAST SCAN CONFIG ====================");
            listener.getLogger().println("SCM Url                " + String.valueOf(scmUrl));
            listener.getLogger().println("Threshold Enabled      " + this.applyThreshold);
            if (this.threshold != null && this.applyThreshold) {
                listener.getLogger().println("Threshold Values       Critical " + (StringUtils.isNotBlank((String)this.threshold.getCriticalThreshold()) ? this.threshold.getCriticalThreshold() : "NA") + ", High " + (StringUtils.isNotBlank((String)this.threshold.getHighThreshold()) ? this.threshold.getHighThreshold() : "NA") + ", Medium " + (StringUtils.isNotBlank((String)this.threshold.getMediumThreshold()) ? this.threshold.getMediumThreshold() : "NA") + ", Low " + (StringUtils.isNotBlank((String)this.threshold.getLowThreshold()) ? this.threshold.getLowThreshold() : "NA"));
            }
            if ((responseEntity = this.triggerSastScan(scanUrl = String.valueOf(fossInstanceUrl) + "/rest/foss/sast/ascan", inputParamsMap, sec1ApiKey)) != null && responseEntity.getStatusLine().getStatusCode() == 200) {
                String sastStatusCheckUrl = String.valueOf(fossInstanceUrl) + SAST_STATUS_CHECK_URL;
                try (CloseableHttpClient client = this.objectFactory.createHttpClient(new URI(sastStatusCheckUrl));){
                    if (responseEntity.getEntity() == null) break block38;
                    HttpEntity httpScanResponseEntity = responseEntity.getEntity();
                    if (httpScanResponseEntity.getContent() != null) {
                        JSONArray responseJsonArray = null;
                        try (InputStream rawContent = httpScanResponseEntity.getContent();){
                            byte[] bytes = IOUtils.toByteArray((InputStream)rawContent);
                            String content = new String(bytes, Charset.defaultCharset().name());
                            responseJsonArray = new JSONArray(content);
                        }
                        if (responseJsonArray == null || responseJsonArray.length() == 0) {
                            throw new AbortException(this.getErrorMessageInAnsi("Error while processing scan result. Failing the build."));
                        }
                        String reportId = responseJsonArray.getJSONObject(0).optString("uuid");
                        String scanStatus = "INITIATED";
                        JSONObject responseJson = new JSONObject();
                        long startTime = System.currentTimeMillis();
                        long maxDuration = 600000L;
                        HttpPost statusPost = this.objectFactory.createHttpPost(sastStatusCheckUrl);
                        statusPost.setHeader(API_KEY_HEADER, sec1ApiKey);
                        statusPost.setHeader("Content-Type", "application/json");
                        statusPost.setHeader("Accept", "application/json");
                        while (!StringUtils.equalsIgnoreCase((String)"COMPLETED", (String)scanStatus)) {
                            if (System.currentTimeMillis() - startTime > maxDuration) {
                                listener.getLogger().println("Sec1 SAST Security Scanner Report:");
                                listener.getLogger().println("Report ID: " + reportId);
                                listener.getLogger().println("Report URL: https://scopy.sec1.io/sast-advance-dashboard/" + reportId);
                                listener.getLogger().println("Status: FAILURE");
                                throw new AbortException(this.getErrorMessageInAnsi("Sec1 SAST Security Scan timed out after 10 minutes"));
                            }
                            Thread.sleep(10000L);
                            JSONObject statusPayload = new JSONObject();
                            JSONArray reportIdArray = new JSONArray();
                            reportIdArray.put((Object)reportId);
                            statusPayload.put("reportId", (Object)reportIdArray);
                            statusPost.setEntity((HttpEntity)new StringEntity(statusPayload.toString()));
                            CloseableHttpResponse statusResponse = client.execute((HttpUriRequest)statusPost);
                            HttpEntity statusEntity = statusResponse.getEntity();
                            try (InputStream statusRawContent = statusEntity.getContent();){
                                byte[] statusBytes = IOUtils.toByteArray((InputStream)statusRawContent);
                                String statusContent = new String(statusBytes, Charset.defaultCharset().name());
                                JSONArray statusArray = new JSONArray(statusContent);
                                responseJson = statusArray.getJSONObject(0);
                                scanStatus = responseJson.getString("scanStatus");
                            }
                            if (StringUtils.equalsIgnoreCase((String)"SCANNING", (String)scanStatus)) {
                                listener.getLogger().println("SAST Scan is still in progress...");
                                continue;
                            }
                            if (!scanStatus.equals("FAILED")) continue;
                            listener.getLogger().println("==================== SEC1 SAST SCAN RESULT ====================");
                            listener.getLogger().println("Report Url             Report URL: https://scopy.sec1.io/sast-advance-dashboard/" + reportId);
                            listener.getLogger().println();
                            listener.getLogger().println("Status                 FAILURE");
                            throw new AbortException(this.getErrorMessageInAnsi("Sec1 SAST Security Scan Finished with failures"));
                        }
                        if (responseJson != null) {
                            int critical = responseJson.optInt("critical");
                            int high = responseJson.optInt("high");
                            int medium = responseJson.optInt("medium");
                            int low = responseJson.optInt("low");
                            listener.getLogger().println("==================== SEC1 SAST SCAN RESULT ====================");
                            if (StringUtils.isBlank((String)responseJson.optString("errorMessage"))) {
                                String reportUrl = "https://scopy.sec1.io/sast-advance-dashboard/" + reportId;
                                listener.getLogger().println("Vulnerabilities Found  Critical " + critical + ", High " + high + ", Medium " + medium + ", Low " + low);
                                listener.getLogger().println("Report Url             " + reportUrl);
                                if (this.applyThreshold) {
                                    String message;
                                    if (critical != 0 && this.threshold.getCriticalThreshold() != null && NumberUtils.isDigits((String)this.threshold.getCriticalThreshold()) && critical >= Integer.parseInt(this.threshold.getCriticalThreshold())) {
                                        message = "Critical Vulnerability Threshold breached.";
                                        result = this.failBuildOnThresholdBreach(message, listener, this.threshold);
                                    }
                                    if (high != 0 && this.threshold.getHighThreshold() != null && NumberUtils.isDigits((String)this.threshold.getHighThreshold()) && high >= Integer.parseInt(this.threshold.getHighThreshold())) {
                                        message = "High Vulnerability Threshold breached.";
                                        result = this.failBuildOnThresholdBreach(message, listener, this.threshold);
                                    }
                                    if (medium != 0 && this.threshold.getMediumThreshold() != null && NumberUtils.isDigits((String)this.threshold.getMediumThreshold()) && medium >= Integer.parseInt(this.threshold.getMediumThreshold())) {
                                        message = "Medium Vulnerability Threshold breached.";
                                        result = this.failBuildOnThresholdBreach(message, listener, this.threshold);
                                    }
                                    if (low != 0 && this.threshold.getLowThreshold() != null && NumberUtils.isDigits((String)this.threshold.getLowThreshold()) && low >= Integer.parseInt(this.threshold.getLowThreshold())) {
                                        message = "Low Vulnerability Threshold breached.";
                                        result = this.failBuildOnThresholdBreach(message, listener, this.threshold);
                                    }
                                }
                            } else {
                                this.printLogs(listener.getLogger(), "Error Details : " + responseJson.optString("errorMessage"), "r");
                                result = 2;
                            }
                        }
                        break block38;
                    }
                    logger.info("Invalid content recevied");
                    throw new AbortException(this.getErrorMessageInAnsi("Error while processing sast scan result. Failing the build."));
                }
                catch (AbortException ex) {
                    this.printSastEndMessage(listener);
                    throw new AbortException(this.getErrorMessageInAnsi("Attention: Build Failed because of vulnerability threshold level breached for sast."));
                }
                catch (IOException ex) {
                    throw new AbortException(this.getErrorMessageInAnsi("Attention: Build Failed. Check configuration."));
                }
                catch (URISyntaxException e) {
                    throw new AbortException(this.getErrorMessageInAnsi("Attention: Check configured Sec1 API url."));
                }
            }
            logger.error("Issue while getting response from system.");
            throw new AbortException(this.getErrorMessageInAnsi("Error while processing scan result. Failing the build."));
        }
        this.printSastEndMessage(listener);
        return result;
    }

    private String getSanitizedBranchName(String branchName) {
        if (branchName != null && branchName.startsWith("origin/")) {
            branchName = branchName.substring("origin/".length());
        }
        return branchName;
    }

    private HttpResponse triggerSastScan(String apiUrl, JSONObject inputParamsMap, String sec1ApiKey) {
        block10: {
            CloseableHttpResponse closeableHttpResponse;
            block9: {
                CloseableHttpClient client = this.objectFactory.createHttpClient(new URI(apiUrl));
                try {
                    CloseableHttpResponse response;
                    HttpPost httpPost = this.objectFactory.createHttpPost(apiUrl);
                    httpPost.addHeader(API_KEY_HEADER, sec1ApiKey);
                    httpPost.setHeader("Content-Type", "application/json");
                    httpPost.setHeader("Accept", "application/json");
                    StringEntity stringEntity = new StringEntity(inputParamsMap.toString(), StandardCharsets.UTF_8);
                    httpPost.setEntity((HttpEntity)stringEntity);
                    closeableHttpResponse = response = client.execute((HttpUriRequest)httpPost);
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("Issue while connecting to api.", (Throwable)e);
                        break block10;
                    }
                    catch (URISyntaxException e) {
                        logger.error("Check configured Sec1 API url => {}", (Object)apiUrl, (Object)e);
                    }
                }
                client.close();
            }
            return closeableHttpResponse;
        }
        return null;
    }

    public String getGitBranch(String repositoryPath) throws IOException {
        Path headFilePath = Paths.get(repositoryPath, ".git", "HEAD");
        if (!Files.exists(headFilePath, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(headFilePath, StandardCharsets.UTF_8);){
            String headContent = reader.readLine();
            if (headContent != null && headContent.startsWith("ref:")) {
                String[] parts = headContent.split("/");
                String string = parts[parts.length - 1];
                return string;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int runScaScan(StringBuilder fossInstanceUrl, TaskListener listener, String sec1ApiKey, String workingDirectory, StringBuilder scmUrl, StringBuilder appName, boolean runSec1SastSecurity, String branchName) throws AbortException {
        this.printScaStartMessage(listener);
        result = 0;
        scanUrl = String.valueOf(fossInstanceUrl) + "/rest/foss/ascan?enableSbom=true";
        rquestJson = new JSONObject();
        scanRequestList = new JSONArray();
        inputParamsMap = new JSONObject();
        inputParamsMap.put("location", (Object)scmUrl);
        inputParamsMap.put("appName", (Object)appName);
        inputParamsMap.put("source", (Object)"jenkins");
        if (StringUtils.isNotBlank((String)branchName)) {
            inputParamsMap.put("branchName", (Object)this.getSanitizedBranchName(branchName));
        }
        scanRequestList.put((Object)inputParamsMap);
        rquestJson.put("scanRequestList", (Object)scanRequestList);
        listener.getLogger().println("==================== SEC1 SCA SCAN CONFIG ====================");
        listener.getLogger().println("SCM Url                " + String.valueOf(scmUrl));
        listener.getLogger().println("Threshold Enabled      " + this.applyThreshold);
        if (this.threshold != null && this.applyThreshold) {
            listener.getLogger().println("Threshold Values       Critical " + (StringUtils.isNotBlank((String)this.threshold.getCriticalThreshold()) != false ? this.threshold.getCriticalThreshold() : "NA") + ", High " + (StringUtils.isNotBlank((String)this.threshold.getHighThreshold()) != false ? this.threshold.getHighThreshold() : "NA") + ", Medium " + (StringUtils.isNotBlank((String)this.threshold.getMediumThreshold()) != false ? this.threshold.getMediumThreshold() : "NA") + ", Low " + (StringUtils.isNotBlank((String)this.threshold.getLowThreshold()) != false ? this.threshold.getLowThreshold() : "NA"));
        }
        if ((responseEntity = this.triggerScaScan(scanUrl, rquestJson.toString(), sec1ApiKey)) != null && responseEntity.getStatusLine().getStatusCode() == 200) {
            scaStatusCheckUrl = String.valueOf(fossInstanceUrl) + "/foss/report/status";
            try {
                client = this.objectFactory.createHttpClient(new URI(scaStatusCheckUrl));
                try {
                    if (responseEntity.getEntity() == null) ** GOTO lbl157
                    httpScanResponseEntity = responseEntity.getEntity();
                    if (httpScanResponseEntity.getContent() != null) {
                        responseJsonArray = null;
                        rawContent = httpScanResponseEntity.getContent();
                        try {
                            bytes = IOUtils.toByteArray((InputStream)rawContent);
                            content = new String(bytes, Charset.defaultCharset().name());
                            responseJsonArray = new JSONArray(content);
                        }
                        finally {
                            if (rawContent != null) {
                                rawContent.close();
                            }
                        }
                        if (responseJsonArray == null || responseJsonArray.length() == 0) {
                            throw new AbortException(this.getErrorMessageInAnsi("Error while processing scan result. Failing the build."));
                        }
                        reportId = responseJsonArray.getJSONObject(0).optString("uuid");
                        scanStatus = "INITIATED";
                        startTime = System.currentTimeMillis();
                        maxDuration = 600000L;
                        statusPost = this.objectFactory.createHttpPost(scaStatusCheckUrl);
                        statusPost.setHeader("sec1-api-key", sec1ApiKey);
                        statusPost.setHeader("Content-Type", "application/json");
                        statusPost.setHeader("Accept", "application/json");
                        responseJson = null;
                        while (!StringUtils.equalsIgnoreCase((String)"COMPLETED", (String)scanStatus)) {
                            if (System.currentTimeMillis() - startTime > maxDuration) {
                                listener.getLogger().println("Sec1 SCA Security Scanner Report:");
                                listener.getLogger().println("Report ID              " + reportId);
                                listener.getLogger().println("Report Url           https://scopy.sec1.io/dashboard-scan-details/" + reportId);
                                listener.getLogger().println("Status                 FAILURE");
                                throw new AbortException(this.getErrorMessageInAnsi("Sec1 SCA Security Scan timed out after 10 minutes"));
                            }
                            Thread.sleep(10000L);
                            reportIdArray = new JSONArray();
                            reportIdArray.put((Object)reportId);
                            statusPost.setEntity((HttpEntity)new StringEntity(reportIdArray.toString()));
                            statusResponse = client.execute((HttpUriRequest)statusPost);
                            statusEntity = statusResponse.getEntity();
                            statusRawContent = statusEntity.getContent();
                            try {
                                statusBytes = IOUtils.toByteArray((InputStream)statusRawContent);
                                statusContent = new String(statusBytes, Charset.defaultCharset().name());
                                responseJson = new JSONObject(statusContent);
                            }
                            finally {
                                if (statusRawContent != null) {
                                    statusRawContent.close();
                                }
                            }
                            scanStatus = responseJson.getJSONObject(reportId).getString("status");
                            if (!StringUtils.equalsIgnoreCase((String)"FAILED", (String)scanStatus) && !StringUtils.equalsIgnoreCase((String)"COMPLETED", (String)scanStatus)) {
                                listener.getLogger().println("SCA Scan is still in progress...");
                                continue;
                            }
                            if (!scanStatus.equals("FAILED")) continue;
                            scanResult = responseJson.getJSONObject(reportId).optJSONObject("scannerResponseEntity");
                            listener.getLogger().println("==================== SEC1 SCA SCAN RESULT ====================");
                            if (scanResult != null) {
                                listener.getLogger().println("Report Url             " + scanResult.optString("reportUrl"));
                            }
                            listener.getLogger().println("Status                 FAILURE");
                            throw new AbortException(this.getErrorMessageInAnsi("Sec1 SCA Security Scan Finished with failures"));
                        }
                        if (responseJson != null) {
                            scanResult = responseJson.getJSONObject(reportId).optJSONObject("scannerResponseEntity");
                            if (scanResult == null || !scanResult.has("cveCountDetails")) ** GOTO lbl157
                            critical = scanResult.optJSONObject("cveCountDetails") != null ? scanResult.getJSONObject("cveCountDetails").optInt("CRITICAL") : 0;
                            high = scanResult.optJSONObject("cveCountDetails") != null ? scanResult.getJSONObject("cveCountDetails").optInt("HIGH") : 0;
                            medium = scanResult.optJSONObject("cveCountDetails") != null ? scanResult.getJSONObject("cveCountDetails").optInt("MEDIUM") : 0;
                            low = scanResult.optJSONObject("cveCountDetails") != null ? scanResult.getJSONObject("cveCountDetails").optInt("LOW") : 0;
                            listener.getLogger().println("==================== SEC1 SCA SCAN RESULT ====================");
                            if (StringUtils.isBlank((String)scanResult.optString("errorMessage"))) {
                                listener.getLogger().println("Vulnerabilities Found  Critical " + critical + ", High " + high + ", Medium " + medium + ", Low " + low);
                                listener.getLogger().println("RAG Status             " + scanResult.optString("overallRagStatus"));
                                listener.getLogger().println("Report Url             " + scanResult.optString("reportUrl"));
                                if (!this.applyThreshold) ** GOTO lbl157
                                try {
                                    if (critical != 0 && this.threshold.getCriticalThreshold() != null && NumberUtils.isDigits((String)this.threshold.getCriticalThreshold()) && critical >= Integer.parseInt(this.threshold.getCriticalThreshold())) {
                                        message = "Critical Vulnerability Threshold breached.";
                                        result = this.failBuildOnThresholdBreach(message, listener, this.threshold);
                                    }
                                    if (high != 0 && this.threshold.getHighThreshold() != null && NumberUtils.isDigits((String)this.threshold.getHighThreshold()) && high >= Integer.parseInt(this.threshold.getHighThreshold())) {
                                        message = "High Vulnerability Threshold breached.";
                                        result = this.failBuildOnThresholdBreach(message, listener, this.threshold);
                                    }
                                    if (medium != 0 && this.threshold.getMediumThreshold() != null && NumberUtils.isDigits((String)this.threshold.getMediumThreshold()) && medium >= Integer.parseInt(this.threshold.getMediumThreshold())) {
                                        message = "Medium Vulnerability Threshold breached.";
                                        result = this.failBuildOnThresholdBreach(message, listener, this.threshold);
                                    }
                                    if (low == 0 || this.threshold.getLowThreshold() == null || !NumberUtils.isDigits((String)this.threshold.getLowThreshold()) || low < Integer.parseInt(this.threshold.getLowThreshold())) ** GOTO lbl157
                                    message = "Low Vulnerability Threshold breached.";
                                    result = this.failBuildOnThresholdBreach(message, listener, this.threshold);
                                }
                                catch (AbortException ex) {
                                    if (!runSec1SastSecurity) {
                                        throw new AbortException(this.getErrorMessageInAnsi("Attention: Build Failed because of vulnerability threshold level breached for sca."));
                                    }
                                    this.printLogs(listener.getLogger(), "Attention: Build Failed because of vulnerability threshold level breached for sca.", "r");
                                }
                            }
                            this.printLogs(listener.getLogger(), "Error Details : " + scanResult.optString("errorMessage"), "r");
                            result = 2;
                        }
                        SecOneScannerPlugin.logger.info("Invalid content recevied");
                        if (!runSec1SastSecurity) {
                            throw new AbortException(this.getErrorMessageInAnsi("Error while processing scan result. Failing the build."));
                        }
                        this.printLogs(listener.getLogger(), "Error while processing scan result. Failing the build.", "r");
                    }
                    SecOneScannerPlugin.logger.info("Invalid content recevied");
                    if (!runSec1SastSecurity) {
                        throw new AbortException(this.getErrorMessageInAnsi("Error while processing scan result. Failing the build."));
                    }
                    this.printLogs(listener.getLogger(), "Error while processing scan result. Failing the build.", "r");
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
            }
            catch (AbortException ex) {
                throw ex;
            }
            catch (ConnectionClosedException ex) {
                SecOneScannerPlugin.logger.info("Attention: Connectivity issue. Please try again.", (Throwable)ex);
                throw new AbortException(this.getErrorMessageInAnsi("Attention: Connectivity issue. Please try again."));
            }
            catch (IOException | InterruptedException e) {
                SecOneScannerPlugin.logger.info("Build Failed. Check configuration.", (Throwable)e);
                throw new AbortException(this.getErrorMessageInAnsi("Attention: Build Failed. Check configuration."));
            }
            catch (URISyntaxException e) {
                throw new AbortException(this.getErrorMessageInAnsi("Attention: Check configured Sec1 API url."));
            }
        } else {
            if (responseEntity != null && responseEntity.getStatusLine().getStatusCode() == 401) {
                throw new AbortException(this.getErrorMessageInAnsi("401 Unauthorized. Check your api key."));
            }
            SecOneScannerPlugin.logger.error("Issue while getting response from system.");
            if (!runSec1SastSecurity) {
                throw new AbortException(this.getErrorMessageInAnsi("Error while processing sca scan result. Failing the build."));
            }
            this.printLogs(listener.getLogger(), "Error while processing sca scan result. Failing the build.", "r");
        }
lbl157:
        // 10 sources

        this.printScaEndMessage(listener);
        return result;
    }

    private void printLogs(PrintStream logger, String message, String color) {
        if (this.printInAnsiColor) {
            if (StringUtils.isNotBlank((String)color)) {
                switch (color) {
                    case "g": {
                        logger.println("\u001b[32m" + message + "\u001b[0m");
                        break;
                    }
                    case "r": {
                        logger.println("\u001b[31m" + message + "\u001b[0m");
                        break;
                    }
                    default: {
                        logger.println(message);
                        break;
                    }
                }
            } else {
                logger.println(message);
            }
        } else {
            logger.println(message);
        }
    }

    private String getErrorMessageInAnsi(String message) {
        if (this.printInAnsiColor) {
            return "\u001b[31m" + message + "\u001b[0m";
        }
        return message;
    }

    private int failBuildOnThresholdBreach(String message, TaskListener listener, Threshold threshold) throws AbortException {
        if (StringUtils.isNotBlank((String)threshold.getStatusAction())) {
            if (StringUtils.equalsIgnoreCase((String)threshold.getStatusAction(), (String)"fail")) {
                throw new AbortException(message + " Failing the build.");
            }
            if (StringUtils.equalsIgnoreCase((String)threshold.getStatusAction(), (String)"unstable")) {
                this.printLogs(listener.getLogger(), message, "r");
                return 2;
            }
        } else {
            throw new AbortException(message + " Failing the build.");
        }
        listener.getLogger().println(message);
        return 0;
    }

    private String getSubUrl(String scmUrl) throws MalformedURLException {
        URL apiUrl = new URL(scmUrl);
        int subUrlLocation = StringUtils.indexOf((String)scmUrl, (String)apiUrl.getHost()) + apiUrl.getHost().length() + 1;
        if (apiUrl.getPort() != -1) {
            subUrlLocation = StringUtils.indexOf((String)scmUrl, (String)apiUrl.getHost()) + apiUrl.getHost().length() + String.valueOf(apiUrl.getPort()).length() + 1;
        }
        return StringUtils.substring((String)scmUrl, (int)subUrlLocation);
    }

    private String getGitWorkingDirectory(EnvVars env, TaskListener listener) {
        return (String)env.get((Object)"WORKSPACE");
    }

    private HttpResponse triggerScaScan(String apiUrl, String inputParamsMap, String sec1ApiKey) {
        block10: {
            CloseableHttpResponse closeableHttpResponse;
            block9: {
                CloseableHttpClient client = this.objectFactory.createHttpClient(new URI(apiUrl));
                try {
                    CloseableHttpResponse response;
                    HttpPost httpPost = this.objectFactory.createHttpPost(apiUrl);
                    httpPost.setHeader("Content-Type", "application/json");
                    httpPost.setHeader("Accept", "application/json");
                    httpPost.setHeader(API_KEY_HEADER, sec1ApiKey);
                    StringEntity stringEntity = new StringEntity(inputParamsMap, StandardCharsets.UTF_8);
                    httpPost.setEntity((HttpEntity)stringEntity);
                    closeableHttpResponse = response = client.execute((HttpUriRequest)httpPost);
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("Issue while connecting to api.", (Throwable)e);
                        break block10;
                    }
                    catch (URISyntaxException e) {
                        logger.error("Check configured Sec1 API url => {}", (Object)apiUrl, (Object)e);
                    }
                }
                client.close();
            }
            return closeableHttpResponse;
        }
        return null;
    }

    public String getGitUrl(String repositoryPath) throws IOException {
        String gitConfigPath = repositoryPath + File.separator + this.objectFactory.getGitFolderConfigPath();
        if (!Files.exists(Path.of(gitConfigPath, new String[0]), new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(gitConfigPath, StandardCharsets.UTF_8));){
            String line;
            boolean inRemoteSection = false;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (line.trim().equals("[remote \"origin\"]")) {
                    inRemoteSection = true;
                }
                if (inRemoteSection && line.trim().startsWith("url") && (parts = line.split("=")).length == 2) {
                    String rawUrl = parts[1].trim();
                    String string = this.removeCredentialsFromGitUrl(rawUrl);
                    return string;
                }
                if (!inRemoteSection || !line.trim().startsWith("[") || line.trim().equals("[remote \"origin\"]")) continue;
                break;
            }
        }
        return null;
    }

    public String getGitFolderConfigPath() {
        return ".git" + File.separator + "config";
    }

    private String removeCredentialsFromGitUrl(String rawUrl) {
        try {
            URI uri = new URI(rawUrl);
            String userInfo = uri.getUserInfo();
            if (userInfo != null) {
                return rawUrl.replace(userInfo + "@", "");
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return rawUrl;
    }

    private boolean isAnsiColorPluginInstalled(Job<?, ?> job) {
        Plugin plugin = Jenkins.get().getPlugin("ansicolor");
        if (plugin != null && plugin.getWrapper().isEnabled()) {
            XmlFile config = job.getConfigFile();
            try {
                String configString = config.asString();
                if (StringUtils.isNotBlank((String)configString) && StringUtils.contains((String)configString, (String)"hudson.plugins.ansicolor.AnsiColorBuildWrapper")) {
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    @Symbol(value={"sec1ScaSastSecurity"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @DataBoundConstructor
        public DescriptorImpl() {
            super(SecOneScannerPlugin.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute Sec1 Sca Sast Security Scan";
        }
    }
}

