/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jenkins.plugins.itemstorage.s3.ClientHelper;
import jenkins.plugins.itemstorage.s3.Destination;
import jenkins.plugins.itemstorage.s3.S3BaseUploadCallable;
import jenkins.plugins.itemstorage.s3.Uploads;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class S3UploadAllCallable
extends S3BaseUploadCallable<Integer> {
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String pathPrefix;
    private final DirScanner.Glob scanner;

    public S3UploadAllCallable(ClientHelper clientHelper, String fileMask, String excludes, boolean useDefaultExcludes, String bucketName, String pathPrefix, Map<String, String> userMetadata, String storageClass, boolean useServerSideEncryption) {
        super(clientHelper, userMetadata, storageClass, useServerSideEncryption);
        this.bucketName = bucketName;
        this.pathPrefix = pathPrefix;
        this.scanner = new DirScanner.Glob(fileMask, excludes, useDefaultExcludes);
    }

    @Override
    public Integer invoke(final TransferManager transferManager, File base, VirtualChannel channel) throws IOException, InterruptedException {
        if (!base.exists()) {
            return 0;
        }
        final AtomicInteger count = new AtomicInteger(0);
        final Uploads uploads = new Uploads();
        final Map<String, S3ObjectSummary> summaries = this.lookupExistingCacheEntries(transferManager.getAmazonS3Client());
        this.scanner.scan(base, new FileVisitor(this){
            final /* synthetic */ S3UploadAllCallable this$0;
            {
                this.this$0 = this$0;
            }

            public void visit(File f, String relativePath) throws IOException {
                String key;
                S3ObjectSummary summary;
                if (f.isFile() && ((summary = (S3ObjectSummary)summaries.get(key = this.this$0.pathPrefix + "/" + relativePath)) == null || f.lastModified() > summary.getLastModified().getTime())) {
                    ObjectMetadata metadata = this.this$0.buildMetadata(f);
                    uploads.startUploading(transferManager, f, IOUtils.toBufferedInputStream((InputStream)FileUtils.openInputStream((File)f)), new Destination(this.this$0.bucketName, key), metadata);
                    if (uploads.count() > 20) {
                        this.this$0.waitForUploads(count, uploads);
                    }
                }
            }
        });
        this.waitForUploads(count, uploads);
        return uploads.count();
    }

    private Map<String, S3ObjectSummary> lookupExistingCacheEntries(AmazonS3 s3) {
        HashMap<String, S3ObjectSummary> summaries = new HashMap<String, S3ObjectSummary>();
        ObjectListing listing = s3.listObjects(this.bucketName, this.pathPrefix);
        do {
            for (S3ObjectSummary summary : listing.getObjectSummaries()) {
                summaries.put(summary.getKey(), summary);
            }
        } while ((listing = listing.isTruncated() ? s3.listNextBatchOfObjects(listing) : null) != null);
        return summaries;
    }

    private void waitForUploads(AtomicInteger count, Uploads uploads) {
        count.addAndGet(uploads.count());
        try {
            uploads.finishUploading();
        }
        catch (InterruptedException ie) {
            uploads.cleanup();
            Thread.interrupted();
        }
    }
}

