/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.transfer.TransferManager;
import hudson.remoting.VirtualChannel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import jenkins.plugins.itemstorage.s3.ClientHelper;
import jenkins.plugins.itemstorage.s3.S3Callable;
import org.apache.commons.io.IOUtils;

public class S3DownloadCallable
extends S3Callable<Void> {
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String key;

    public S3DownloadCallable(ClientHelper helper, String bucketName, String key) {
        super(helper);
        this.bucketName = bucketName;
        this.key = key;
    }

    @Override
    public Void invoke(TransferManager transferManager, File target, VirtualChannel channel) throws IOException {
        S3Object object = transferManager.getAmazonS3Client().getObject(this.bucketName, this.key);
        try (BufferedInputStream inputStream = new BufferedInputStream((InputStream)object.getObjectContent());
             BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(target.toPath(), new OpenOption[0]));){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        return null;
    }
}

