/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import jenkins.plugins.itemstorage.s3.ClientHelper;
import jenkins.plugins.itemstorage.s3.S3BaseUploadCallable;

public class S3UploadCallable
extends S3BaseUploadCallable<Void> {
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String key;

    public S3UploadCallable(ClientHelper clientHelper, String bucketName, String key, Map<String, String> userMetadata, String storageClass, boolean useServerSideEncryption) {
        super(clientHelper, userMetadata, storageClass, useServerSideEncryption);
        this.bucketName = bucketName;
        this.key = key;
    }

    @Override
    public Void invoke(TransferManager transferManager, File source, VirtualChannel channel) throws IOException {
        if (!source.exists()) {
            return null;
        }
        PutObjectRequest request = new PutObjectRequest(this.bucketName, this.key, source);
        request.setMetadata(this.buildMetadata(source));
        transferManager.getAmazonS3Client().putObject(request);
        return null;
    }
}

