/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import java.io.File;
import java.io.IOException;
import jenkins.plugins.itemstorage.s3.ClientHelper;
import jenkins.plugins.itemstorage.s3.Downloads;
import jenkins.plugins.itemstorage.s3.S3Callable;

public class S3DownloadAllCallable
extends S3Callable<Integer> {
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String pathPrefix;
    private final DirScanner.Glob scanner;

    public S3DownloadAllCallable(ClientHelper helper, String fileMask, String excludes, boolean useDefaultExcludes, String bucketName, String pathPrefix) {
        super(helper);
        this.bucketName = bucketName;
        this.pathPrefix = pathPrefix;
        this.scanner = new DirScanner.Glob(fileMask, excludes, useDefaultExcludes);
    }

    @Override
    public Integer invoke(TransferManager transferManager, File base, VirtualChannel channel) throws IOException, InterruptedException {
        if (!base.exists() && !base.mkdirs()) {
            throw new IOException("Failed to create directory : " + String.valueOf(base));
        }
        Downloads downloads = new Downloads();
        ObjectListing objectListing = null;
        do {
            objectListing = transferManager.getAmazonS3Client().listObjects(new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(this.pathPrefix).withMarker(objectListing != null ? objectListing.getNextMarker() : null));
            for (S3ObjectSummary summary : objectListing.getObjectSummaries()) {
                downloads.startDownload(transferManager, base, this.pathPrefix, summary);
            }
        } while (objectListing.getNextMarker() != null);
        int totalCount = downloads.count();
        downloads.finishDownloading();
        return totalCount;
    }
}

