/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.listeners.ItemListener;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.File;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.itemstorage.GlobalItemStorage;
import jenkins.plugins.itemstorage.ItemStorage;
import jenkins.plugins.itemstorage.ItemStorageDescriptor;
import jenkins.plugins.itemstorage.s3.S3ObjectPath;
import jenkins.plugins.itemstorage.s3.S3Profile;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class NonAWSS3ItemStorage
extends ItemStorage<S3ObjectPath> {
    private static final long serialVersionUID = 1L;
    private final String credentialsId;
    private final String bucketName;
    private final String prefix;
    private final String endpoint;
    private final String region;
    private final String signerVersion;
    private final boolean pathStyleAccess;
    private final boolean parallelDownloads;

    @DataBoundConstructor
    public NonAWSS3ItemStorage(String credentialsId, String bucketName, String prefix, String endpoint, String region, String signerVersion, boolean pathStyleAccess, boolean parallelDownloads) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
        this.bucketName = Util.fixEmptyAndTrim((String)bucketName);
        this.prefix = Util.fixEmptyAndTrim((String)prefix);
        this.endpoint = Util.fixEmptyAndTrim((String)endpoint);
        this.region = Util.fixEmptyAndTrim((String)region);
        this.signerVersion = Util.fixEmptyAndTrim((String)signerVersion);
        this.pathStyleAccess = pathStyleAccess;
        this.parallelDownloads = parallelDownloads;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getSignerVersion() {
        return this.signerVersion;
    }

    public boolean getPathStyleAccess() {
        return this.pathStyleAccess;
    }

    public boolean getParallelDownloads() {
        return this.parallelDownloads;
    }

    public S3ObjectPath getObjectPath(Item item, String path) {
        return new S3ObjectPath(this.createS3Profile(), this.bucketName, this.region, item.getFullName(), path);
    }

    public S3ObjectPath getObjectPathForBranch(Item item, String path, String branch) {
        String branchPath = new File(item.getFullName()).getParent() + "/" + branch;
        return new S3ObjectPath(this.createS3Profile(), this.bucketName, this.region, branchPath, path);
    }

    private AmazonWebServicesCredentials lookupCredentials() {
        return this.credentialsId == null ? null : (AmazonWebServicesCredentials)CredentialsMatchers.firstOrNull(NonAWSS3ItemStorage.possibleCredentials(), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
    }

    private static List<AmazonWebServicesCredentials> possibleCredentials() {
        return CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList());
    }

    private S3Profile createS3Profile() {
        return new S3Profile(this.lookupCredentials(), this.endpoint, this.region, this.prefix, this.signerVersion, this.pathStyleAccess, this.parallelDownloads);
    }

    public static final class S3ItemListener
    extends ItemListener {
        public void onDeleted(Item item) {
            NonAWSS3ItemStorage s3Storage = this.lookupS3Storage();
            if (s3Storage == null) {
                return;
            }
            s3Storage.createS3Profile().delete(s3Storage.bucketName, item.getFullName());
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            NonAWSS3ItemStorage s3Storage = this.lookupS3Storage();
            if (s3Storage == null) {
                return;
            }
            s3Storage.createS3Profile().rename(s3Storage.bucketName, oldFullName, newFullName);
        }

        private NonAWSS3ItemStorage lookupS3Storage() {
            ItemStorage storage = GlobalItemStorage.get().getStorage();
            if (storage instanceof NonAWSS3ItemStorage) {
                return (NonAWSS3ItemStorage)storage;
            }
            return null;
        }
    }

    @Symbol(value={"nonAWSS3"})
    @Extension
    public static final class DescriptorImpl
    extends ItemStorageDescriptor<S3ObjectPath> {
        @NonNull
        public String getDisplayName() {
            return "S3 API compatible storage";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withAll(NonAWSS3ItemStorage.possibleCredentials());
        }

        @POST
        public ListBoxModel doFillSignerVersionItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("None", "");
            model.add("Version 4", "AWS4SignerType");
            model.add("Version 3", "AWS3SignerType");
            model.add("Version 2", "S3SignerType");
            return model;
        }
    }
}

