/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import java.io.Serializable;

public class ClientHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String accessKey;
    private final String secretKey;
    private final String region;
    private final ProxyConfiguration proxy;
    private final String endpoint;
    private final String signerVersion;
    private final boolean pathStyleAccess;
    private final boolean parallelDownloads;
    private transient AWSCredentials credentials;
    private transient AmazonS3 client;

    public ClientHelper(AWSCredentials credentials, ProxyConfiguration proxy) {
        this(credentials, null, proxy);
    }

    public ClientHelper(AWSCredentials credentials, String region, ProxyConfiguration proxy) {
        this(credentials, null, region, proxy, null, false, true);
    }

    public ClientHelper(AWSCredentials credentials, String endpoint, String region, ProxyConfiguration proxy, String signerVersion, boolean pathStyleAccess, boolean parallelDownloads) {
        this.region = region;
        this.proxy = proxy;
        this.endpoint = endpoint;
        this.signerVersion = signerVersion;
        this.pathStyleAccess = pathStyleAccess;
        this.parallelDownloads = parallelDownloads;
        if (credentials != null) {
            this.accessKey = credentials.getAWSAccessKeyId();
            this.secretKey = credentials.getAWSSecretKey();
        } else {
            this.accessKey = null;
            this.secretKey = null;
        }
    }

    public boolean supportsParallelDownloads() {
        return this.parallelDownloads;
    }

    public synchronized AmazonS3 client() {
        if (this.client == null) {
            AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
            ClientConfiguration config = ClientHelper.getClientConfiguration(this.proxy);
            if (this.getCredentials() != null) {
                builder.setCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(this.getCredentials()));
            }
            if (this.endpoint != null) {
                builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, this.region));
                builder.setPathStyleAccessEnabled(Boolean.valueOf(this.pathStyleAccess));
                config.setSignerOverride(this.signerVersion);
            } else if (this.region != null) {
                builder.setRegion(this.region);
            }
            builder.setClientConfiguration(config);
            this.client = (AmazonS3)builder.build();
        }
        return this.client;
    }

    public static ClientConfiguration getClientConfiguration(ProxyConfiguration proxy) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (ClientHelper.shouldUseProxy(proxy, "s3.amazonaws.com")) {
            clientConfiguration.setProxyHost(proxy.name);
            clientConfiguration.setProxyPort(proxy.port);
            if (proxy.getUserName() != null) {
                clientConfiguration.setProxyUsername(proxy.getUserName());
                clientConfiguration.setProxyPassword(Secret.toString((Secret)proxy.getSecretPassword()));
            }
        }
        return clientConfiguration;
    }

    private static boolean shouldUseProxy(ProxyConfiguration proxy, String hostname) {
        if (proxy == null) {
            return false;
        }
        return proxy.getNoProxyHostPatterns().stream().noneMatch(p -> p.matcher(hostname).matches());
    }

    public synchronized AWSCredentials getCredentials() {
        if (this.credentials == null && this.accessKey != null && this.secretKey != null) {
            this.credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        }
        return this.credentials;
    }
}

