/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.TransferManager;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public final class Downloads {
    private static final Logger LOGGER = Logger.getLogger(Downloads.class.getName());
    private final List<Memo> startedDownloads = new LinkedList<Memo>();

    public void startDownload(TransferManager manager, File base, String pathPrefix, S3ObjectSummary summary) throws AmazonServiceException, IOException {
        File targetFile = FileUtils.getFile((File)base, (String[])new String[]{summary.getKey().substring(pathPrefix.length() + 1)});
        if (targetFile.lastModified() < summary.getLastModified().getTime()) {
            FileUtils.forceMkdir((File)targetFile.getParentFile());
            Download download = manager.download(summary.getBucketName(), summary.getKey(), targetFile);
            this.startedDownloads.add(new Memo(download, targetFile, summary.getLastModified().getTime()));
        }
    }

    public void finishDownloading() throws InterruptedException {
        for (Memo memo : this.startedDownloads) {
            memo.download.waitForCompletion();
            if (memo.file.setLastModified(memo.timestamp)) continue;
            LOGGER.warning("Could not set last modified time on " + String.valueOf(memo.file));
        }
        this.startedDownloads.clear();
    }

    public int count() {
        return this.startedDownloads.size();
    }

    private static class Memo {
        public final Download download;
        public final File file;
        public final long timestamp;

        public Memo(Download download, File file, long timestamp) {
            this.download = download;
            this.file = file;
            this.timestamp = timestamp;
        }
    }
}

