/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.plugins.itemstorage.s3.ClientHelper;
import jenkins.plugins.itemstorage.s3.S3DownloadAllCallable;
import jenkins.plugins.itemstorage.s3.S3DownloadCallable;
import jenkins.plugins.itemstorage.s3.S3UploadAllCallable;
import jenkins.plugins.itemstorage.s3.S3UploadCallable;
import org.kohsuke.stapler.DataBoundConstructor;

public class S3Profile {
    private final ClientHelper helper;
    private final String prefix;

    @DataBoundConstructor
    public S3Profile(AmazonWebServicesCredentials credentials, String endpoint, String region, String prefix, String signerVersion, boolean pathStyleAccess, boolean parallelDownloads) {
        this.helper = new ClientHelper(credentials != null ? credentials.getCredentials() : null, endpoint, region, this.getProxy(), signerVersion, pathStyleAccess, parallelDownloads);
        this.prefix = prefix;
    }

    public void upload(String bucketName, String path, FilePath source, Map<String, String> userMetadata, String storageClass, boolean useServerSideEncryption) throws IOException, InterruptedException {
        S3UploadCallable upload = new S3UploadCallable(this.helper, bucketName, this.withPrefix(path), userMetadata, storageClass, useServerSideEncryption);
        source.act((FilePath.FileCallable)upload);
    }

    public int uploadAll(String bucketName, String path, String fileMask, String excludes, boolean useDefaultExcludes, FilePath source, Map<String, String> userMetadata, String storageClass, boolean useServerSideEncryption) throws IOException, InterruptedException {
        S3UploadAllCallable upload = new S3UploadAllCallable(this.helper, fileMask, excludes, useDefaultExcludes, bucketName, this.withPrefix(path), userMetadata, storageClass, useServerSideEncryption);
        return (Integer)source.act((FilePath.FileCallable)upload);
    }

    public boolean exists(String bucketName, String path) {
        return this.helper.client().doesObjectExist(bucketName, this.withPrefix(path));
    }

    public void download(String bucketName, String key, FilePath target) throws IOException, InterruptedException {
        S3DownloadCallable download = new S3DownloadCallable(this.helper, bucketName, this.withPrefix(key));
        target.act((FilePath.FileCallable)download);
    }

    public int downloadAll(String bucketName, String pathPrefix, String fileMask, String excludes, boolean useDefaultExcludes, FilePath target) throws IOException, InterruptedException {
        S3DownloadAllCallable download = new S3DownloadAllCallable(this.helper, fileMask, excludes, useDefaultExcludes, bucketName, this.withPrefix(pathPrefix));
        return (Integer)target.act((FilePath.FileCallable)download);
    }

    public void delete(String bucketName, String pathPrefix) {
        ObjectListing listing = null;
        do {
            listing = listing == null ? this.helper.client().listObjects(bucketName, this.withPrefix(pathPrefix)) : this.helper.client().listNextBatchOfObjects(listing);
            DeleteObjectsRequest req = new DeleteObjectsRequest(bucketName);
            ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>(listing.getObjectSummaries().size());
            for (S3ObjectSummary summary : listing.getObjectSummaries()) {
                keys.add(new DeleteObjectsRequest.KeyVersion(summary.getKey()));
            }
            req.withKeys(keys);
            this.helper.client().deleteObjects(req);
        } while (listing.isTruncated());
    }

    public void rename(String bucketName, String currentPathPrefix, String newPathPrefix) {
        ObjectListing listing = null;
        do {
            listing = listing == null ? this.helper.client().listObjects(bucketName, this.withPrefix(currentPathPrefix)) : this.helper.client().listNextBatchOfObjects(listing);
            for (S3ObjectSummary summary : listing.getObjectSummaries()) {
                String key = summary.getKey();
                this.helper.client().copyObject(bucketName, key, bucketName, this.withPrefix(newPathPrefix) + key.substring(this.withPrefix(currentPathPrefix).length()));
                this.helper.client().deleteObject(bucketName, key);
            }
        } while (listing.isTruncated());
    }

    private ProxyConfiguration getProxy() {
        return Jenkins.getActiveInstance().proxy;
    }

    private String withPrefix(String path) {
        if (this.prefix == null || this.prefix.trim().isEmpty()) {
            return path;
        }
        return String.format("%s%s", this.prefix, path);
    }
}

