/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import hudson.FilePath;
import hudson.model.Job;
import java.io.IOException;
import java.util.Collections;
import jenkins.plugins.itemstorage.ObjectPath;
import jenkins.plugins.itemstorage.s3.S3Profile;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class S3ObjectPath
extends ObjectPath {
    private final S3Profile profile;
    private final String bucketName;
    private final String region;
    private final String fullName;
    private final String path;

    public S3ObjectPath(S3Profile profile, String bucketName, String region, String fullName, String path) {
        this.profile = profile;
        this.bucketName = bucketName;
        this.region = region;
        this.fullName = fullName;
        this.path = path;
    }

    public S3ObjectPath child(String childPath) throws IOException, InterruptedException {
        return new S3ObjectPath(this.profile, this.bucketName, this.region, this.fullName, this.path + "/" + childPath);
    }

    public void copyTo(FilePath target) throws IOException, InterruptedException {
        this.profile.download(this.bucketName, this.fullName + "/" + this.path, target);
    }

    public void copyFrom(FilePath source) throws IOException, InterruptedException {
        this.profile.upload(this.bucketName, this.fullName + "/" + this.path, source, Collections.emptyMap(), null, false);
    }

    public boolean exists() throws IOException, InterruptedException {
        return this.profile.exists(this.bucketName, this.fullName + "/" + this.path);
    }

    public void deleteRecursive() throws IOException, InterruptedException {
        this.profile.delete(this.bucketName, this.fullName + "/" + this.path);
    }

    public HttpResponse browse(StaplerRequest2 request, StaplerResponse2 response, Job<?, ?> job, String name) throws IOException {
        response.sendRedirect2("https://console.aws.amazon.com/s3/home?region=" + this.region + "#&bucket=" + this.bucketName + "&prefix=" + this.fullName + "/" + this.path + "/");
        return null;
    }
}

