/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.regions.Regions;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.listeners.ItemListener;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.File;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.itemstorage.GlobalItemStorage;
import jenkins.plugins.itemstorage.ItemStorage;
import jenkins.plugins.itemstorage.ItemStorageDescriptor;
import jenkins.plugins.itemstorage.s3.S3ObjectPath;
import jenkins.plugins.itemstorage.s3.S3Profile;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class S3ItemStorage
extends ItemStorage<S3ObjectPath> {
    private final String credentialsId;
    private final String bucketName;
    private final String prefix;
    private final String region;

    @DataBoundConstructor
    public S3ItemStorage(String credentialsId, String bucketName, String prefix, String region) {
        this.credentialsId = credentialsId;
        this.bucketName = bucketName;
        this.prefix = prefix;
        this.region = region;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public S3ObjectPath getObjectPath(Item item, String path) {
        return new S3ObjectPath(this.createS3Profile(), this.bucketName, this.region, item.getFullName(), path);
    }

    public S3ObjectPath getObjectPathForBranch(Item item, String path, String branch) {
        String branchPath = new File(item.getFullName()).getParent() + "/" + branch;
        return new S3ObjectPath(this.createS3Profile(), this.bucketName, this.region, branchPath, path);
    }

    private AmazonWebServicesCredentials lookupCredentials() {
        return this.credentialsId == null ? null : (AmazonWebServicesCredentials)CredentialsMatchers.firstOrNull(S3ItemStorage.possibleCredentials(), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
    }

    private static List<AmazonWebServicesCredentials> possibleCredentials() {
        return CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList());
    }

    private S3Profile createS3Profile() {
        return new S3Profile(this.lookupCredentials(), null, this.region, this.prefix, null, false, true);
    }

    public static final class S3ItemListener
    extends ItemListener {
        public void onDeleted(Item item) {
            S3ItemStorage s3Storage = this.lookupS3Storage();
            if (s3Storage == null) {
                return;
            }
            s3Storage.createS3Profile().delete(s3Storage.bucketName, item.getFullName());
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            S3ItemStorage s3Storage = this.lookupS3Storage();
            if (s3Storage == null) {
                return;
            }
            s3Storage.createS3Profile().rename(s3Storage.bucketName, oldFullName, newFullName);
        }

        private S3ItemStorage lookupS3Storage() {
            ItemStorage storage = GlobalItemStorage.get().getStorage();
            if (storage instanceof S3ItemStorage) {
                return (S3ItemStorage)storage;
            }
            return null;
        }
    }

    @Symbol(value={"s3"})
    @Extension
    public static final class DescriptorImpl
    extends ItemStorageDescriptor<S3ObjectPath> {
        @NonNull
        public String getDisplayName() {
            return "S3 API storage";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().includeEmptyValue().withAll(S3ItemStorage.possibleCredentials());
        }

        @POST
        public ListBoxModel doFillRegionItems() {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            ListBoxModel model = new ListBoxModel();
            for (Regions r : Regions.values()) {
                model.add(r.getName(), r.getName());
            }
            return model;
        }
    }
}

