/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.itemstorage.s3.Destination;

public class Uploads {
    private static final Logger LOGGER = Logger.getLogger(Uploads.class.getName());
    private static final int MULTIPART_UPLOAD_THRESHOLD = 0x1000000;
    private final HashMap<File, Upload> startedUploads = new HashMap();
    private final HashMap<File, InputStream> openedStreams = new HashMap();

    public void startUploading(TransferManager manager, File file, InputStream inputStream, Destination dest, ObjectMetadata metadata) throws AmazonServiceException {
        PutObjectRequest request = new PutObjectRequest(dest.bucketName, dest.objectName, inputStream, metadata);
        request.getRequestClientOptions().setReadLimit(0x1000000);
        manager.getConfiguration().setMultipartUploadThreshold(0x1000000L);
        Upload upload = manager.upload(request);
        this.startedUploads.put(file, upload);
        this.openedStreams.put(file, inputStream);
    }

    public void finishUploading() throws InterruptedException {
        for (Map.Entry<File, Upload> startedUpload : this.startedUploads.entrySet()) {
            this.finishUploading(startedUpload.getKey(), startedUpload.getValue());
        }
        this.startedUploads.clear();
    }

    private void finishUploading(File file, Upload upload) throws InterruptedException {
        if (upload == null) {
            LOGGER.info("File: " + file.getName() + " already was uploaded");
            return;
        }
        try {
            upload.waitForCompletion();
        }
        finally {
            this.closeStream(file, this.openedStreams.remove(file));
        }
    }

    public void cleanup() {
        for (Map.Entry<File, InputStream> openedStream : this.openedStreams.entrySet()) {
            this.closeStream(openedStream.getKey(), openedStream.getValue());
        }
    }

    private void closeStream(File file, InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.warning("Failed to close stream for file:" + String.valueOf(file));
        }
    }

    public int count() {
        return this.startedUploads.size();
    }
}

