/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.itemstorage.s3;

import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.itemstorage.s3.ClientHelper;

abstract class S3Callable<T>
extends MasterToSlaveFileCallable<T> {
    private static final long serialVersionUID = 1L;
    private final ClientHelper helper;

    S3Callable(ClientHelper helper) {
        this.helper = helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        TransferManager transferManager = TransferManagerBuilder.standard().withS3Client(this.helper.client()).withDisableParallelDownloads(Boolean.valueOf(!this.helper.supportsParallelDownloads())).build();
        try {
            T t = this.invoke(transferManager, f, channel);
            return t;
        }
        finally {
            transferManager.shutdownNow(false);
        }
    }

    public T invoke(TransferManager transferManager, File f, VirtualChannel channel) throws IOException, InterruptedException {
        return null;
    }
}

