/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.restlistparam;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.restlistparam.Messages;
import io.jenkins.plugins.restlistparam.RestListParameterGlobalConfig;
import io.jenkins.plugins.restlistparam.RestListParameterValue;
import io.jenkins.plugins.restlistparam.logic.RestValueService;
import io.jenkins.plugins.restlistparam.logic.ValueResolver;
import io.jenkins.plugins.restlistparam.model.MimeType;
import io.jenkins.plugins.restlistparam.model.ResultContainer;
import io.jenkins.plugins.restlistparam.model.ValueItem;
import io.jenkins.plugins.restlistparam.model.ValueOrder;
import io.jenkins.plugins.restlistparam.util.CredentialsUtils;
import io.jenkins.plugins.restlistparam.util.PathExpressionValidationUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public final class RestListParameterDefinition
extends SimpleParameterDefinition {
    private static final long serialVersionUID = 3453376762337829455L;
    private static final RestListParameterGlobalConfig config = RestListParameterGlobalConfig.get();
    private final String restEndpoint;
    private final String credentialId;
    private final MimeType mimeType;
    private final String valueExpression;
    private String displayExpression;
    private ValueOrder valueOrder;
    private String defaultValue;
    private String filter;
    private Integer cacheTime;
    private String errorMsg;
    private List<ValueItem> values;

    @DataBoundConstructor
    public RestListParameterDefinition(String name, String description, String restEndpoint, String credentialId, MimeType mimeType, String valueExpression, String displayExpression) {
        this(name, description, restEndpoint, credentialId, mimeType, valueExpression, displayExpression, ValueOrder.NONE, ".*", config.getCacheTime(), "");
    }

    public RestListParameterDefinition(String name, String description, String restEndpoint, String credentialId, MimeType mimeType, String valueExpression, String displayExpression, ValueOrder valueOrder, String filter, Integer cacheTime, String defaultValue) {
        super(name);
        this.setDescription(description);
        this.restEndpoint = restEndpoint;
        this.mimeType = mimeType;
        this.valueExpression = valueExpression;
        String string = this.credentialId = credentialId != null && !credentialId.trim().isEmpty() ? credentialId : "";
        if (mimeType == MimeType.APPLICATION_JSON) {
            this.displayExpression = !displayExpression.isBlank() ? displayExpression : "$";
        }
        this.defaultValue = defaultValue != null && !defaultValue.trim().isEmpty() ? defaultValue : "";
        this.valueOrder = valueOrder != null ? valueOrder : ValueOrder.NONE;
        this.filter = !filter.isBlank() ? filter : ".*";
        this.cacheTime = cacheTime != null ? cacheTime : config.getCacheTime();
        this.errorMsg = "";
        this.values = Collections.emptyList();
    }

    private RestListParameterDefinition(String name, String description, String restEndpoint, String credentialId, MimeType mimeType, String valueExpression, String displayExpression, ValueOrder valueOrder, String filter, Integer cacheTime, String defaultValue, List<ValueItem> values) {
        super(name);
        this.setDescription(description);
        this.restEndpoint = restEndpoint;
        this.mimeType = mimeType;
        this.valueExpression = valueExpression;
        String string = this.credentialId = credentialId != null && !credentialId.trim().isEmpty() ? credentialId : "";
        if (mimeType == MimeType.APPLICATION_JSON) {
            this.displayExpression = !displayExpression.isBlank() ? displayExpression : "$";
        }
        this.defaultValue = defaultValue != null && !defaultValue.trim().isEmpty() ? defaultValue : "";
        this.valueOrder = valueOrder != null ? valueOrder : ValueOrder.NONE;
        this.filter = !filter.isBlank() ? filter : ".*";
        this.cacheTime = cacheTime != null ? cacheTime : config.getCacheTime();
        this.errorMsg = "";
        this.values = values;
    }

    public String getRestEndpoint() {
        return this.restEndpoint;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getDisplayExpression() {
        if (this.mimeType == MimeType.APPLICATION_JSON) {
            return !this.displayExpression.isBlank() ? this.displayExpression : "$";
        }
        return "";
    }

    @DataBoundSetter
    public void setDisplayExpression(String displayExpression) {
        this.displayExpression = displayExpression;
    }

    @DataBoundSetter
    public void setValueOrder(ValueOrder valueOrder) {
        this.valueOrder = valueOrder;
    }

    public ValueOrder getValueOrder() {
        return this.valueOrder != null ? this.valueOrder : ValueOrder.NONE;
    }

    @DataBoundSetter
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Integer getCacheTime() {
        return this.cacheTime != null ? this.cacheTime : config.getCacheTime();
    }

    @DataBoundSetter
    public void setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @DataBoundSetter
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public List<ValueItem> getValues() {
        Item context = null;
        if (Stapler.getCurrentRequest2() != null) {
            context = (Item)Stapler.getCurrentRequest2().findAncestorObject(Item.class);
        }
        Optional<StandardCredentials> credentials = CredentialsUtils.findCredentials(context, this.credentialId);
        ResultContainer<List<ValueItem>> container = RestValueService.get(this.getRestEndpoint(), credentials.orElse(null), this.getMimeType(), this.getCacheTime(), this.getValueExpression(), this.getDisplayExpression(), this.getFilter(), this.getValueOrder());
        this.setErrorMsg(container.getErrorMsg().orElse(""));
        this.values = container.getValue();
        return this.values;
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof RestListParameterValue) {
            RestListParameterValue value = (RestListParameterValue)defaultValue;
            return new RestListParameterDefinition(this.getName(), this.getDescription(), this.getRestEndpoint(), this.getCredentialId(), this.getMimeType(), this.getValueExpression(), this.getDisplayExpression(), this.getValueOrder(), this.getFilter(), this.getCacheTime(), ValueResolver.parseDisplayValue(this.getMimeType(), value.getValue(), this.displayExpression), this.getValues());
        }
        return this;
    }

    public ParameterValue createValue(String value) {
        RestListParameterValue parameterValue = new RestListParameterValue(this.getName(), value, this.getDescription());
        this.checkValue(parameterValue);
        return parameterValue;
    }

    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        RestListParameterValue value = (RestListParameterValue)((Object)req.bindJSON(RestListParameterValue.class, jo));
        this.checkValue(value);
        return value;
    }

    private void checkValue(RestListParameterValue value) {
        if (!this.isValid(value)) {
            throw new IllegalArgumentException(Messages.RLP_Definition_ValueException(this.getName(), value.getValue()));
        }
    }

    public boolean isValid(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            return false;
        }
        this.getValues();
        return this.values.stream().map(ValueItem::getValue).filter(Objects::nonNull).anyMatch(val -> value.getValue().equals(val));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getDescription(), this.getRestEndpoint(), this.getCredentialId(), this.getMimeType(), this.getValueExpression(), this.getFilter()});
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RestListParameterDefinition other = (RestListParameterDefinition)((Object)obj);
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(this.getRestEndpoint(), other.getRestEndpoint())) {
            return false;
        }
        if (!Objects.equals(this.getCredentialId(), other.getCredentialId())) {
            return false;
        }
        if (!Objects.equals((Object)this.getMimeType(), (Object)other.getMimeType())) {
            return false;
        }
        if (!Objects.equals(this.getValueExpression(), other.getValueExpression())) {
            return false;
        }
        if (!Objects.equals(this.getFilter(), other.getFilter())) {
            return false;
        }
        return Objects.equals(this.defaultValue, other.defaultValue);
    }

    @Symbol(value={"RESTList", "RestList", "RESTListParam"})
    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.RLP_DescriptorImpl_DisplayName();
        }

        public Integer getDefaultCacheTime() {
            return config.getCacheTime();
        }

        @POST
        public FormValidation doCheckRestEndpoint(@AncestorInPath Item context, @QueryParameter String value, @QueryParameter String credentialId) {
            if (context == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                context.checkPermission(Item.CONFIGURE);
            }
            if (value != null && !value.trim().isEmpty()) {
                if (value.matches("^http(s)?://.+")) {
                    Optional<StandardCredentials> credentials = CredentialsUtils.findCredentials(context, credentialId);
                    return RestValueService.doBasicValidation(value, credentials.orElse(null));
                }
                return FormValidation.error((String)Messages.RLP_DescriptorImpl_ValidationErr_EndpointUrl());
            }
            return FormValidation.error((String)Messages.RLP_DescriptorImpl_ValidationErr_EndpointEmpty());
        }

        @POST
        public FormValidation doCheckValueExpression(@AncestorInPath Item context, @QueryParameter String value, @QueryParameter MimeType mimeType) {
            if (context == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                context.checkPermission(Item.CONFIGURE);
            }
            if (value != null && !value.trim().isEmpty()) {
                switch (mimeType) {
                    case APPLICATION_JSON: {
                        return PathExpressionValidationUtils.doCheckJsonPathExpression(value);
                    }
                    case APPLICATION_XML: {
                        return PathExpressionValidationUtils.doCheckXPathExpression(value);
                    }
                }
                return FormValidation.error((String)Messages.RLP_DescriptorImpl_ValidationErr_UnknownMime());
            }
            return FormValidation.error((String)Messages.RLP_DescriptorImpl_ValidationErr_ExpressionEmpty());
        }

        @POST
        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item context, @QueryParameter String credentialId) {
            return CredentialsUtils.doFillCredentialsIdItems(context, credentialId);
        }

        @POST
        public FormValidation doCheckCredentialId(@AncestorInPath Item context, @QueryParameter String value) {
            return CredentialsUtils.doCheckCredentialsId(context, value);
        }

        @POST
        public FormValidation doCheckCacheTime(@AncestorInPath Item context, @QueryParameter Integer cacheTime) {
            if (context == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                context.checkPermission(Item.CONFIGURE);
            }
            if (cacheTime != null && cacheTime >= 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.RLP_DescriptorImpl_ValidationErr_CacheTime());
        }

        @POST
        public FormValidation doTestConfiguration(@AncestorInPath Item context, @QueryParameter String restEndpoint, @QueryParameter String credentialId, @QueryParameter MimeType mimeType, @QueryParameter String valueExpression, @QueryParameter String displayExpression, @QueryParameter String filter, @QueryParameter ValueOrder valueOrder) {
            if (context == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                context.checkPermission(Item.CONFIGURE);
            }
            if (restEndpoint == null || restEndpoint.trim().isEmpty()) {
                return FormValidation.error((String)Messages.RLP_DescriptorImpl_ValidationErr_EndpointEmpty());
            }
            if (mimeType == null) {
                return FormValidation.error((String)Messages.RLP_DescriptorImpl_ValidationErr_UnknownMime());
            }
            if (valueExpression == null || valueExpression.isBlank()) {
                return FormValidation.error((String)Messages.RLP_DescriptorImpl_ValidationErr_ExpressionEmpty());
            }
            Optional<StandardCredentials> credentials = CredentialsUtils.findCredentials(context, credentialId);
            if (credentialId != null && !credentialId.trim().isEmpty() && !credentials.isPresent()) {
                return FormValidation.error((String)Messages.RLP_CredentialsUtils_ValidationErr_CannotFind());
            }
            ResultContainer<List<ValueItem>> container = RestValueService.get(restEndpoint, credentials.orElse(null), mimeType, 0, valueExpression, !displayExpression.isBlank() ? displayExpression : "$", filter, valueOrder);
            Optional<String> errorMsg = container.getErrorMsg();
            List<ValueItem> values = container.getValue();
            if (errorMsg.isPresent()) {
                return FormValidation.error((String)errorMsg.get());
            }
            return FormValidation.ok((String)Messages.RLP_DescriptorImpl_ValidationOk_ConfigValid(values.size(), values.get(0).getDisplayValue()));
        }
    }
}

