// CHECKSTYLE:OFF

package io.jenkins.plugins.restlistparam;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code RLP.GlobalConfig.ValidationErr.CacheSize}: {@code The cache
     * size MUST BE greater than 0 MiB}.
     * 
     * @return
     *     {@code The cache size MUST BE greater than 0 MiB}
     */
    public static String RLP_GlobalConfig_ValidationErr_CacheSize() {
        return holder.format("RLP.GlobalConfig.ValidationErr.CacheSize");
    }

    /**
     * Key {@code RLP.GlobalConfig.ValidationErr.CacheSize}: {@code The cache
     * size MUST BE greater than 0 MiB}.
     * 
     * @return
     *     {@code The cache size MUST BE greater than 0 MiB}
     */
    public static Localizable _RLP_GlobalConfig_ValidationErr_CacheSize() {
        return new Localizable(holder, "RLP.GlobalConfig.ValidationErr.CacheSize");
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationErr.EndpointUrl}: {@code Rest
     * Endpoint is no URL format (http:// or https://)}.
     * 
     * @return
     *     {@code Rest Endpoint is no URL format (http:// or https://)}
     */
    public static String RLP_DescriptorImpl_ValidationErr_EndpointUrl() {
        return holder.format("RLP.DescriptorImpl.ValidationErr.EndpointUrl");
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationErr.EndpointUrl}: {@code Rest
     * Endpoint is no URL format (http:// or https://)}.
     * 
     * @return
     *     {@code Rest Endpoint is no URL format (http:// or https://)}
     */
    public static Localizable _RLP_DescriptorImpl_ValidationErr_EndpointUrl() {
        return new Localizable(holder, "RLP.DescriptorImpl.ValidationErr.EndpointUrl");
    }

    /**
     * Key {@code RLP.RestValueService.warn.FilterErr}: {@code Filtering
     * value list threw {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Filtering value list threw {0}}
     */
    public static String RLP_RestValueService_warn_FilterErr(Object arg0) {
        return holder.format("RLP.RestValueService.warn.FilterErr", arg0);
    }

    /**
     * Key {@code RLP.RestValueService.warn.FilterErr}: {@code Filtering
     * value list threw {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Filtering value list threw {0}}
     */
    public static Localizable _RLP_RestValueService_warn_FilterErr(Object arg0) {
        return new Localizable(holder, "RLP.RestValueService.warn.FilterErr", arg0);
    }

    /**
     * Key {@code PLP.OkHttpUtils.warn.CacheIOException}: {@code Could not
     * creat cache directory for 'REST List Parameter'}.
     * 
     * @return
     *     {@code Could not creat cache directory for 'REST List Parameter'}
     */
    public static String PLP_OkHttpUtils_warn_CacheIOException() {
        return holder.format("PLP.OkHttpUtils.warn.CacheIOException");
    }

    /**
     * Key {@code PLP.OkHttpUtils.warn.CacheIOException}: {@code Could not
     * creat cache directory for 'REST List Parameter'}.
     * 
     * @return
     *     {@code Could not creat cache directory for 'REST List Parameter'}
     */
    public static Localizable _PLP_OkHttpUtils_warn_CacheIOException() {
        return new Localizable(holder, "PLP.OkHttpUtils.warn.CacheIOException");
    }

    /**
     * Key {@code PLP.OkHttpUtils.fine.NoJenkinsInstance}: {@code Could not
     * get Jenkins instance}.
     * 
     * @return
     *     {@code Could not get Jenkins instance}
     */
    public static String PLP_OkHttpUtils_fine_NoJenkinsInstance() {
        return holder.format("PLP.OkHttpUtils.fine.NoJenkinsInstance");
    }

    /**
     * Key {@code PLP.OkHttpUtils.fine.NoJenkinsInstance}: {@code Could not
     * get Jenkins instance}.
     * 
     * @return
     *     {@code Could not get Jenkins instance}
     */
    public static Localizable _PLP_OkHttpUtils_fine_NoJenkinsInstance() {
        return new Localizable(holder, "PLP.OkHttpUtils.fine.NoJenkinsInstance");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.xPath.NoValues}: {@code xPath
     * expression yielded no values}.
     * 
     * @return
     *     {@code xPath expression yielded no values}
     */
    public static String RLP_ValueResolver_warn_xPath_NoValues() {
        return holder.format("RLP.ValueResolver.warn.xPath.NoValues");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.xPath.NoValues}: {@code xPath
     * expression yielded no values}.
     * 
     * @return
     *     {@code xPath expression yielded no values}
     */
    public static Localizable _RLP_ValueResolver_warn_xPath_NoValues() {
        return new Localizable(holder, "RLP.ValueResolver.warn.xPath.NoValues");
    }

    /**
     * Key {@code RLP.GlobalConfig.ValidationErr.CacheTime}: {@code The cache
     * time MUST BE greater or equal 0 Minutes}.
     * 
     * @return
     *     {@code The cache time MUST BE greater or equal 0 Minutes}
     */
    public static String RLP_GlobalConfig_ValidationErr_CacheTime() {
        return holder.format("RLP.GlobalConfig.ValidationErr.CacheTime");
    }

    /**
     * Key {@code RLP.GlobalConfig.ValidationErr.CacheTime}: {@code The cache
     * time MUST BE greater or equal 0 Minutes}.
     * 
     * @return
     *     {@code The cache time MUST BE greater or equal 0 Minutes}
     */
    public static Localizable _RLP_GlobalConfig_ValidationErr_CacheTime() {
        return new Localizable(holder, "RLP.GlobalConfig.ValidationErr.CacheTime");
    }

    /**
     * Key {@code RLP.CredentialsUtils.info.NoPermission}: {@code No
     * permission to list credential}.
     * 
     * @return
     *     {@code No permission to list credential}
     */
    public static String RLP_CredentialsUtils_info_NoPermission() {
        return holder.format("RLP.CredentialsUtils.info.NoPermission");
    }

    /**
     * Key {@code RLP.CredentialsUtils.info.NoPermission}: {@code No
     * permission to list credential}.
     * 
     * @return
     *     {@code No permission to list credential}
     */
    public static Localizable _RLP_CredentialsUtils_info_NoPermission() {
        return new Localizable(holder, "RLP.CredentialsUtils.info.NoPermission");
    }

    /**
     * Key {@code RLP.PathExpressionValidationUtil.FormErr.xPath}: {@code The
     * provided xPath expression seems to be incorrect}.
     * 
     * @return
     *     {@code The provided xPath expression seems to be incorrect}
     */
    public static String RLP_PathExpressionValidationUtil_FormErr_xPath() {
        return holder.format("RLP.PathExpressionValidationUtil.FormErr.xPath");
    }

    /**
     * Key {@code RLP.PathExpressionValidationUtil.FormErr.xPath}: {@code The
     * provided xPath expression seems to be incorrect}.
     * 
     * @return
     *     {@code The provided xPath expression seems to be incorrect}
     */
    public static Localizable _RLP_PathExpressionValidationUtil_FormErr_xPath() {
        return new Localizable(holder, "RLP.PathExpressionValidationUtil.FormErr.xPath");
    }

    /**
     * Key {@code RLP.Definition.ValueException}: {@code Illegal value for
     * parameter {0}: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Illegal value for parameter {0}: {1}}
     */
    public static String RLP_Definition_ValueException(Object arg0, Object arg1) {
        return holder.format("RLP.Definition.ValueException", arg0, arg1);
    }

    /**
     * Key {@code RLP.Definition.ValueException}: {@code Illegal value for
     * parameter {0}: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Illegal value for parameter {0}: {1}}
     */
    public static Localizable _RLP_Definition_ValueException(Object arg0, Object arg1) {
        return new Localizable(holder, "RLP.Definition.ValueException", arg0, arg1);
    }

    /**
     * Key {@code RLP.RestValueService.warn.UnknownHost}: {@code Unknown
     * Host: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown Host: {0}}
     */
    public static String RLP_RestValueService_warn_UnknownHost(Object arg0) {
        return holder.format("RLP.RestValueService.warn.UnknownHost", arg0);
    }

    /**
     * Key {@code RLP.RestValueService.warn.UnknownHost}: {@code Unknown
     * Host: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown Host: {0}}
     */
    public static Localizable _RLP_RestValueService_warn_UnknownHost(Object arg0) {
        return new Localizable(holder, "RLP.RestValueService.warn.UnknownHost", arg0);
    }

    /**
     * Key {@code RLP.RestValueService.fine.UsingBearerAuth}: {@code Using
     * Bearer auth type to request REST-Values}.
     * 
     * @return
     *     {@code Using Bearer auth type to request REST-Values}
     */
    public static String RLP_RestValueService_fine_UsingBearerAuth() {
        return holder.format("RLP.RestValueService.fine.UsingBearerAuth");
    }

    /**
     * Key {@code RLP.RestValueService.fine.UsingBearerAuth}: {@code Using
     * Bearer auth type to request REST-Values}.
     * 
     * @return
     *     {@code Using Bearer auth type to request REST-Values}
     */
    public static Localizable _RLP_RestValueService_fine_UsingBearerAuth() {
        return new Localizable(holder, "RLP.RestValueService.fine.UsingBearerAuth");
    }

    /**
     * Key {@code RLP.DescriptorImpl.DisplayName}: {@code REST List
     * Parameter}.
     * 
     * @return
     *     {@code REST List Parameter}
     */
    public static String RLP_DescriptorImpl_DisplayName() {
        return holder.format("RLP.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code RLP.DescriptorImpl.DisplayName}: {@code REST List
     * Parameter}.
     * 
     * @return
     *     {@code REST List Parameter}
     */
    public static Localizable _RLP_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "RLP.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code RLP.RestValueService.warn.ReqClientErr}: {@code Encountered
     * Http Client Error: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encountered Http Client Error: {0}}
     */
    public static String RLP_RestValueService_warn_ReqClientErr(Object arg0) {
        return holder.format("RLP.RestValueService.warn.ReqClientErr", arg0);
    }

    /**
     * Key {@code RLP.RestValueService.warn.ReqClientErr}: {@code Encountered
     * Http Client Error: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encountered Http Client Error: {0}}
     */
    public static Localizable _RLP_RestValueService_warn_ReqClientErr(Object arg0) {
        return new Localizable(holder, "RLP.RestValueService.warn.ReqClientErr", arg0);
    }

    /**
     * Key {@code RLP.RestValueService.warn.ReqServerErr}: {@code Encountered
     * Http Server Error: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encountered Http Server Error: {0}}
     */
    public static String RLP_RestValueService_warn_ReqServerErr(Object arg0) {
        return holder.format("RLP.RestValueService.warn.ReqServerErr", arg0);
    }

    /**
     * Key {@code RLP.RestValueService.warn.ReqServerErr}: {@code Encountered
     * Http Server Error: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encountered Http Server Error: {0}}
     */
    public static Localizable _RLP_RestValueService_warn_ReqServerErr(Object arg0) {
        return new Localizable(holder, "RLP.RestValueService.warn.ReqServerErr", arg0);
    }

    /**
     * Key {@code RLP.ValueResolver.warn.xPath.DisplayExpression}: {@code The
     * DisplayExpression option is unsupported for XML values!}.
     * 
     * @return
     *     {@code The DisplayExpression option is unsupported for XML values!}
     */
    public static String RLP_ValueResolver_warn_xPath_DisplayExpression() {
        return holder.format("RLP.ValueResolver.warn.xPath.DisplayExpression");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.xPath.DisplayExpression}: {@code The
     * DisplayExpression option is unsupported for XML values!}.
     * 
     * @return
     *     {@code The DisplayExpression option is unsupported for XML values!}
     */
    public static Localizable _RLP_ValueResolver_warn_xPath_DisplayExpression() {
        return new Localizable(holder, "RLP.ValueResolver.warn.xPath.DisplayExpression");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.jPath.ExpressionErr}: {@code Error
     * in provided Json-Path expression}.
     * 
     * @return
     *     {@code Error in provided Json-Path expression}
     */
    public static String RLP_ValueResolver_warn_jPath_ExpressionErr() {
        return holder.format("RLP.ValueResolver.warn.jPath.ExpressionErr");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.jPath.ExpressionErr}: {@code Error
     * in provided Json-Path expression}.
     * 
     * @return
     *     {@code Error in provided Json-Path expression}
     */
    public static Localizable _RLP_ValueResolver_warn_jPath_ExpressionErr() {
        return new Localizable(holder, "RLP.ValueResolver.warn.jPath.ExpressionErr");
    }

    /**
     * Key {@code RLP.CredentialsUtils.ValidationWrn.ExpressionBased}: {@code
     * Cannot validate expression based credentials}.
     * 
     * @return
     *     {@code Cannot validate expression based credentials}
     */
    public static String RLP_CredentialsUtils_ValidationWrn_ExpressionBased() {
        return holder.format("RLP.CredentialsUtils.ValidationWrn.ExpressionBased");
    }

    /**
     * Key {@code RLP.CredentialsUtils.ValidationWrn.ExpressionBased}: {@code
     * Cannot validate expression based credentials}.
     * 
     * @return
     *     {@code Cannot validate expression based credentials}
     */
    public static Localizable _RLP_CredentialsUtils_ValidationWrn_ExpressionBased() {
        return new Localizable(holder, "RLP.CredentialsUtils.ValidationWrn.ExpressionBased");
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationErr.UnknownMime}: {@code
     * Unknown MimeType}.
     * 
     * @return
     *     {@code Unknown MimeType}
     */
    public static String RLP_DescriptorImpl_ValidationErr_UnknownMime() {
        return holder.format("RLP.DescriptorImpl.ValidationErr.UnknownMime");
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationErr.UnknownMime}: {@code
     * Unknown MimeType}.
     * 
     * @return
     *     {@code Unknown MimeType}
     */
    public static Localizable _RLP_DescriptorImpl_ValidationErr_UnknownMime() {
        return new Localizable(holder, "RLP.DescriptorImpl.ValidationErr.UnknownMime");
    }

    /**
     * Key {@code PLP.OkHttpUtils.fine.CacheCreationSuccess}: {@code Using
     * OKHttpClient WITH {0} MiB cache}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Using OKHttpClient WITH {0} MiB cache}
     */
    public static String PLP_OkHttpUtils_fine_CacheCreationSuccess(Object arg0) {
        return holder.format("PLP.OkHttpUtils.fine.CacheCreationSuccess", arg0);
    }

    /**
     * Key {@code PLP.OkHttpUtils.fine.CacheCreationSuccess}: {@code Using
     * OKHttpClient WITH {0} MiB cache}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Using OKHttpClient WITH {0} MiB cache}
     */
    public static Localizable _PLP_OkHttpUtils_fine_CacheCreationSuccess(Object arg0) {
        return new Localizable(holder, "PLP.OkHttpUtils.fine.CacheCreationSuccess", arg0);
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationErr.ExpressionEmpty}: {@code
     * Value Expression must not be empty}.
     * 
     * @return
     *     {@code Value Expression must not be empty}
     */
    public static String RLP_DescriptorImpl_ValidationErr_ExpressionEmpty() {
        return holder.format("RLP.DescriptorImpl.ValidationErr.ExpressionEmpty");
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationErr.ExpressionEmpty}: {@code
     * Value Expression must not be empty}.
     * 
     * @return
     *     {@code Value Expression must not be empty}
     */
    public static Localizable _RLP_DescriptorImpl_ValidationErr_ExpressionEmpty() {
        return new Localizable(holder, "RLP.DescriptorImpl.ValidationErr.ExpressionEmpty");
    }

    /**
     * Key {@code RLP.RestValueService.info.FilterReturnedNoValues}: {@code
     * The filter `{0}` left no values to be displayed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The filter `{0}` left no values to be displayed}
     */
    public static String RLP_RestValueService_info_FilterReturnedNoValues(Object arg0) {
        return holder.format("RLP.RestValueService.info.FilterReturnedNoValues", arg0);
    }

    /**
     * Key {@code RLP.RestValueService.info.FilterReturnedNoValues}: {@code
     * The filter `{0}` left no values to be displayed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The filter `{0}` left no values to be displayed}
     */
    public static Localizable _RLP_RestValueService_info_FilterReturnedNoValues(Object arg0) {
        return new Localizable(holder, "RLP.RestValueService.info.FilterReturnedNoValues", arg0);
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationErr.EndpointEmpty}: {@code
     * Rest Endpoint must not be empty}.
     * 
     * @return
     *     {@code Rest Endpoint must not be empty}
     */
    public static String RLP_DescriptorImpl_ValidationErr_EndpointEmpty() {
        return holder.format("RLP.DescriptorImpl.ValidationErr.EndpointEmpty");
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationErr.EndpointEmpty}: {@code
     * Rest Endpoint must not be empty}.
     * 
     * @return
     *     {@code Rest Endpoint must not be empty}
     */
    public static Localizable _RLP_DescriptorImpl_ValidationErr_EndpointEmpty() {
        return new Localizable(holder, "RLP.DescriptorImpl.ValidationErr.EndpointEmpty");
    }

    /**
     * Key {@code RLP.RestValueService.warn.OkHttpErr}: {@code OKHttp request
     * threw {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code OKHttp request threw {0}}
     */
    public static String RLP_RestValueService_warn_OkHttpErr(Object arg0) {
        return holder.format("RLP.RestValueService.warn.OkHttpErr", arg0);
    }

    /**
     * Key {@code RLP.RestValueService.warn.OkHttpErr}: {@code OKHttp request
     * threw {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code OKHttp request threw {0}}
     */
    public static Localizable _RLP_RestValueService_warn_OkHttpErr(Object arg0) {
        return new Localizable(holder, "RLP.RestValueService.warn.OkHttpErr", arg0);
    }

    /**
     * Key {@code RLP.ValueResolver.warn.xPath.ParserInit}: {@code XML parser
     * initialization threw {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code XML parser initialization threw {0}}
     */
    public static String RLP_ValueResolver_warn_xPath_ParserInit(Object arg0) {
        return holder.format("RLP.ValueResolver.warn.xPath.ParserInit", arg0);
    }

    /**
     * Key {@code RLP.ValueResolver.warn.xPath.ParserInit}: {@code XML parser
     * initialization threw {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code XML parser initialization threw {0}}
     */
    public static Localizable _RLP_ValueResolver_warn_xPath_ParserInit(Object arg0) {
        return new Localizable(holder, "RLP.ValueResolver.warn.xPath.ParserInit", arg0);
    }

    /**
     * Key {@code RLP.RestValueService.warn.UnsupportedCredential}: {@code
     * Attempted to use unsupported Credential type: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Attempted to use unsupported Credential type: {0}}
     */
    public static String RLP_RestValueService_warn_UnsupportedCredential(Object arg0) {
        return holder.format("RLP.RestValueService.warn.UnsupportedCredential", arg0);
    }

    /**
     * Key {@code RLP.RestValueService.warn.UnsupportedCredential}: {@code
     * Attempted to use unsupported Credential type: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Attempted to use unsupported Credential type: {0}}
     */
    public static Localizable _RLP_RestValueService_warn_UnsupportedCredential(Object arg0) {
        return new Localizable(holder, "RLP.RestValueService.warn.UnsupportedCredential", arg0);
    }

    /**
     * Key {@code RLP.CredentialsUtils.ValidationErr.CannotFind}: {@code
     * Cannot find currently selected credentials}.
     * 
     * @return
     *     {@code Cannot find currently selected credentials}
     */
    public static String RLP_CredentialsUtils_ValidationErr_CannotFind() {
        return holder.format("RLP.CredentialsUtils.ValidationErr.CannotFind");
    }

    /**
     * Key {@code RLP.CredentialsUtils.ValidationErr.CannotFind}: {@code
     * Cannot find currently selected credentials}.
     * 
     * @return
     *     {@code Cannot find currently selected credentials}
     */
    public static Localizable _RLP_CredentialsUtils_ValidationErr_CannotFind() {
        return new Localizable(holder, "RLP.CredentialsUtils.ValidationErr.CannotFind");
    }

    /**
     * Key {@code RLP.RestValueService.fine.UsingBasicAuth}: {@code Using
     * Basic auth type to request REST-Values}.
     * 
     * @return
     *     {@code Using Basic auth type to request REST-Values}
     */
    public static String RLP_RestValueService_fine_UsingBasicAuth() {
        return holder.format("RLP.RestValueService.fine.UsingBasicAuth");
    }

    /**
     * Key {@code RLP.RestValueService.fine.UsingBasicAuth}: {@code Using
     * Basic auth type to request REST-Values}.
     * 
     * @return
     *     {@code Using Basic auth type to request REST-Values}
     */
    public static Localizable _RLP_RestValueService_fine_UsingBasicAuth() {
        return new Localizable(holder, "RLP.RestValueService.fine.UsingBasicAuth");
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationErr.CacheTime}: {@code The
     * time to cache for MUST BE positive or 0}.
     * 
     * @return
     *     {@code The time to cache for MUST BE positive or 0}
     */
    public static String RLP_DescriptorImpl_ValidationErr_CacheTime() {
        return holder.format("RLP.DescriptorImpl.ValidationErr.CacheTime");
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationErr.CacheTime}: {@code The
     * time to cache for MUST BE positive or 0}.
     * 
     * @return
     *     {@code The time to cache for MUST BE positive or 0}
     */
    public static Localizable _RLP_DescriptorImpl_ValidationErr_CacheTime() {
        return new Localizable(holder, "RLP.DescriptorImpl.ValidationErr.CacheTime");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.xPath.MalformedXml}: {@code Tried to
     * pars malformed XML}.
     * 
     * @return
     *     {@code Tried to pars malformed XML}
     */
    public static String RLP_ValueResolver_warn_xPath_MalformedXml() {
        return holder.format("RLP.ValueResolver.warn.xPath.MalformedXml");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.xPath.MalformedXml}: {@code Tried to
     * pars malformed XML}.
     * 
     * @return
     *     {@code Tried to pars malformed XML}
     */
    public static Localizable _RLP_ValueResolver_warn_xPath_MalformedXml() {
        return new Localizable(holder, "RLP.ValueResolver.warn.xPath.MalformedXml");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.jPath.MalformedJson}: {@code Tried
     * to pars malformed Json}.
     * 
     * @return
     *     {@code Tried to pars malformed Json}
     */
    public static String RLP_ValueResolver_warn_jPath_MalformedJson() {
        return holder.format("RLP.ValueResolver.warn.jPath.MalformedJson");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.jPath.MalformedJson}: {@code Tried
     * to pars malformed Json}.
     * 
     * @return
     *     {@code Tried to pars malformed Json}
     */
    public static Localizable _RLP_ValueResolver_warn_jPath_MalformedJson() {
        return new Localizable(holder, "RLP.ValueResolver.warn.jPath.MalformedJson");
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationOk.ConfigValid}: {@code Test
     * Successful! {0} Values, first: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test Successful! {0} Values, first: {1}}
     */
    public static String RLP_DescriptorImpl_ValidationOk_ConfigValid(Object arg0, Object arg1) {
        return holder.format("RLP.DescriptorImpl.ValidationOk.ConfigValid", arg0, arg1);
    }

    /**
     * Key {@code RLP.DescriptorImpl.ValidationOk.ConfigValid}: {@code Test
     * Successful! {0} Values, first: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test Successful! {0} Values, first: {1}}
     */
    public static Localizable _RLP_DescriptorImpl_ValidationOk_ConfigValid(Object arg0, Object arg1) {
        return new Localizable(holder, "RLP.DescriptorImpl.ValidationOk.ConfigValid", arg0, arg1);
    }

    /**
     * Key {@code RLP.ValueResolver.warn.jPath.NoValues}: {@code Json-Path
     * expression yielded no results}.
     * 
     * @return
     *     {@code Json-Path expression yielded no results}
     */
    public static String RLP_ValueResolver_warn_jPath_NoValues() {
        return holder.format("RLP.ValueResolver.warn.jPath.NoValues");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.jPath.NoValues}: {@code Json-Path
     * expression yielded no results}.
     * 
     * @return
     *     {@code Json-Path expression yielded no results}
     */
    public static Localizable _RLP_ValueResolver_warn_jPath_NoValues() {
        return new Localizable(holder, "RLP.ValueResolver.warn.jPath.NoValues");
    }

    /**
     * Key {@code RLP.PathExpressionValidationUtil.FormErr.jPath}: {@code The
     * provided Json-Path expression seems to be incorrect}.
     * 
     * @return
     *     {@code The provided Json-Path expression seems to be incorrect}
     */
    public static String RLP_PathExpressionValidationUtil_FormErr_jPath() {
        return holder.format("RLP.PathExpressionValidationUtil.FormErr.jPath");
    }

    /**
     * Key {@code RLP.PathExpressionValidationUtil.FormErr.jPath}: {@code The
     * provided Json-Path expression seems to be incorrect}.
     * 
     * @return
     *     {@code The provided Json-Path expression seems to be incorrect}
     */
    public static Localizable _RLP_PathExpressionValidationUtil_FormErr_jPath() {
        return new Localizable(holder, "RLP.PathExpressionValidationUtil.FormErr.jPath");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.xPath.ExpressionErr}: {@code Error
     * in provided xPath expression}.
     * 
     * @return
     *     {@code Error in provided xPath expression}
     */
    public static String RLP_ValueResolver_warn_xPath_ExpressionErr() {
        return holder.format("RLP.ValueResolver.warn.xPath.ExpressionErr");
    }

    /**
     * Key {@code RLP.ValueResolver.warn.xPath.ExpressionErr}: {@code Error
     * in provided xPath expression}.
     * 
     * @return
     *     {@code Error in provided xPath expression}
     */
    public static Localizable _RLP_ValueResolver_warn_xPath_ExpressionErr() {
        return new Localizable(holder, "RLP.ValueResolver.warn.xPath.ExpressionErr");
    }

}
