/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.restlistparam.logic;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.util.FormValidation;
import io.jenkins.plugins.restlistparam.Messages;
import io.jenkins.plugins.restlistparam.logic.ValueResolver;
import io.jenkins.plugins.restlistparam.model.MimeType;
import io.jenkins.plugins.restlistparam.model.ResultContainer;
import io.jenkins.plugins.restlistparam.model.ValueItem;
import io.jenkins.plugins.restlistparam.model.ValueOrder;
import io.jenkins.plugins.restlistparam.util.OkHttpUtils;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class RestValueService {
    private static final Logger log = Logger.getLogger(RestValueService.class.getName());
    private static final String EX_CLASS = "Exception Class: ";
    private static final String EX_MESSAGE = "Exception Message: ";

    private RestValueService() {
        throw new IllegalStateException("Static Logic class");
    }

    public static ResultContainer<List<ValueItem>> get(String restEndpoint, StandardCredentials credentials, MimeType mimeType, Integer cacheTime, String valueExpression, String displayExpression, String filter, ValueOrder order) {
        ResultContainer<List<ValueItem>> valueList = new ResultContainer(Collections.emptyList());
        ResultContainer<String> rawValues = RestValueService.getValueStringFromRestEndpoint(restEndpoint, credentials, mimeType, cacheTime);
        Optional<String> rawValueError = rawValues.getErrorMsg();
        if (!rawValueError.isPresent()) {
            valueList = RestValueService.convertToValuesList(mimeType, rawValues.getValue(), valueExpression, displayExpression);
        } else {
            valueList.setErrorMsg(rawValueError.get());
        }
        if (!valueList.getErrorMsg().isPresent() && RestValueService.isFilterOrOrderSet(filter, order)) {
            valueList = RestValueService.filterAndSortValues(valueList.getValue(), filter, order);
        }
        return valueList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FormValidation doBasicValidation(String restEndpoint, StandardCredentials credentials) {
        OkHttpClient client = OkHttpUtils.getClientWithProxyAndCache(restEndpoint);
        Request.Builder builder = new Request.Builder().cacheControl(OkHttpUtils.getCacheControl(0)).url(restEndpoint);
        if (credentials != null) {
            builder.addHeader("Authorization", RestValueService.buildAuthTypeWithCredential(credentials));
        }
        try (Response response = client.newCall(builder.build()).execute();){
            int statusCode = response.code();
            if (statusCode < 400) {
                FormValidation formValidation = FormValidation.ok();
                return formValidation;
            }
            if (statusCode < 500) {
                FormValidation formValidation = FormValidation.error((String)Messages.RLP_RestValueService_warn_ReqClientErr(statusCode));
                return formValidation;
            }
            FormValidation formValidation = FormValidation.error((String)Messages.RLP_RestValueService_warn_ReqServerErr(statusCode));
            return formValidation;
        }
        catch (UnknownHostException ex) {
            return FormValidation.error((String)Messages.RLP_RestValueService_warn_UnknownHost(ex.getMessage()));
        }
        catch (IOException ex) {
            return FormValidation.error((String)Messages.RLP_RestValueService_warn_OkHttpErr(ex.getClass().getName()));
        }
    }

    private static ResultContainer<String> getValueStringFromRestEndpoint(String restEndpoint, StandardCredentials credentials, MimeType mimeType, Integer cacheTime) {
        ResultContainer<String> container = new ResultContainer<String>("");
        OkHttpClient client = OkHttpUtils.getClientWithProxyAndCache(restEndpoint);
        Request request = new Request.Builder().url(restEndpoint).cacheControl(OkHttpUtils.getCacheControl(cacheTime)).headers(RestValueService.buildHeaders(credentials, mimeType)).build();
        try (Response response = client.newCall(request).execute();){
            int statusCode = response.code();
            if (statusCode < 400) {
                String value = "";
                ResponseBody body = response.body();
                if (body != null) {
                    value = body.string();
                }
                container.setValue(value);
            } else if (statusCode < 500) {
                log.warning(Messages.RLP_RestValueService_warn_ReqClientErr(statusCode));
                container.setErrorMsg(Messages.RLP_RestValueService_warn_ReqClientErr(statusCode));
            } else {
                log.warning(Messages.RLP_RestValueService_warn_ReqServerErr(statusCode));
                container.setErrorMsg(Messages.RLP_RestValueService_warn_ReqServerErr(statusCode));
            }
        }
        catch (UnknownHostException ex) {
            log.warning(Messages.RLP_RestValueService_warn_UnknownHost(ex.getMessage()));
            container.setErrorMsg(Messages.RLP_RestValueService_warn_UnknownHost(ex.getMessage()));
        }
        catch (IOException ex) {
            log.warning(Messages.RLP_RestValueService_warn_OkHttpErr(ex.getClass().getName()));
            container.setErrorMsg(Messages.RLP_RestValueService_warn_OkHttpErr(ex.getClass().getName()));
            log.fine(EX_CLASS + ex.getClass().getName() + "\nException Message: " + ex.getMessage());
        }
        return container;
    }

    private static Headers buildHeaders(StandardCredentials credentials, MimeType mimeType) {
        Headers.Builder headBuilder = new Headers.Builder().add("Accept", mimeType.getMime());
        if (credentials != null) {
            headBuilder.add("Authorization", RestValueService.buildAuthTypeWithCredential(credentials));
        }
        return headBuilder.build();
    }

    private static String buildAuthTypeWithCredential(StandardCredentials credentials) {
        Object authTypeWithCredential = "";
        if (credentials instanceof StandardUsernamePasswordCredentials) {
            log.fine(Messages.RLP_RestValueService_fine_UsingBasicAuth());
            StandardUsernamePasswordCredentials cred = (StandardUsernamePasswordCredentials)credentials;
            String uNameAndPasswd = cred.getUsername() + ":" + cred.getPassword().getPlainText();
            authTypeWithCredential = "Basic " + Base64.getEncoder().encodeToString(uNameAndPasswd.getBytes(StandardCharsets.UTF_8));
        } else if (credentials instanceof StringCredentials) {
            log.fine(Messages.RLP_RestValueService_fine_UsingBearerAuth());
            StringCredentials cred = (StringCredentials)credentials;
            authTypeWithCredential = "Bearer " + cred.getSecret().getPlainText();
        } else {
            log.warning(Messages.RLP_RestValueService_warn_UnsupportedCredential(credentials.getClass().getName()));
        }
        return authTypeWithCredential;
    }

    private static ResultContainer<List<ValueItem>> convertToValuesList(MimeType mimeType, String valueString, String valueExpression, String displayExpression) {
        return switch (mimeType) {
            case MimeType.APPLICATION_JSON -> ValueResolver.resolveJsonPath(valueString, valueExpression, displayExpression);
            case MimeType.APPLICATION_XML -> ValueResolver.resolveXPath(valueString, valueExpression, displayExpression);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)mimeType));
        };
    }

    private static ResultContainer<List<ValueItem>> filterAndSortValues(List<ValueItem> values, String filter, ValueOrder order) {
        ResultContainer<List<ValueItem>> container = new ResultContainer<List<ValueItem>>(Collections.emptyList());
        try {
            Stream<Object> valueStream = values.stream();
            if (RestValueService.isFilterSet(filter)) {
                valueStream = valueStream.filter(value -> value.getValue().matches(filter));
            }
            if (order == ValueOrder.ASC) {
                valueStream = valueStream.sorted(Comparator.naturalOrder());
            } else if (order == ValueOrder.DSC) {
                valueStream = valueStream.sorted(Comparator.reverseOrder());
            }
            List updatedValues = valueStream.collect(Collectors.toList());
            if (!updatedValues.isEmpty()) {
                if (order == ValueOrder.REV) {
                    Collections.reverse(updatedValues);
                }
                container.setValue(updatedValues);
            } else {
                container.setErrorMsg(Messages.RLP_RestValueService_info_FilterReturnedNoValues(filter));
            }
        }
        catch (Exception ex) {
            log.warning(Messages.RLP_RestValueService_warn_FilterErr(ex.getClass().getName()));
            container.setErrorMsg(Messages.RLP_RestValueService_warn_FilterErr(ex.getClass().getName()));
            log.fine(EX_CLASS + ex.getClass().getName() + "\nException Message: " + ex.getMessage());
        }
        return container;
    }

    private static boolean isFilterOrOrderSet(String filter, ValueOrder order) {
        return RestValueService.isFilterSet(filter) || RestValueService.isOrderSet(order);
    }

    private static boolean isFilterSet(String filter) {
        return StringUtils.isNotBlank((String)filter) && !filter.equalsIgnoreCase(".*");
    }

    private static boolean isOrderSet(ValueOrder order) {
        return order != null && order != ValueOrder.NONE;
    }
}

