/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.restlistparam;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.util.VariableResolver;
import java.util.Locale;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public final class RestListParameterValue
extends ParameterValue {
    @Exported(visibility=4)
    @Restricted(value={NoExternalUse.class})
    private final String value;

    @DataBoundConstructor
    public RestListParameterValue(String name, String value) {
        this(name, value, null);
    }

    public RestListParameterValue(String name, String value, String description) {
        super(name, description);
        this.value = value;
    }

    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.name, this.value);
        env.put(this.name.toUpperCase(Locale.ENGLISH), this.value);
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return name -> this.name.equals(name) ? this.value : null;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RestListParameterValue other = (RestListParameterValue)((Object)obj);
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public String toString() {
        return "{\"type\": \"RestListParameterValue\", \"name:\": \"" + this.getName() + "\", \"value\": \"" + this.value + "\"}";
    }

    public String getShortDescription() {
        return this.name + "=" + this.value;
    }
}

