/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.chatbot;

import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.User;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.GET;

@Extension
public class ChatbotRootAction
implements RootAction {
    private static final String PYTHON_BACKEND_URL = "http://localhost:8000/api/chatbot";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "chatbot";
    }

    public void doDynamic(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.checkPermissions();
        String path = req.getRestOfPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.contains("..")) {
            rsp.sendError(400, "Invalid path");
            return;
        }
        StringBuilder targetUrlBuilder = new StringBuilder(PYTHON_BACKEND_URL);
        targetUrlBuilder.append("/").append(path);
        if (req.getQueryString() != null) {
            targetUrlBuilder.append("?").append(req.getQueryString());
        }
        String targetUrl = targetUrlBuilder.toString();
        String method = req.getMethod();
        if ("POST".equalsIgnoreCase(method)) {
            this.proxyStreamRequest(req, rsp, targetUrl);
        } else if ("GET".equalsIgnoreCase(method)) {
            this.proxyGetRequest(rsp, targetUrl);
        } else if ("DELETE".equalsIgnoreCase(method)) {
            this.proxyDeleteRequest(rsp, targetUrl);
        } else {
            rsp.sendError(405, "Method Not Allowed");
        }
    }

    @GET
    public void doWhoAmI(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        User user = User.current();
        String userId = user != null ? user.getId() : "anonymous";
        String fullName = user != null ? user.getFullName() : "N/A";
        boolean isAdmin = Jenkins.get().hasPermission(Jenkins.ADMINISTER);
        JSONObject json = new JSONObject();
        json.put("user_id", (Object)userId);
        json.put("full_name", (Object)fullName);
        json.put("is_admin", (Object)isAdmin);
        json.put("jenkins_url", (Object)Jenkins.get().getRootUrl());
        rsp.setContentType("application/json");
        rsp.getWriter().write(json.toString());
    }

    private void checkPermissions() {
        Jenkins.get().checkPermission(Jenkins.READ);
    }

    private void addAuthHeaders(HttpURLConnection conn) {
        User user = User.current();
        if (user != null) {
            conn.setRequestProperty("X-Jenkins-User-ID", user.getId());
            String cleanName = user.getDisplayName().replaceAll("[^a-zA-Z0-9 ]", "");
            conn.setRequestProperty("X-Jenkins-User-Name", cleanName);
        } else {
            conn.setRequestProperty("X-Jenkins-User-ID", "anonymous");
            conn.setRequestProperty("X-Jenkins-User-Name", "Anonymous");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyStreamRequest(StaplerRequest2 req, StaplerResponse2 rsp, String targetUrl) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL url = URI.create(targetUrl).toURL();
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(req.getMethod());
            conn.setRequestProperty("Content-Type", req.getContentType());
            this.addAuthHeaders(conn);
            conn.setDoOutput(true);
            IOUtils.copy((InputStream)req.getInputStream(), (OutputStream)conn.getOutputStream());
            this.copyBackendResponse(conn, rsp);
        }
        catch (Exception e) {
            this.handleProxyError(rsp, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyGetRequest(StaplerResponse2 rsp, String targetUrl) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL url = URI.create(targetUrl).toURL();
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            this.addAuthHeaders(conn);
            this.copyBackendResponse(conn, rsp);
        }
        catch (Exception e) {
            this.handleProxyError(rsp, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyDeleteRequest(StaplerResponse2 rsp, String targetUrl) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL url = URI.create(targetUrl).toURL();
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("DELETE");
            this.addAuthHeaders(conn);
            this.copyBackendResponse(conn, rsp);
        }
        catch (Exception e) {
            this.handleProxyError(rsp, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void copyBackendResponse(HttpURLConnection conn, StaplerResponse2 rsp) throws IOException {
        InputStream backendStream;
        int status = conn.getResponseCode();
        rsp.setStatus(status);
        rsp.setContentType(conn.getContentType());
        InputStream inputStream = backendStream = status >= 400 ? conn.getErrorStream() : conn.getInputStream();
        if (backendStream != null) {
            IOUtils.copy((InputStream)backendStream, (OutputStream)rsp.getOutputStream());
        }
    }

    private void handleProxyError(StaplerResponse2 rsp, Exception e) throws IOException {
        e.printStackTrace();
        rsp.sendError(500, "Chatbot Proxy Error: " + e.getMessage());
    }
}

