/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.chatbot;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.model.User;
import hudson.security.csrf.CrumbExclusion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class ChatbotRootAction
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(ChatbotRootAction.class.getName());
    private static final String PYTHON_BACKEND_URL = "http://localhost:8000";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "chatbot";
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String path = req.getRestOfPath();
        LOGGER.log(Level.INFO, "ChatbotRootAction received request: {0} {1}", new Object[]{req.getMethod(), path});
        User user = User.current();
        if (user == null) {
            LOGGER.log(Level.WARNING, "Unauthenticated access attempt to chatbot API");
            rsp.sendError(401, "Authentication required");
            return;
        }
        String userId = user.getId();
        LOGGER.log(Level.INFO, "Authenticated user: {0}", userId);
        Jenkins jenkins = Jenkins.get();
        if (!jenkins.hasPermission(Jenkins.READ)) {
            LOGGER.log(Level.WARNING, "User {0} lacks Jenkins.READ permission", userId);
            rsp.sendError(403, "Insufficient permissions");
            return;
        }
        try {
            this.proxyRequest(req, rsp, userId, path);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error proxying request to backend", e);
            rsp.sendError(500, "Failed to communicate with chatbot backend");
        }
    }

    private void proxyRequest(StaplerRequest req, StaplerResponse rsp, String userId, String path) throws IOException, JSONException {
        byte[] buffer;
        OutputStream os;
        Object is;
        String method = req.getMethod();
        String backendUrl = PYTHON_BACKEND_URL + path;
        LOGGER.log(Level.FINE, "Proxying {0} request to: {1}", new Object[]{method, backendUrl});
        URL url = new URL(backendUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headerName.equalsIgnoreCase("Host") || headerName.equalsIgnoreCase("Authorization") || headerName.equalsIgnoreCase("Cookie")) continue;
            String headerValue = req.getHeader(headerName);
            conn.setRequestProperty(headerName, headerValue);
        }
        if ("POST".equals(method) || "PUT".equals(method) || "PATCH".equals(method)) {
            conn.setDoOutput(true);
            String contentType = req.getContentType();
            if (contentType != null && contentType.contains("application/json")) {
                StringBuilder bodyBuilder = new StringBuilder();
                try (BufferedReader reader = req.getReader();){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        bodyBuilder.append(line);
                    }
                }
                String originalBody = bodyBuilder.toString();
                JSONObject jsonBody = originalBody.isEmpty() ? new JSONObject() : new JSONObject(originalBody);
                jsonBody.put("user_id", (Object)userId);
                String modifiedBody = jsonBody.toString();
                LOGGER.log(Level.FINE, "Modified request body: {0}", modifiedBody);
                try (OutputStream os2 = conn.getOutputStream();){
                    byte[] input = modifiedBody.getBytes(StandardCharsets.UTF_8);
                    os2.write(input, 0, input.length);
                }
            }
            is = req.getInputStream();
            try {
                os = conn.getOutputStream();
                try {
                    int bytesRead;
                    buffer = new byte[8192];
                    while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        int responseCode = conn.getResponseCode();
        rsp.setStatus(responseCode);
        LOGGER.log(Level.FINE, "Backend response code: {0}", responseCode);
        conn.getHeaderFields().forEach((key, values) -> {
            if (key != null && values != null) {
                for (String value : values) {
                    rsp.addHeader(key, value);
                }
            }
        });
        is = responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream();
        try {
            os = rsp.getOutputStream();
            try {
                if (is != null) {
                    int bytesRead;
                    buffer = new byte[8192];
                    while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    @Extension
    public static class ChatbotCrumbExclusion
    extends CrumbExclusion {
        public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
            String pathInfo = request.getPathInfo();
            if (pathInfo != null && pathInfo.startsWith("/chatbot/")) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            return false;
        }
    }
}

