/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.chatbot;

import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.User;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.GET;

@Extension
public class ChatbotRootAction
implements RootAction {
    private static final String PYTHON_BACKEND_URL = "http://localhost:8000/api/chatbot";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "chatbot";
    }

    public void doDynamic(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.checkPermissions();
        String path = req.getRestOfPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.contains("..")) {
            rsp.sendError(400, "Invalid path");
            return;
        }
        if ((path.equals("sessions") || path.equals("sessions/")) && "POST".equalsIgnoreCase(req.getMethod())) {
            this.handleCreateSession(req, rsp);
            return;
        }
        String targetUrl = "http://localhost:8000/api/chatbot/" + path;
        String method = req.getMethod();
        if ("POST".equalsIgnoreCase(method)) {
            this.proxyStreamRequest(req, rsp, targetUrl);
        } else if ("GET".equalsIgnoreCase(method)) {
            this.proxyGetRequest(rsp, targetUrl);
        } else if ("DELETE".equalsIgnoreCase(method)) {
            this.proxyDeleteRequest(rsp, targetUrl);
        } else {
            rsp.sendError(405, "Method Not Allowed");
        }
    }

    private void handleCreateSession(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        User user = User.current();
        String userId = user != null ? user.getId() : "anonymous";
        JSONObject jsonPayload = new JSONObject();
        jsonPayload.put("user_id", (Object)userId);
        String targetUrl = "http://localhost:8000/api/chatbot/sessions";
        this.proxyJsonRequest(rsp, targetUrl, jsonPayload.toString());
    }

    @GET
    public void doWhoAmI(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        User user = User.current();
        String userId = user != null ? user.getId() : "anonymous";
        String fullName = user != null ? user.getFullName() : "N/A";
        boolean isAdmin = Jenkins.get().hasPermission(Jenkins.ADMINISTER);
        JSONObject json = new JSONObject();
        json.put("user_id", (Object)userId);
        json.put("full_name", (Object)fullName);
        json.put("is_admin", (Object)isAdmin);
        json.put("jenkins_url", (Object)Jenkins.get().getRootUrl());
        rsp.setContentType("application/json");
        rsp.getWriter().write(json.toString());
    }

    private void checkPermissions() {
        Jenkins.get().checkPermission(Jenkins.READ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyJsonRequest(StaplerResponse2 rsp, String targetUrl, String jsonBody) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL url = URI.create(targetUrl).toURL();
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            try (OutputStream out = conn.getOutputStream();){
                out.write(jsonBody.getBytes(StandardCharsets.UTF_8));
            }
            this.copyBackendResponse(conn, rsp);
        }
        catch (Exception e) {
            this.handleProxyError(rsp, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyStreamRequest(StaplerRequest2 req, StaplerResponse2 rsp, String targetUrl) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL url = URI.create(targetUrl).toURL();
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(req.getMethod());
            conn.setRequestProperty("Content-Type", req.getContentType());
            conn.setDoOutput(true);
            IOUtils.copy((InputStream)req.getInputStream(), (OutputStream)conn.getOutputStream());
            this.copyBackendResponse(conn, rsp);
        }
        catch (Exception e) {
            this.handleProxyError(rsp, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyGetRequest(StaplerResponse2 rsp, String targetUrl) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL url = URI.create(targetUrl).toURL();
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            this.copyBackendResponse(conn, rsp);
        }
        catch (Exception e) {
            this.handleProxyError(rsp, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyDeleteRequest(StaplerResponse2 rsp, String targetUrl) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL url = URI.create(targetUrl).toURL();
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("DELETE");
            this.copyBackendResponse(conn, rsp);
        }
        catch (Exception e) {
            this.handleProxyError(rsp, e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void copyBackendResponse(HttpURLConnection conn, StaplerResponse2 rsp) throws IOException {
        InputStream backendStream;
        int status = conn.getResponseCode();
        rsp.setStatus(status);
        rsp.setContentType(conn.getContentType());
        InputStream inputStream = backendStream = status >= 400 ? conn.getErrorStream() : conn.getInputStream();
        if (backendStream != null) {
            IOUtils.copy((InputStream)backendStream, (OutputStream)rsp.getOutputStream());
        }
    }

    private void handleProxyError(StaplerResponse2 rsp, Exception e) throws IOException {
        e.printStackTrace();
        rsp.sendError(500, "Chatbot Proxy Error: " + e.getMessage());
    }
}

