/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.genericdiff;

import hudson.model.AbstractBuild;
import io.jenkins.plugins.report.genericdiff.Constants;
import io.jenkins.plugins.report.genericdiff.RpmsReportOneRecord;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RpmsReportActionOneSummary {
    private final String stderr;
    private final List<String> newRpms;
    private final List<String> removedRpms;
    private final List<String> allRpms;
    private final RpmsReportOneRecord publisher;
    private final AbstractBuild<?, ?> build;

    public RpmsReportActionOneSummary(AbstractBuild<?, ?> build, RpmsReportOneRecord publisher) {
        this.publisher = publisher;
        this.build = build;
        this.newRpms = this.readFile(Constants.getNEW(this.getID()));
        this.removedRpms = this.readFile(Constants.getREMOVED(this.getID()));
        this.allRpms = this.readFile(Constants.getALL(this.getID()));
        List<String> lstderrs = this.readFile(Constants.getCOMMAND_STDERR(this.getID()));
        this.stderr = lstderrs == null ? null : (String)lstderrs.stream().findFirst().orElse(null);
    }

    private RpmsReportOneRecord getPublisher() {
        return this.publisher;
    }

    public String getDisplayName() {
        return this.getPublisher().getMaintitle();
    }

    public String getNoChanges() {
        return this.getPublisher().getNochanges();
    }

    public String getChanged() {
        return this.getPublisher().getUpdatedlines();
    }

    public String getAdded() {
        return this.getPublisher().getAddedlines();
    }

    public String getRemoved() {
        return this.getPublisher().getRemovedlines();
    }

    public String getID() {
        return this.getPublisher().getId();
    }

    private List<String> readFile(String fileName) {
        File file = new File(this.build.getRootDir(), fileName);
        if (file.exists() && file.isFile() && file.canRead()) {
            List<String> list;
            block9: {
                Stream<String> stream = Files.lines(file.toPath(), StandardCharsets.UTF_8);
                try {
                    list = stream.collect(Collectors.toList());
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                stream.close();
            }
            return list;
        }
        return null;
    }

    public String getStderr() {
        return this.stderr;
    }

    public List<String> getNewRpms() {
        return this.newRpms;
    }

    public List<String> getRemovedRpms() {
        return this.removedRpms;
    }

    public List<String> getAllRpms() {
        return this.allRpms;
    }

    public int getNewRpmsSize() {
        return this.newRpms == null ? -1 : this.newRpms.size();
    }

    public int getRemovedRpmsSize() {
        return this.removedRpms == null ? -1 : this.removedRpms.size();
    }

    public int getAllRpmsSize() {
        return this.allRpms == null ? -1 : this.allRpms.size();
    }
}

