/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger.utils;

import java.util.List;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;

public class SourceMap {
    private static final ConversionService conversionService = new DefaultConversionService();
    private final Map<String, Object> source;

    public SourceMap(Map<String, Object> source) {
        this.source = source;
    }

    public static SourceMap of(Map<String, Object> source) {
        return new SourceMap(source);
    }

    public <T> T value(String key, Class<T> type) {
        Object value = this.source.get(key);
        if (value != null) {
            if (type.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            if (conversionService.canConvert(value.getClass(), type)) {
                return (T)conversionService.convert(value, type);
            }
            return (T)value;
        }
        return null;
    }

    public Boolean booleanValue(String key) {
        return this.value(key, Boolean.class);
    }

    public Byte byteValue(String key) {
        return this.value(key, Byte.class);
    }

    public Short shortValue(String key) {
        return this.value(key, Short.class);
    }

    public Integer integerValue(String key) {
        return this.value(key, Integer.class);
    }

    public Float floatValue(String key) {
        return this.value(key, Float.class);
    }

    public Double doubleValue(String key) {
        return this.value(key, Double.class);
    }

    public String stringValue(String key) {
        return this.value(key, String.class);
    }

    public Map<String, Object> mapValue(String key) {
        return this.value(key, Map.class);
    }

    public List<Object> listValue(String key) {
        return this.value(key, List.class);
    }

    public <T> List<T> listValue(String key, Class<T> elementClass) {
        TypeDescriptor target;
        TypeDescriptor source;
        Object value = this.source.get(key);
        if (value != null && conversionService.canConvert(source = TypeDescriptor.forObject((Object)value), target = TypeDescriptor.collection(List.class, (TypeDescriptor)TypeDescriptor.valueOf(elementClass)))) {
            return (List)conversionService.convert(value, source, target);
        }
        return null;
    }

    public SourceMap sourceMap(String key) {
        Map<String, Object> value = this.mapValue(key);
        if (value != null) {
            return SourceMap.of(value);
        }
        return null;
    }

    public Map<String, Object> getSource() {
        return this.source;
    }

    public boolean containsKey(String key) {
        return this.source.containsKey(key);
    }
}

