/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch.extended.scm;

import hudson.model.TaskListener;
import java.io.IOException;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMSourceCriteria;
import org.apache.commons.lang.StringUtils;

public class LocalMarkerSCMSourceCriteria {
    public static boolean matches(String localMarker, SCMSourceCriteria.Probe probe, TaskListener taskListener) throws IOException {
        if (StringUtils.isEmpty((String)localMarker)) {
            taskListener.getLogger().println("No local file defined. Skipping Source Code SCM probe, since Jenkinsfile will be provided by Remote Jenkins File Plugin");
            return true;
        }
        SCMProbeStat stat = probe.stat(localMarker);
        return switch (stat.getType()) {
            case SCMFile.Type.NONEXISTENT -> {
                if (stat.getAlternativePath() != null) {
                    taskListener.getLogger().format("      \u2018%s\u2019 not found (but found \u2018%s\u2019, search is case sensitive)%n", localMarker, stat.getAlternativePath());
                } else {
                    taskListener.getLogger().format("      \u2018%s\u2019 not found%n", localMarker);
                }
                yield false;
            }
            case SCMFile.Type.DIRECTORY -> {
                taskListener.getLogger().format("      \u2018%s\u2019 found directory%n", localMarker);
                yield true;
            }
            default -> {
                taskListener.getLogger().format("      \u2018%s\u2019 found%n", localMarker);
                yield true;
            }
        };
    }
}

