/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch.extended.scm;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.util.DescribableList;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import jenkins.branch.OrganizationFolder;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.extended.scm.ExtendedSCMBinder;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExcludeFromChangeSet
extends GitSCMExtension {
    @DataBoundConstructor
    public ExcludeFromChangeSet() {
    }

    @Extension
    public static class HideMe
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, @NonNull Descriptor descriptor) {
            if (descriptor instanceof DescriptorImpl) {
                if (context instanceof WorkflowMultiBranchProject) {
                    return true;
                }
                return context instanceof OrganizationFolder;
            }
            return true;
        }
    }

    @Extension
    public static class ScmListener
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) throws Exception {
            GitSCM remoteJenkinsFileSCM;
            if (!(build instanceof WorkflowRun)) {
                return;
            }
            WorkflowRun workflowRun = (WorkflowRun)build;
            WorkflowJob workflowJob = (WorkflowJob)workflowRun.getParent();
            FlowDefinition flowDefinition = workflowJob.getDefinition();
            if (!(flowDefinition instanceof ExtendedSCMBinder)) {
                return;
            }
            ExtendedSCMBinder extendedSCMBinder = (ExtendedSCMBinder)flowDefinition;
            SCM sCM = extendedSCMBinder.getRemoteJenkinsFileSCM();
            if (sCM instanceof GitSCM && (remoteJenkinsFileSCM = (GitSCM)sCM).getKey().equals(scm.getKey())) {
                DescribableList extensions = remoteJenkinsFileSCM.getExtensions();
                for (GitSCMExtension gitSCMExtension : extensions) {
                    if (!(gitSCMExtension instanceof ExcludeFromChangeSet) || changelogFile == null) continue;
                    FileUtils.write((File)changelogFile, (CharSequence)"", (Charset)StandardCharsets.UTF_8);
                    workflowRun.getChangeSets().clear();
                }
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Exclude From ChangeSet";
        }
    }
}

