/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch.extended;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import java.io.IOException;
import java.util.StringJoiner;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.extended.scm.ExtendedSCMBinder;

@Extension
public class RemoteJenkinsFileItemListener
extends EnvironmentContributor {
    public static final String RJPP_SCM_ENV_NAME = "RJPP_SCM_URL";
    public static final String RJPP_JFILE_ENV_NAME = "RJPP_JENKINSFILE";
    public static final String RJPP_BRANCH_ENV_NAME = "RJPP_BRANCH";
    public static final String RJPP_LOCAL_MARKER_ENV_NAME = "RJPP_LOCAL_MARKER";

    public void buildEnvironmentFor(@NonNull Run r, @NonNull EnvVars envs, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ExtendedSCMBinder extendedSCMBinder;
        SCM sCM;
        WorkflowRun workflowRun;
        WorkflowJob workflowJob;
        FlowDefinition flowDefinition;
        if (r instanceof WorkflowRun && (flowDefinition = (workflowJob = (WorkflowJob)(workflowRun = (WorkflowRun)r).getParent()).getDefinition()) instanceof ExtendedSCMBinder && (sCM = (extendedSCMBinder = (ExtendedSCMBinder)flowDefinition).getRemoteJenkinsFileSCM()) instanceof GitSCM) {
            GitSCM gitSCM = (GitSCM)sCM;
            StringJoiner scmUrls = new StringJoiner(",");
            for (RemoteConfig remoteConfig : gitSCM.getRepositories()) {
                for (URIish urIish : remoteConfig.getURIs()) {
                    scmUrls.add(urIish.toString());
                }
            }
            String jenkinsFile = extendedSCMBinder.getRemoteJenkinsFile();
            envs.put(RJPP_SCM_ENV_NAME, scmUrls.toString());
            envs.put(RJPP_JFILE_ENV_NAME, jenkinsFile);
            envs.put(RJPP_LOCAL_MARKER_ENV_NAME, extendedSCMBinder.getLocalMarker());
            if (extendedSCMBinder.isMatchBranches()) {
                envs.put(RJPP_BRANCH_ENV_NAME, extendedSCMBinder.getRemoteJenkinsFileBranch());
            } else {
                envs.put(RJPP_BRANCH_ENV_NAME, ((BranchSpec)gitSCM.getBranches().get(0)).getName());
            }
        }
        super.buildEnvironmentFor(r, envs, listener);
    }
}

