/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.actions;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import io.jenkins.plugins.actions.Config;
import io.jenkins.plugins.actions.ScanResultAction;
import io.jenkins.plugins.commons.JenkinsUtil;
import io.jenkins.plugins.commons.model.FailedStats;
import io.jenkins.plugins.commons.model.QualysBuildConfiguration;
import io.jenkins.plugins.commons.model.ScanResult;
import io.jenkins.plugins.commons.model.Util;
import io.jenkins.plugins.commons.service.impl.QualysServiceImpl;
import io.jenkins.plugins.jenkins.dto.QualysApiConfiguration;
import io.jenkins.plugins.validation.UIJenkinsValidation;
import io.jenkins.plugins.validation.UIValidation;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class TemplateScanBuilder
extends Builder
implements SimpleBuildStep {
    private String IaCServiceEndpoint;
    private String scanName;
    private String scanDirectories;
    @DataBoundSetter
    private boolean isFailedResultsOnly;
    @DataBoundSetter
    private boolean buildFailureSettings;
    private String high;
    private String medium;
    private String low;
    @DataBoundSetter
    private boolean timeoutSettings;
    private String scanResultInterval;
    private String totalJobCompletionTime;
    private String jobName;
    private static final String FINAL_STATUS = "FINISHED";
    private static final String ERROR_STATUS = "ERROR";
    private final Util util = Util.getInstance();
    private final UIValidation uIValidation = new UIJenkinsValidation();

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundConstructor
    public TemplateScanBuilder(String IaCServiceEndpoint, String scanName, String scanDirectories, boolean isFailedResultsOnly, boolean buildFailureSettings, String high, String medium, String low, boolean timeoutSettings, String scanResultInterval, String totalJobCompletionTime, String jobName) {
        this.IaCServiceEndpoint = IaCServiceEndpoint;
        this.scanName = this.uIValidation.validateScanName(scanName).isValid() ? scanName : "";
        this.scanDirectories = this.uIValidation.validateFolderPaths(scanDirectories, Jenkins.get().getRootDir().getPath() + File.separator + "workspace" + File.separator + jobName).isValid() ? scanDirectories.replaceAll("\\.{2,}", "").replaceAll("[\\/]+", "/").replaceAll("[\\\\]+", "\\\\") : "";
        this.isFailedResultsOnly = isFailedResultsOnly;
        this.buildFailureSettings = buildFailureSettings;
        this.high = this.uIValidation.validateNumber(high, 0, Integer.MAX_VALUE).isValid() ? high : "0";
        this.medium = this.uIValidation.validateNumber(medium, 0, Integer.MAX_VALUE).isValid() ? medium : "0";
        this.low = this.uIValidation.validateNumber(low, 0, Integer.MAX_VALUE).isValid() ? low : "0";
        this.timeoutSettings = timeoutSettings;
        this.scanResultInterval = this.uIValidation.validateNumber(scanResultInterval, 10, Integer.MAX_VALUE).isValid() ? scanResultInterval : "30";
        this.totalJobCompletionTime = this.uIValidation.validateNumber(totalJobCompletionTime, 10, Integer.MAX_VALUE).isValid() ? totalJobCompletionTime : "10";
    }

    public TemplateScanBuilder() {
    }

    public boolean getFailedResultsOnly() {
        return this.isFailedResultsOnly;
    }

    public String getFormattedScanName() {
        if (StringUtils.isEmpty((CharSequence)this.scanName.trim())) {
            return "jenkins_" + this.getSelectedIaCServiceEndpoint().getQualysUserName() + "_" + Instant.now().getEpochSecond();
        }
        return this.scanName;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public QualysApiConfiguration getSelectedIaCServiceEndpoint() {
        for (QualysApiConfiguration qac : this.getDescriptor().getIaCServiceEndpoints()) {
            if (this.getIaCServiceEndpoint() == null || !this.getIaCServiceEndpoint().equals(qac.getName())) continue;
            return qac;
        }
        if (this.getDescriptor().getIaCServiceEndpoints().length > 0) {
            return this.getDescriptor().getIaCServiceEndpoints()[0];
        }
        return null;
    }

    @SuppressFBWarnings(value={"DM_EXIT", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE", "DLS_DEAD_LOCAL_STORE", "DM_STRING_VOID_CTOR"})
    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) {
        block17: {
            listener.getLogger().println("Qualys IaC Scan Started");
            QualysApiConfiguration qac = this.getSelectedIaCServiceEndpoint();
            listener.getLogger().println("Configuration name : " + qac.getName());
            listener.getLogger().println("Qualys Platform URL : " + qac.getQualysPlatformURL());
            listener.getLogger().println("Qualys Username : " + qac.getQualysUserName());
            listener.getLogger().println("Scan Name : " + this.getFormattedScanName());
            listener.getLogger().println("Directory Path : " + this.getScanDirectories());
            listener.getLogger().println("Failed Results only : " + this.getFailedResultsOnly());
            listener.getLogger().println(MessageFormat.format("Build Failure Conditions High={0}, Medium={1}, Low={2}", this.getHigh(), this.getMedium(), this.getLow()));
            listener.getLogger().println(MessageFormat.format("Timeout settings scanResultInterval={0}, jobCompletionTotalTime={1}", this.getScanResultInterval(), this.getTotalJobCompletionTime()));
            QualysServiceImpl iQualysService = new QualysServiceImpl();
            QualysBuildConfiguration qbc = new QualysBuildConfiguration(qac.getQualysPlatformURL(), qac.getAuthType(), qac.getQualysUserName(), qac.getQualysPassword().getPlainText(), this.getFailedResultsOnly(), StringUtils.isEmpty((CharSequence)this.getScanName()) ? this.getFormattedScanName() : this.getScanName(), this.getScanDirectories());
            Util util = Util.getInstance();
            String DEFAULT_WORKSPACE_DIR = util.concatPath(util.concatPath(Jenkins.get().getRootDir().getPath() + File.separator + "workspace", workspace.getName()), "");
            listener.getLogger().println(MessageFormat.format("Workspace directory : {0}", DEFAULT_WORKSPACE_DIR));
            if (qbc.isCredentialsBlank()) {
                throw new AbortException("Unable to launch Qualys IaC Scan due to platform  url, username or password is blank.");
            }
            if (!iQualysService.isUserAuthenticated(qbc)) {
                throw new AbortException("Unable to launch Qualys IaC Scan due to invalid platform  url, username or password.");
            }
            if (StringUtils.isBlank((CharSequence)this.getScanDirectories())) {
                throw new AbortException("Unable to launch Qualys IaC Scan due to scan directories are blank.");
            }
            Map<String, Object> map = iQualysService.postZip(DEFAULT_WORKSPACE_DIR, qbc);
            if (map.get("http_post_failed") != null && !Boolean.parseBoolean(map.get("http_post_failed").toString())) {
                boolean isBuildFailed;
                block18: {
                    Instant end;
                    long durationInMinutes;
                    String scanUuid = map.get("scanUuid").toString();
                    listener.getLogger().println("Qualys IaC Scan ID : " + scanUuid);
                    if (StringUtils.isEmpty((CharSequence)scanUuid)) break block17;
                    isBuildFailed = false;
                    Instant start = Instant.now();
                    do {
                        try {
                            String scanStatus = iQualysService.getScanStatus(scanUuid, qbc);
                            if (StringUtils.isNotEmpty((CharSequence)scanStatus)) {
                                listener.getLogger().println(MessageFormat.format("Qualys scan status : {0}", scanStatus));
                                if (scanStatus.equalsIgnoreCase(FINAL_STATUS)) {
                                    try {
                                        FailedStats failedStatsFromBuildConfiguration = new FailedStats(this.getHigh(), this.getMedium(), this.getLow());
                                        String scanResult = iQualysService.getScanResult(scanUuid, qbc);
                                        String fileName = "ScanResult" + File.separator + ((String)env.get((Object)"BUILD_NUMBER")).toString() + File.separator + "Qualys_IaC_Scan_Reponse_" + ((String)env.get((Object)"BUILD_NUMBER")).toString() + ".json";
                                        String filePath = DEFAULT_WORKSPACE_DIR + fileName;
                                        FileUtils.writeStringToFile((File)new File(filePath), (String)scanResult, (Charset)Charset.forName("UTF-8"));
                                        listener.getLogger().println("Qualys IaC Scan Json Response saved  at location : " + filePath);
                                        ScanResult scanResultObj = iQualysService.mapScanResult(scanResult, failedStatsFromBuildConfiguration);
                                        if (scanResultObj.getSummary() != null) {
                                            scanResultObj.setScanId(scanUuid);
                                            scanResultObj.setScanName(qbc.getScanName());
                                            scanResultObj.setFailedResultsOnly(this.getFailedResultsOnly());
                                            scanResultObj.setAppliedBuildSetting(this.isBuildFailureSettings());
                                            scanResultObj.setQualysJsonResponse(scanResult);
                                            scanResultObj.setScanStatus(scanStatus);
                                            run.addAction((Action)new ScanResultAction(listener, scanResultObj));
                                            if (this.isBuildFailureSettings()) {
                                                FailedStats scanResultFailedStats = scanResultObj.getSummary().getFailedStats();
                                                isBuildFailed = iQualysService.checkBuildFailed(scanResultFailedStats, failedStatsFromBuildConfiguration);
                                                listener.getLogger().println(MessageFormat.format("Scan result failed stats High={0}, Medium={1}, Low={2}", scanResultFailedStats.getHigh(), scanResultFailedStats.getMedium(), scanResultFailedStats.getLow()));
                                            }
                                            listener.getLogger().println("Qualys IaC scan result mapping ended and IaC scan report generated.");
                                            break block18;
                                        }
                                        listener.getLogger().println("The scan is FINISHED, but the scan result is empty. Check the scan configuration files.");
                                    }
                                    catch (IOException | URISyntaxException ex) {
                                        Logger.getLogger(TemplateScanBuilder.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                    break block18;
                                }
                                if (scanStatus.equalsIgnoreCase(ERROR_STATUS)) {
                                    throw new AbortException("Getting error after IaC scan");
                                }
                            }
                            Thread.sleep(1000 * Integer.parseInt(this.getScanResultInterval()));
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(TemplateScanBuilder.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } while ((durationInMinutes = Duration.between(start, end = Instant.now()).toMinutes()) <= (long)Integer.parseInt(this.getTotalJobCompletionTime()));
                    throw new AbortException("Qualys IaC scan taking more than " + this.getTotalJobCompletionTime() + " minutes, so ignoring IaC Scan report.");
                }
                if (isBuildFailed) {
                    throw new AbortException("After comparing build failure settings IaC scan result causing build failure.");
                }
                break block17;
            }
            listener.getLogger().println(map.get("http_post_failed_reason").toString());
            throw new AbortException("Unable to post files for IaC Scan.");
        }
    }

    public void setIaCServiceEndpoint(String IaCServiceEndpoint) {
        this.IaCServiceEndpoint = IaCServiceEndpoint;
    }

    public String getIaCServiceEndpoint() {
        return this.IaCServiceEndpoint;
    }

    public void setScanName(String scanName) {
        this.scanName = scanName;
    }

    public String getScanName() {
        return this.scanName;
    }

    public void setScanDirectories(String scanDirectories) {
        this.scanDirectories = scanDirectories;
    }

    public String getScanDirectories() {
        return this.scanDirectories;
    }

    public void setFailedResultsOnly(boolean isFailedResultsOnly) {
        this.isFailedResultsOnly = isFailedResultsOnly;
    }

    public void setBuildFailureSettings(boolean buildFailureSettings) {
        this.buildFailureSettings = buildFailureSettings;
    }

    public boolean isBuildFailureSettings() {
        return this.buildFailureSettings;
    }

    public void setHigh(String high) {
        this.high = high;
    }

    public String getHigh() {
        return this.high;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public String getMedium() {
        return this.medium;
    }

    public void setLow(String low) {
        this.low = low;
    }

    public String getLow() {
        return this.low;
    }

    public void setTimeoutSettings(boolean timeoutSettings) {
        this.timeoutSettings = timeoutSettings;
    }

    public boolean isTimeoutSettings() {
        return this.timeoutSettings;
    }

    public void setScanResultInterval(String scanResultInterval) {
        this.scanResultInterval = scanResultInterval;
    }

    public String getScanResultInterval() {
        return this.scanResultInterval;
    }

    public void setTotalJobCompletionTime(String totalJobCompletionTime) {
        this.totalJobCompletionTime = totalJobCompletionTime;
    }

    public String getTotalJobCompletionTime() {
        return this.totalJobCompletionTime;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private final UIValidation uIValidation = new UIJenkinsValidation();

        public String getUUID() {
            return UUID.randomUUID().toString();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Qualys IaC Scan";
        }

        public QualysApiConfiguration[] getIaCServiceEndpoints() {
            Config config;
            if (GlobalConfiguration.all() != null && (config = (Config)((Object)GlobalConfiguration.all().get(Config.class))) != null) {
                return config.getQualysApiConfigurations();
            }
            QualysApiConfiguration[] qualysApiConfigurations = new QualysApiConfiguration[1];
            return qualysApiConfigurations;
        }

        public FormValidation doCheckIaCServiceEndpoint(@QueryParameter String IaCServiceEndpoint, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateIaCServiceEndpoint(IaCServiceEndpoint, "-1"), isPageLoad);
        }

        public FormValidation doCheckScanName(@QueryParameter String scanName, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateScanName(scanName), isPageLoad);
        }

        public FormValidation doCheckScanDirectories(@AncestorInPath Job job, @QueryParameter String isPageLoad, @QueryParameter String scanDirectories) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateFolderPaths(scanDirectories, Jenkins.get().getRootDir().getPath() + File.separator + "workspace" + File.separator + job.getDisplayName()), isPageLoad);
        }

        public FormValidation doCheckHigh(@QueryParameter String high, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateNumber(high, 0, Integer.MAX_VALUE), isPageLoad);
        }

        public FormValidation doCheckMedium(@QueryParameter String medium, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateNumber(medium, 0, Integer.MAX_VALUE), isPageLoad);
        }

        public FormValidation doCheckLow(@QueryParameter String low, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateNumber(low, 0, Integer.MAX_VALUE), isPageLoad);
        }

        public FormValidation doCheckScanResultInterval(@QueryParameter String scanResultInterval, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateNumber(scanResultInterval, 10, Integer.MAX_VALUE), isPageLoad);
        }

        public FormValidation doCheckTotalJobCompletionTime(@QueryParameter String totalJobCompletionTime, @QueryParameter String isPageLoad) {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validateNumber(totalJobCompletionTime, 10, Integer.MAX_VALUE), isPageLoad);
        }
    }
}

