/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.commons.service.impl;

import io.jenkins.plugins.commons.model.Checks;
import io.jenkins.plugins.commons.model.FailedStats;
import io.jenkins.plugins.commons.model.ParsingError;
import io.jenkins.plugins.commons.model.QualysBuildConfiguration;
import io.jenkins.plugins.commons.model.Remediation;
import io.jenkins.plugins.commons.model.ScanResult;
import io.jenkins.plugins.commons.model.Summary;
import io.jenkins.plugins.commons.model.Util;
import io.jenkins.plugins.commons.service.IQualysService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class QualysServiceImpl
implements IQualysService {
    private final Util util = Util.getInstance();

    @Override
    public boolean isUserAuthenticated(QualysBuildConfiguration qbc) {
        try {
            HttpRequest request = this.util.addCommonConfigurationToHttpRequest(qbc).uri(new URI(qbc.getAuthenticationURL())).GET().build();
            HttpResponse<Void> response = this.util.addCommonConfigurationToHttpClient(10L).build().send(request, HttpResponse.BodyHandlers.discarding());
            return response.statusCode() != 401;
        }
        catch (IOException | InterruptedException | URISyntaxException ex) {
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static boolean isValidPath(String folderPath) {
        File file = new File(folderPath);
        return file != null && (file.isDirectory() || file.isFile()) && file.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> postZip(String workspacePath, QualysBuildConfiguration qbc) {
        HttpResponse<String> response = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<String> lstDirs = qbc.getFormattedDirectories();
        ArrayList<Path> lstPaths = new ArrayList<Path>();
        HashSet<String> lstEntries = new HashSet<String>();
        ArrayList<String> lstfiles = new ArrayList<String>();
        try {
            for (int i = 0; i < lstDirs.size(); ++i) {
                String folderPath = lstDirs.get(i);
                if (QualysServiceImpl.isValidPath(folderPath)) {
                    if (folderPath.endsWith(".zip")) {
                        String extractFolderPath = this.util.getRandomZipPath();
                        this.util.extractFolder(folderPath, extractFolderPath);
                        lstPaths.add(Paths.get(extractFolderPath, new String[0]));
                        continue;
                    }
                    lstPaths.add(Paths.get(new File(folderPath).getCanonicalPath(), new String[0]));
                    continue;
                }
                if (!QualysServiceImpl.isValidPath(folderPath = this.util.concatPath(workspacePath, folderPath))) continue;
                lstPaths.add(Paths.get(new File(folderPath).getCanonicalPath(), new String[0]));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(baos);){
                for (Path path : lstPaths) {
                    if (path.toFile().isDirectory()) {
                        this.util.addFolderToZip(path.toFile(), zipOutputStream, "", lstEntries, lstfiles);
                        continue;
                    }
                    this.util.addFileToZip(path.toFile(), zipOutputStream, "", lstEntries, lstfiles);
                }
                zipOutputStream.flush();
                zipOutputStream.close();
                baos.close();
                byte[] bytes = baos.toByteArray();
                if (bytes.length == 0 || lstfiles.isEmpty()) {
                    map.put("http_post_failed", true);
                    map.put("http_post_failed_reason", "There are no valid IaC files(.tf,.yml,.yaml,.json,.template) inside IaC scan directories.");
                    HashMap<String, Object> hashMap = map;
                    return hashMap;
                }
                float f = (float)bytes.length / 1048576.0f;
                if (f > 10.0f) {
                    map.put("http_post_failed", true);
                    map.put("http_post_failed_reason", "IaC scan files size exceeding 10 MB.");
                    HashMap<String, Object> hashMap = map;
                    return hashMap;
                }
            }
            HttpEntity httpEntity = MultipartEntityBuilder.create().addTextBody("name", qbc.getScanName()).addTextBody("showOnlyFailedControls", "" + qbc.isFailedResultsOnly()).addBinaryBody("file", (InputStream)new ByteArrayInputStream(baos.toByteArray()), ContentType.APPLICATION_OCTET_STREAM, this.util.appendTimestampToFile("QUALYS", ".zip")).build();
            Pipe pipe = Pipe.open();
            new Thread(() -> {
                try (OutputStream outputStream = Channels.newOutputStream(pipe.sink());){
                    httpEntity.writeTo(outputStream);
                }
                catch (IOException iOException) {
                    Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }).start();
            HttpRequest httpRequest = this.util.addCommonConfigurationToHttpRequest(qbc).uri(new URI(qbc.getPostScanURL())).header("Content-type", httpEntity.getContentType().getValue()).POST(HttpRequest.BodyPublishers.ofInputStream(() -> Channels.newInputStream(pipe.source()))).build();
            response = this.util.addCommonConfigurationToHttpClient(10L).build().send(httpRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            map.put("http_post_failed", false);
        }
        catch (IOException | InterruptedException | URISyntaxException ex) {
            map.put("http_post_failed", true);
            map.put("http_post_failed_reason", ex.toString());
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (Boolean.getBoolean(map.get("http_post_failed").toString())) return map;
        map.put("scanUuid", new JSONObject((String)response.body()).get("scanUuid").toString());
        return map;
    }

    @Override
    public ScanResult mapScanResult(String json, FailedStats failedStatsFromBuildConfiguration) {
        int i;
        Summary summaryObj = null;
        JSONObject jsonObject = new JSONObject(json.trim());
        JSONArray results = jsonObject.getJSONArray("result");
        ArrayList<Checks> lstChecks = new ArrayList<Checks>();
        ArrayList<Remediation> lstRemediation = new ArrayList<Remediation>();
        ArrayList<ParsingError> lstParsingErrors = new ArrayList<ParsingError>();
        ArrayList<JSONArray> lstCheckList = new ArrayList<JSONArray>();
        int totalBuildFailureControlCount = 0;
        int tmpPassed = 0;
        int tmpFailed = 0;
        int tmpHigh = 0;
        int tmpMedium = 0;
        int tmpLow = 0;
        int tmpSkipped = 0;
        int tmpParsingError = 0;
        boolean isLowViolatesCriteria = false;
        boolean isMediumViolatesCriteria = false;
        boolean isHighViolatesCriteria = false;
        for (i = 0; i < results.length(); ++i) {
            JSONObject summary;
            JSONObject failedStats;
            JSONObject tmp = results.getJSONObject(i);
            JSONObject result = tmp.getJSONObject("results");
            JSONArray passedChecks = result.optJSONArray("passedChecks");
            JSONArray failedChecks = result.optJSONArray("failedChecks");
            JSONArray parsingErrors = result.optJSONArray("parsingErrors");
            String checkType = tmp.getString("checkType");
            if (passedChecks != null) {
                lstCheckList.add(passedChecks);
            }
            if (failedChecks != null) {
                lstCheckList.add(failedChecks);
            }
            if (parsingErrors != null) {
                StringBuilder parsingErrorBuilder = new StringBuilder();
                for (int k = 0; k < parsingErrors.length(); ++k) {
                    parsingErrorBuilder.append(parsingErrors.get(k));
                    ParsingError parsingError = new ParsingError(checkType, parsingErrorBuilder.toString());
                    lstParsingErrors.add(parsingError);
                }
            }
            if ((failedStats = (summary = tmp.getJSONObject("summary")).getJSONObject("failedStats")) != null) {
                tmpMedium += failedStats.getInt("medium");
                tmpLow += failedStats.getInt("low");
                if ((tmpHigh += failedStats.getInt("high")) > failedStatsFromBuildConfiguration.getHigh()) {
                    isHighViolatesCriteria = true;
                    totalBuildFailureControlCount += tmpHigh;
                }
                if (tmpMedium > failedStatsFromBuildConfiguration.getMedium()) {
                    isMediumViolatesCriteria = true;
                    totalBuildFailureControlCount += tmpMedium;
                }
                if (tmpLow > failedStatsFromBuildConfiguration.getLow()) {
                    isLowViolatesCriteria = true;
                    totalBuildFailureControlCount += tmpLow;
                }
            }
            tmpPassed += summary.getInt("passed");
            tmpFailed += summary.getInt("failed");
            tmpSkipped += summary.getInt("skipped");
            tmpParsingError += summary.getInt("parsingErrors");
        }
        for (i = 0; i < lstCheckList.size(); ++i) {
            for (int j = 0; j < ((JSONArray)lstCheckList.get(i)).length(); ++j) {
                JSONObject item = ((JSONArray)lstCheckList.get(i)).getJSONObject(j);
                JSONObject checkResult = item.getJSONObject("checkResult");
                String controlId = item.getString("checkId");
                String controlName = item.getString("checkName");
                String criticality = item.getString("criticality");
                String passOrFailResult = checkResult.getString("result");
                String filePath = item.getString("filePath");
                String resource = item.getString("resource");
                if (passOrFailResult.equalsIgnoreCase("FAILED")) {
                    Remediation remediation = new Remediation(controlId, item.getString("remediation"));
                    lstRemediation.add(remediation);
                }
                lstChecks.add(new Checks(controlId, controlName, criticality, passOrFailResult, filePath, resource));
            }
        }
        lstChecks.sort(Comparator.comparing(Checks::getResource).thenComparing(Checks::getControlId));
        summaryObj = new Summary(tmpPassed, tmpFailed, new FailedStats(tmpHigh, tmpMedium, tmpLow), tmpSkipped, tmpParsingError, isHighViolatesCriteria, isMediumViolatesCriteria, isLowViolatesCriteria, totalBuildFailureControlCount);
        return new ScanResult(summaryObj, lstChecks, lstRemediation, lstParsingErrors);
    }

    @Override
    public String getScanStatus(String scanUuid, QualysBuildConfiguration qbc) {
        try {
            HttpRequest request = this.util.addCommonConfigurationToHttpRequest(qbc).uri(new URI(qbc.getScanStatusURL(scanUuid))).GET().build();
            HttpResponse<String> response = this.util.addCommonConfigurationToHttpClient(10L).build().send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            return StringUtils.isEmpty((CharSequence)response.body()) ? null : this.getScanStatus(response.body());
        }
        catch (IOException | InterruptedException | URISyntaxException ex) {
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private String getScanStatus(String body) {
        JSONArray jSONArray = (JSONArray)new JSONObject(body).get("content");
        if (jSONArray.length() > 0) {
            return new JSONObject(jSONArray.get(0).toString()).getString("status");
        }
        return null;
    }

    @Override
    public String getScanResult(String scanUuid, QualysBuildConfiguration qbc) {
        try {
            HttpRequest request = this.util.addCommonConfigurationToHttpRequest(qbc).uri(new URI(qbc.getScanResultURL(scanUuid))).GET().build();
            HttpResponse<String> response = this.util.addCommonConfigurationToHttpClient(10L).build().send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            return StringUtils.isEmpty((CharSequence)response.body()) ? null : response.body();
        }
        catch (IOException | InterruptedException | URISyntaxException ex) {
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public boolean checkBuildFailed(FailedStats failedStatsFromScanResult, FailedStats failedStatsFromBuildConfiguration) {
        if (failedStatsFromScanResult.getHigh() > failedStatsFromBuildConfiguration.getHigh()) {
            return true;
        }
        if (failedStatsFromScanResult.getMedium() > failedStatsFromBuildConfiguration.getMedium()) {
            return true;
        }
        return failedStatsFromScanResult.getLow() > failedStatsFromBuildConfiguration.getLow();
    }
}

