/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.commons.model;

import io.jenkins.plugins.commons.model.QualysBuildConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.time.Instant;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public final class Util {
    private static Util util = null;
    public static final String EMPTY_BASE_PATH = "";

    private Util() {
    }

    public static Util getInstance() {
        if (util == null) {
            util = new Util();
        }
        return util;
    }

    public HttpRequest.Builder addCommonConfigurationToHttpRequest(QualysBuildConfiguration qbc) {
        return HttpRequest.newBuilder().setHeader("Authorization", qbc.getBasicAuthToken()).setHeader("Accept", "application/json");
    }

    public HttpClient.Builder addCommonConfigurationToHttpClient(long connectionTimeout) {
        return HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofMinutes(connectionTimeout));
    }

    public String concatPath(String firstPath, String secondPath) {
        return firstPath.concat(File.separator).concat(secondPath);
    }

    public String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public String appendTimestampToFile(String fileName, String extension) {
        return fileName.concat("_").concat(EMPTY_BASE_PATH + Instant.now().getEpochSecond()).concat(extension);
    }

    public String getRandomZipPath() {
        String uuid = UUID.randomUUID().toString();
        return util.concatPath(this.getTempDirectory(), uuid);
    }

    public void extractFolder(String zipFile, String extractFolderPath) {
        try {
            int BUFFER = 2048;
            File file = new File(zipFile);
            ZipFile zip = new ZipFile(file);
            File extractFolderDir = new File(extractFolderPath);
            boolean isDirectoryCreated = false;
            if (!extractFolderDir.exists()) {
                isDirectoryCreated = extractFolderDir.mkdirs();
            }
            if (isDirectoryCreated) {
                Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
                while (zipFileEntries.hasMoreElements()) {
                    ZipEntry entry = zipFileEntries.nextElement();
                    String currentEntry = entry.getName();
                    String canonicalDestinationDirPath = extractFolderDir.getCanonicalPath();
                    File destFile = new File(extractFolderPath, currentEntry);
                    String canonicalDestinationFile = destFile.getCanonicalPath();
                    if (!canonicalDestinationFile.startsWith(canonicalDestinationDirPath + File.separator)) {
                        throw new ArchiveException("Entry is outside of the target dir: " + entry.getName());
                    }
                    File destinationParent = destFile.getParentFile();
                    boolean isDestinationParentCreated = destinationParent.mkdirs();
                    if (!isDestinationParentCreated || entry.isDirectory()) continue;
                    try (BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));){
                        int currentByte;
                        byte[] data = new byte[BUFFER];
                        FileOutputStream fos = new FileOutputStream(destFile);
                        BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
                        while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                            dest.write(data, 0, currentByte);
                        }
                        dest.flush();
                        dest.close();
                        fos.close();
                        is.close();
                    }
                }
            }
            zip.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ArchiveException e) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public String getRenamedPath(String path, String basePath, File file, Set<String> lstEntries) {
        if (lstEntries.contains(path)) {
            return util.concatPath(basePath.concat(this.appendTimestampToFile(file.getName(), FilenameUtils.getExtension((String)file.getName()))), EMPTY_BASE_PATH);
        }
        return path;
    }

    public void addFileToZip(File file, ZipOutputStream zip, String basePath, Set<String> lstEntries, List<String> lstfiles) {
        try {
            if (Util.isIaCScanFile(file.getName())) {
                Object path = basePath + file.getName();
                path = this.getRenamedPath((String)path, basePath, file, lstEntries);
                lstEntries.add((String)path);
                ZipEntry zipEntry = new ZipEntry((String)path);
                zip.putNextEntry(zipEntry);
                IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)zip);
                zip.closeEntry();
                lstfiles.add(file.getName());
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addFolderToZip(File folder, ZipOutputStream zout, String basePath, Set<String> lstEntries, List<String> lstfiles) throws IOException {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    String path = util.concatPath(basePath.concat(file.getName()), EMPTY_BASE_PATH);
                    path = this.getRenamedPath(path, basePath, file, lstEntries);
                    lstEntries.add(path);
                    zout.putNextEntry(new ZipEntry(path));
                    this.addFolderToZip(file, zout, path, lstEntries, lstfiles);
                    zout.closeEntry();
                    continue;
                }
                this.addFileToZip(file, zout, basePath, lstEntries, lstfiles);
            }
        }
    }

    public static boolean isIaCScanFile(String str) {
        String regex = "([^\\s]+(\\.(?i)(tf|yml|yaml|json|template|TF|YML|YAML|JSON|TEMPLATE))$)";
        Pattern p = Pattern.compile(regex);
        if (str == null) {
            return false;
        }
        Matcher m = p.matcher(str);
        return m.matches();
    }
}

