/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.commons.model.ScanResult;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.UUID;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ScanResultAction
implements RunAction2 {
    private transient Run run;
    @DataBoundSetter
    public ScanResult scanResult;

    public ScanResult getScanResultObj() {
        return this.scanResult;
    }

    public String getScanResult() throws JsonProcessingException {
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        return ow.writeValueAsString((Object)this.scanResult);
    }

    @DataBoundConstructor
    @SuppressFBWarnings(value={"UC_USELESS_OBJECT"})
    public ScanResultAction(TaskListener listener, ScanResult scanResult) throws IOException, URISyntaxException {
        this.scanResult = scanResult;
        if (listener != null) {
            listener.getLogger().println("Qualys IaC Scan : Executing Scan Result Action for Jenkins Job");
        }
    }

    public String getIconFileName() {
        return "/plugin/qualys-iac-security/icons/qualyscloud-48x48.png";
    }

    public String getDisplayName() {
        return "Qualys IaC Scan Report";
    }

    public String getUrlName() {
        return "iac_scan_result";
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public Run getRun() {
        return this.run;
    }

    public String getUUID() {
        return UUID.randomUUID().toString();
    }

    public void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
    }
}

