/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.actions;

import hudson.Extension;
import hudson.util.FormValidation;
import io.jenkins.plugins.commons.JenkinsUtil;
import io.jenkins.plugins.commons.model.QualysBuildConfiguration;
import io.jenkins.plugins.commons.service.impl.QualysServiceImpl;
import io.jenkins.plugins.jenkins.dto.QualysApiConfiguration;
import io.jenkins.plugins.validation.UIJenkinsValidation;
import io.jenkins.plugins.validation.UIValidation;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
public class Config
extends GlobalConfiguration {
    private final UIValidation uIValidation = new UIJenkinsValidation();
    private final transient Supplier<Jenkins> supplyJenkins;
    private volatile QualysApiConfiguration[] qualysApiConfigurations;

    public Config() {
        this(() -> Optional.ofNullable(Jenkins.getInstanceOrNull()).orElseThrow(() -> new IllegalStateException("Could not get Jenkins instance")));
    }

    public Config(Supplier<Jenkins> supplyJenkins) {
        this.load();
        this.supplyJenkins = supplyJenkins;
    }

    public static Config get() {
        return (Config)((Object)GlobalConfiguration.all().get(Config.class));
    }

    public QualysApiConfiguration[] getQualysApiConfigurations() {
        if (this.qualysApiConfigurations != null && this.qualysApiConfigurations.length > 0) {
            return (QualysApiConfiguration[])this.qualysApiConfigurations.clone();
        }
        return (QualysApiConfiguration[])ArrayUtils.toArray((Object[])new QualysApiConfiguration[0]);
    }

    public void setQualysApiConfigurations(List<QualysApiConfiguration> qac) {
        ArrayList<QualysApiConfiguration> tmp = new ArrayList<QualysApiConfiguration>();
        int counter = 0;
        for (int i = 0; i < qac.size(); ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)qac.get(i).getName())) continue;
            tmp.add(qac.get(i));
            ++counter;
        }
        this.qualysApiConfigurations = counter > 0 ? (QualysApiConfiguration[])tmp.stream().toArray(QualysApiConfiguration[]::new) : null;
        this.save();
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        List list = req.bindJSONToList(QualysApiConfiguration.class, json.get("inst"));
        this.setQualysApiConfigurations(list);
        return true;
    }

    public FormValidation doCheckName(@QueryParameter String isPageLoad, @QueryParameter String name) {
        return JenkinsUtil.showErrorIfExists(this.uIValidation.validateConfigName(name), isPageLoad);
    }

    public FormValidation doCheckQualysUserName(@QueryParameter String isPageLoad, @QueryParameter String qualysUserName) {
        return JenkinsUtil.showErrorIfExists(this.uIValidation.validateUserName(qualysUserName), isPageLoad);
    }

    public FormValidation doCheckQualysPassword(@QueryParameter String isPageLoad, @QueryParameter String qualysPassword) {
        return JenkinsUtil.showErrorIfExists(this.uIValidation.validatePassword(qualysPassword), isPageLoad);
    }

    public FormValidation doCheckQualysPlatformURL(@QueryParameter String isPageLoad, @QueryParameter String qualysPlatformURL) {
        try {
            return JenkinsUtil.showErrorIfExists(this.uIValidation.validatePlatformURL(qualysPlatformURL), isPageLoad);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Config.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Config.class.getName()).log(Level.SEVERE, null, ex);
        }
        return FormValidation.ok();
    }

    @POST
    public FormValidation doTestConnection(@QueryParameter(value="qualysPlatformURL") String qualysPlatformURL, @QueryParameter(value="qualysUserName") String qualysUserName, @QueryParameter(value="qualysPassword") String qualysPassword) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            if (StringUtils.isEmpty((CharSequence)qualysPlatformURL) || StringUtils.isEmpty((CharSequence)qualysUserName) || StringUtils.isEmpty((CharSequence)qualysPassword)) {
                return FormValidation.error((String)"PlatformURL, Username and Password are required fields.");
            }
            QualysServiceImpl qualysService = new QualysServiceImpl();
            QualysBuildConfiguration qbc = new QualysBuildConfiguration(qualysPlatformURL, qualysUserName, qualysPassword);
            if (!qualysService.isUserAuthenticated(qbc)) {
                return FormValidation.error((String)"Unable to authenticate user");
            }
        }
        catch (Exception e) {
            return FormValidation.error((String)("Client error: " + e.getMessage()));
        }
        return FormValidation.ok((String)"Successfully authenticated user with server");
    }

    private String getPluginVersion() {
        return this.getPlugin().getVersion();
    }

    public String getUUID() {
        return UUID.randomUUID().toString();
    }
}

