/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.util.FormValidation;
import io.jenkins.plugins.prism.PrismConfiguration;
import java.io.IOException;

class SourceDirectoryValidation {
    static final String DIRECTORY_NOT_REGISTERED = "This source directory is not approved yet. Please register this directory in Jenkins' global configuration.";
    private final SourceDirectoryValidator sourceDirectoryValidator;

    SourceDirectoryValidation() {
        this(new SourceDirectoryValidator());
    }

    @VisibleForTesting
    SourceDirectoryValidation(SourceDirectoryValidator sourceDirectoryValidator) {
        this.sourceDirectoryValidator = sourceDirectoryValidator;
    }

    FormValidation validateSourceDirectory(@CheckForNull AbstractProject<?, ?> project, String sourceDirectory) {
        PathUtil pathUtil = new PathUtil();
        if (pathUtil.isAbsolute(sourceDirectory)) {
            if (this.sourceDirectoryValidator.isAllowedSourceDirectory(sourceDirectory)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)DIRECTORY_NOT_REGISTERED);
        }
        if (project != null) {
            try {
                FilePath workspace = project.getSomeWorkspace();
                if (workspace != null && workspace.exists()) {
                    return workspace.validateRelativeDirectory(sourceDirectory);
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return FormValidation.ok();
    }

    static class SourceDirectoryValidator {
        SourceDirectoryValidator() {
        }

        boolean isAllowedSourceDirectory(String sourceDirectory) {
            return PrismConfiguration.getInstance().isAllowedSourceDirectory(sourceDirectory);
        }
    }
}

