// CHECKSTYLE:OFF

package io.jenkins.plugins.prism;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code SourceCodeRetention.NEVER}: {@code Never store source

     * code}.
     * 
     * @return
     *     {@code Never store source code}
     */
    public static String SourceCodeRetention_NEVER() {
        return holder.format("SourceCodeRetention.NEVER");
    }

    /**
     * Key {@code SourceCodeRetention.NEVER}: {@code Never store source

     * code}.
     * 
     * @return
     *     {@code Never store source code}
     */
    public static Localizable _SourceCodeRetention_NEVER() {
        return new Localizable(holder, "SourceCodeRetention.NEVER");
    }

    /**
     * Key {@code SourceCodeRetention.EVERY_BUILD}: {@code Store source code

     * of every build}.
     * 
     * @return
     *     {@code Store source code of every build}
     */
    public static String SourceCodeRetention_EVERY_BUILD() {
        return holder.format("SourceCodeRetention.EVERY_BUILD");
    }

    /**
     * Key {@code SourceCodeRetention.EVERY_BUILD}: {@code Store source code

     * of every build}.
     * 
     * @return
     *     {@code Store source code of every build}
     */
    public static Localizable _SourceCodeRetention_EVERY_BUILD() {
        return new Localizable(holder, "SourceCodeRetention.EVERY_BUILD");
    }

    /**
     * Key {@code SourceCodeRetention.LAST_BUILD}: {@code Store source code

     * of last build only}.
     * 
     * @return
     *     {@code Store source code of last build only}
     */
    public static String SourceCodeRetention_LAST_BUILD() {
        return holder.format("SourceCodeRetention.LAST_BUILD");
    }

    /**
     * Key {@code SourceCodeRetention.LAST_BUILD}: {@code Store source code

     * of last build only}.
     * 
     * @return
     *     {@code Store source code of last build only}
     */
    public static Localizable _SourceCodeRetention_LAST_BUILD() {
        return new Localizable(holder, "SourceCodeRetention.LAST_BUILD");
    }

    /**
     * Key {@code SourceCodeRetention.MODIFIED}: {@code Store source code of

     * modified files only}.
     * 
     * @return
     *     {@code Store source code of modified files only}
     */
    public static String SourceCodeRetention_MODIFIED() {
        return holder.format("SourceCodeRetention.MODIFIED");
    }

    /**
     * Key {@code SourceCodeRetention.MODIFIED}: {@code Store source code of

     * modified files only}.
     * 
     * @return
     *     {@code Store source code of modified files only}
     */
    public static Localizable _SourceCodeRetention_MODIFIED() {
        return new Localizable(holder, "SourceCodeRetention.MODIFIED");
    }

    /**
     * Key {@code FieldValidator.Error.DefaultEncoding}: {@code Encoding must

     * be a supported encoding of the Java platform, see: <a rel="noopener

     * noreferrer" href="{0}">java.nio.charset.Charset</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encoding must be a supported encoding of the Java platform,

     *     see: <a rel="noopener noreferrer"

     *     href="{0}">java.nio.charset.Charset</a>}
     */
    public static String FieldValidator_Error_DefaultEncoding(Object arg0) {
        return holder.format("FieldValidator.Error.DefaultEncoding", arg0);
    }

    /**
     * Key {@code FieldValidator.Error.DefaultEncoding}: {@code Encoding must

     * be a supported encoding of the Java platform, see: <a rel="noopener

     * noreferrer" href="{0}">java.nio.charset.Charset</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encoding must be a supported encoding of the Java platform,

     *     see: <a rel="noopener noreferrer"

     *     href="{0}">java.nio.charset.Charset</a>}
     */
    public static Localizable _FieldValidator_Error_DefaultEncoding(Object arg0) {
        return new Localizable(holder, "FieldValidator.Error.DefaultEncoding", arg0);
    }

}
